/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.AbstractValidator;
import org.infoglue.cms.util.validators.Range;

public class IntegerValidator
extends AbstractValidator {
    private static final String ILLEGAL_VALUE_ERROR_CODE = "306";
    private Range valueSpace;

    IntegerValidator(String fieldName, boolean isRequired, int lowerLimit, int upperLimit) {
        super(fieldName, isRequired);
        this.valueSpace = new Range(lowerLimit, upperLimit);
    }

    public void validate(Integer value) throws ConstraintException {
        this.validateIsRequired(value);
        if (value == null) {
            return;
        }
        this.validateValueSpace(value);
        this.failIfAnyExceptionsFound();
    }

    public void validate(Integer value, ConstraintExceptionBuffer ceb) {
        try {
            this.validate(value);
        }
        catch (ConstraintException e) {
            ceb.add(e);
        }
    }

    private void validateValueSpace(Integer value) {
        if (!this.valueSpace.isWithinLimits(value)) {
            this.addConstraintException(ILLEGAL_VALUE_ERROR_CODE);
        }
    }
}

