/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.validators.AbstractValidator;

public class FloatValidator
extends AbstractValidator {
    private static final String ILLEGAL_VALUE_ERROR_CODE = "306";
    private float lowerLimit;
    private float upperLimit;

    FloatValidator(String fieldName, boolean isRequired, float lowerLimit, float upperLimit) {
        super(fieldName, isRequired);
        if (lowerLimit > upperLimit) {
            throw new Bug("Illegal arguments : lowerLimit=" + lowerLimit + ", upperLimit=" + upperLimit + ".");
        }
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
    }

    public void validate(Float value) throws ConstraintException {
        this.validateIsRequired(value);
        if (value == null) {
            return;
        }
        this.validateValueSpace(value.floatValue());
        this.failIfAnyExceptionsFound();
    }

    public void validate(Float value, ConstraintExceptionBuffer ceb) {
        try {
            this.validate(value);
        }
        catch (ConstraintException e) {
            ceb.add(e);
        }
    }

    private void validateValueSpace(float value) {
        if (value < this.lowerLimit || value > this.upperLimit) {
            this.addConstraintException(ILLEGAL_VALUE_ERROR_CODE);
        }
    }
}

