/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.util.ValidatorUtils;

public class CommonsValidator {
    public static final String FIELD_TEST_NULL = "NULL";
    public static final String FIELD_TEST_NOTNULL = "NOTNULL";
    public static final String FIELD_TEST_EQUAL = "EQUAL";
    private static Class stringClass = new String().getClass();

    public static boolean validateRaiseException(Object bean, Field field) throws Exception {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        if ("RUNTIME".equals(value)) {
            throw new RuntimeException("RUNTIME-EXCEPTION");
        }
        if ("CHECKED".equals(value)) {
            throw new Exception("CHECKED-EXCEPTION");
        }
        throw new ValidatorException("VALIDATOR-EXCEPTION");
    }

    public static boolean validateRequired(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return !GenericValidator.isBlankOrNull((String)value);
    }

    public static boolean validateByte(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isByte((String)value);
    }

    public static boolean validateShort(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isShort((String)value);
    }

    public static boolean validateInt(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isInt((String)value);
    }

    public static boolean validatePositive(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericTypeValidator.formatInt((String)value) > 0;
    }

    public static boolean validateLong(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isLong((String)value);
    }

    public static boolean validateFloat(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isFloat((String)value);
    }

    public static boolean validateDouble(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isDouble((String)value);
    }

    public static boolean validateEmail(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        return GenericValidator.isEmail((String)value);
    }

    public static boolean validateRegexp(Object bean, Field field) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String regexp = field.getVarValue("regexp");
        boolean valid = value.matches(regexp);
        return valid;
    }

    public static boolean validateRequiredIf(Object bean, Field field, Validator validator) {
        String value = ValidatorUtils.getValueAsString((Object)bean, (String)field.getProperty());
        String dependentValue = ValidatorUtils.getValueAsString((Object)bean, (String)field.getVarValue("dependent"));
        return dependentValue == null || dependentValue.length() == 0 || value != null && value.length() > 0;
    }

    private static boolean isString(Object o) {
        if (o == null) {
            return true;
        }
        return stringClass.isInstance(o);
    }
}

