/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.validators;

import java.util.regex.Pattern;
import org.infoglue.cms.controllers.kernel.impl.simple.ValidationController;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.ConstraintExceptionBuffer;

public abstract class AbstractValidator {
    private static final String REQUIRED_FIELD_ERROR_CODE = "300";
    private static final String NOTUNIQUE_FIELD_ERROR_CODE = "302";
    private ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
    private String fieldName;
    private boolean isRequired;
    private boolean mustBeUnique;
    private Class objectClass = null;
    private Integer excludeId = null;
    private Object excludeObject = null;

    protected AbstractValidator(String fieldName) {
        this(fieldName, true);
    }

    protected AbstractValidator(String fieldName, boolean isRequired) {
        this.fieldName = fieldName;
        this.isRequired = isRequired;
    }

    protected AbstractValidator(String fieldName, boolean isRequired, boolean mustBeUnique, Class objectClass, Integer excludeId, Object excludeObject) {
        this.fieldName = fieldName;
        this.isRequired = isRequired;
        this.mustBeUnique = mustBeUnique;
        this.objectClass = objectClass;
        this.excludeId = excludeId;
        this.excludeObject = excludeObject;
    }

    private final ConstraintException createConstraintException(String errorCode) {
        return new ConstraintException(this.fieldName, errorCode);
    }

    protected void validateIsRequired(Object value) throws ConstraintException {
        if (this.isRequired && value == null) {
            throw this.createConstraintException(REQUIRED_FIELD_ERROR_CODE);
        }
    }

    protected void validateUniqueness(String value) throws ConstraintException, SystemException {
        Pattern p;
        String[] arrString;
        String cleanField;
        if (this.mustBeUnique && ValidationController.fieldValueExists(this.objectClass, cleanField = (arrString = (p = Pattern.compile("[.\\s]+")).split(this.fieldName))[arrString.length - 1], value, this.excludeId, this.excludeObject)) {
            throw this.createConstraintException(NOTUNIQUE_FIELD_ERROR_CODE);
        }
    }

    protected final void addConstraintException(String errorCode) {
        this.ceb.add(this.createConstraintException(errorCode));
    }

    protected final void failIfAnyExceptionsFound() throws ConstraintException {
        this.ceb.throwIfNotEmpty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean isRequired) {
        this.isRequired = isRequired;
    }

    public boolean isMustBeUnique() {
        return this.mustBeUnique;
    }

    public void setMustBeUnique(boolean mustBeUnique) {
        this.mustBeUnique = mustBeUnique;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public Integer getExcludeId() {
        return this.excludeId;
    }

    public void setExcludeId(Integer excludeId) {
        this.excludeId = excludeId;
    }

    public Object getExcludeObject() {
        return this.excludeObject;
    }

    public void setExcludeObject(Object excludeObject) {
        this.excludeObject = excludeObject;
    }
}

