/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.lang.reflect.Constructor;
import org.apache.commons.beanutils.PropertyUtils;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.util.sorters.CompoundComparable;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;

public class SortElement
implements Comparable {
    private final TemplateController controller;
    private ContentVersionVO contentVersionVO;
    private ContentVO contentVO;
    private final CompoundComparable comparable = new CompoundComparable();

    SortElement(TemplateController controller, ContentVO contentVO) {
        this.controller = controller;
        this.contentVO = contentVO;
    }

    SortElement(TemplateController controller, ContentVersionVO contentVersionVO) {
        this.controller = controller;
        this.contentVersionVO = contentVersionVO;
    }

    public void addContentProperty(String name, boolean ascending) {
        this.comparable.add(this.getProperty(this.getContentVO(), name), ascending);
    }

    public void addContentVersionProperty(String name, boolean ascending) {
        this.comparable.add(this.getProperty(this.getContentVersionVO(), name), ascending);
    }

    public void addContentVersionAttribute(String name, Class clazz, boolean ascending, boolean caseSensitive) {
        Integer contentId = this.getContentId();
        String stringValue = this.controller.getContentAttribute(contentId, this.controller.getLanguageId(), name);
        if (!caseSensitive) {
            stringValue = stringValue.toLowerCase();
        }
        this.comparable.add(this.castAttribute(name, clazz, stringValue), ascending);
    }

    private Comparable castAttribute(String name, Class clazz, String stringValue) {
        if (String.class.equals((Object)clazz)) {
            return stringValue;
        }
        try {
            Constructor ctor = clazz.getConstructor(String.class);
            String s = Number.class.isAssignableFrom(clazz) && stringValue.equals("") ? "0" : stringValue;
            return (Comparable)ctor.newInstance(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Unable to cast [" + name + "] to [" + clazz.getName() + "].");
        }
    }

    private Integer getContentId() {
        return this.contentVO != null ? this.getContentVO().getContentId() : this.getContentVersionVO().getContentId();
    }

    private Comparable getProperty(Object o, String name) {
        try {
            return (Comparable)PropertyUtils.getProperty((Object)o, (String)name);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Illegal property [" + name + "] : " + e);
        }
    }

    public ContentVersionVO getContentVersionVO() {
        if (this.contentVersionVO == null) {
            this.contentVersionVO = this.controller.getContentVersion(this.contentVO.getContentId());
        }
        return this.contentVersionVO;
    }

    public ContentVO getContentVO() {
        if (this.contentVO == null) {
            this.contentVO = this.controller.getContent(this.contentVersionVO.getContentId());
        }
        return this.contentVO;
    }

    public final int compareTo(Object o) {
        if (!(o instanceof SortElement)) {
            throw new ClassCastException();
        }
        SortElement other = (SortElement)o;
        return this.comparable.compareTo(other.comparable);
    }
}

