/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;

public class SiteNodeComparator
implements Comparator {
    private static final Logger logger = Logger.getLogger((String)SiteNodeComparator.class.getName());
    private String sortProperty;
    private String sortOrder;
    private TemplateController templateController;

    public SiteNodeComparator(String sortProperty, String sortOrder, TemplateController templateController) {
        this.sortProperty = sortProperty;
        this.sortOrder = sortOrder;
        this.templateController = templateController;
    }

    public int compare(Object o1, Object o2) {
        SiteNodeVO siteNodeVO1 = (SiteNodeVO)o1;
        SiteNodeVO siteNodeVO2 = (SiteNodeVO)o2;
        Object valueOne = (String)siteNodeVO1.getExtraProperties().get(this.sortProperty);
        Object valueTwo = (String)siteNodeVO2.getExtraProperties().get(this.sortProperty);
        long previousTime = System.currentTimeMillis();
        if (valueOne == null) {
            valueOne = this.getProperty(o1, this.sortProperty);
            valueTwo = this.getProperty(o2, this.sortProperty);
        }
        if (valueOne == null && this.templateController != null) {
            Integer meta1Id = this.templateController.getMetaInformationContentId(siteNodeVO1.getId());
            Integer meta2Id = this.templateController.getMetaInformationContentId(siteNodeVO2.getId());
            valueOne = this.templateController.getContentAttribute(meta1Id, this.templateController.getLanguageId(), this.sortProperty);
            valueTwo = this.templateController.getContentAttribute(meta2Id, this.templateController.getLanguageId(), this.sortProperty);
        }
        if (valueOne != null && valueTwo != null) {
            if (this.sortOrder.equalsIgnoreCase("desc")) {
                return valueTwo.compareTo(valueOne);
            }
            return valueOne.compareTo(valueTwo);
        }
        return 0;
    }

    private Comparable getProperty(Object o, String property) {
        try {
            Object propertyObject = PropertyUtils.getProperty((Object)o, (String)this.sortProperty);
            if (propertyObject instanceof String) {
                return propertyObject.toString().toLowerCase();
            }
            return (Comparable)propertyObject;
        }
        catch (Exception e) {
            logger.info((Object)(String.valueOf(this.getClass().getName()) + " Error finding property " + property), (Throwable)e);
            return null;
        }
    }
}

