/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.infoglue.deliver.applications.databeans.WebPage;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;

public class PageComparator
implements Comparator {
    private static final Logger logger = Logger.getLogger((String)PageComparator.class.getName());
    private String sortProperty;
    private String sortOrder;
    private boolean numberOrder;
    private TemplateController templateController;

    public PageComparator(String sortProperty, String sortOrder, boolean numberOrder, TemplateController templateController) {
        this.sortProperty = sortProperty;
        this.sortOrder = sortOrder;
        this.numberOrder = numberOrder;
        this.templateController = templateController;
    }

    public int compare(Object o1, Object o2) {
        Object valueOne = this.getProperty(o1, this.sortProperty);
        Object valueTwo = this.getProperty(o2, this.sortProperty);
        if (valueOne == null) {
            WebPage webPage1 = (WebPage)o1;
            WebPage webPage2 = (WebPage)o2;
            Integer meta1Id = this.templateController.getMetaInformationContentId(webPage1.getSiteNodeId());
            Integer meta2Id = this.templateController.getMetaInformationContentId(webPage2.getSiteNodeId());
            valueOne = this.templateController.getContentAttribute(meta1Id, this.templateController.getLanguageId(), this.sortProperty);
            valueTwo = this.templateController.getContentAttribute(meta2Id, this.templateController.getLanguageId(), this.sortProperty);
            if (this.numberOrder) {
                try {
                    valueOne = valueOne != null && !valueOne.equals("") ? new Long(valueOne.toString()) : (this.sortOrder.equalsIgnoreCase("desc") ? new Long(Long.MIN_VALUE) : new Long(Long.MAX_VALUE));
                }
                catch (Exception e) {
                    logger.info((Object)("Not a number..." + e.getMessage()));
                }
                try {
                    valueTwo = valueTwo != null && !valueTwo.equals("") ? new Long(valueTwo.toString()) : (this.sortOrder.equalsIgnoreCase("desc") ? new Long(Long.MIN_VALUE) : new Long(Long.MAX_VALUE));
                }
                catch (Exception e) {
                    logger.info((Object)("Not a number..." + e.getMessage()));
                }
            }
        }
        if (this.sortOrder.equalsIgnoreCase("desc")) {
            if (valueOne != null && !valueOne.toString().equalsIgnoreCase("") && (valueTwo == null || valueTwo.toString().equalsIgnoreCase(""))) {
                return -1;
            }
            if (valueTwo != null && !valueTwo.toString().equalsIgnoreCase("") && (valueOne == null || valueOne.toString().equalsIgnoreCase(""))) {
                return 1;
            }
            return valueTwo.compareTo(valueOne);
        }
        if (valueOne != null && !valueOne.toString().equalsIgnoreCase("") && (valueTwo == null || valueTwo.toString().equalsIgnoreCase(""))) {
            return -1;
        }
        if (valueTwo != null && !valueTwo.toString().equalsIgnoreCase("") && (valueOne == null || valueOne.toString().equalsIgnoreCase(""))) {
            return 1;
        }
        return valueOne.compareTo(valueTwo);
    }

    private Comparable getProperty(Object o, String property) {
        try {
            Object propertyObject = PropertyUtils.getProperty((Object)o, (String)this.sortProperty);
            if (propertyObject instanceof String) {
                if (this.numberOrder) {
                    try {
                        return new Long(propertyObject.toString());
                    }
                    catch (Exception e) {
                        logger.info((Object)("Not a number..." + e.getMessage()));
                    }
                }
                return propertyObject.toString().toLowerCase();
            }
            return (Comparable)propertyObject;
        }
        catch (Exception e) {
            logger.info((Object)(String.valueOf(this.getClass().getName()) + " Error finding property " + property), (Throwable)e);
            return null;
        }
    }
}

