/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.infoglue.deliver.applications.databeans.WebPage;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;

public class HardcodedPageComparator
implements Comparator {
    private static final Logger logger = Logger.getLogger((String)HardcodedPageComparator.class.getName());
    private String sortProperty;
    private String sortOrder;
    private boolean numberOrder;
    private String nameProperty;
    private String namesInOrderString;
    private TemplateController templateController;

    public HardcodedPageComparator(String sortProperty, String sortOrder, boolean numberOrder, String nameProperty, String namesInOrderString, TemplateController templateController) {
        this.sortProperty = sortProperty;
        this.sortOrder = sortOrder;
        this.numberOrder = numberOrder;
        this.nameProperty = nameProperty;
        this.namesInOrderString = namesInOrderString;
        this.templateController = templateController;
    }

    public int compare(Object o1, Object o2) {
        Object valueOne = this.getProperty(o1, this.sortProperty);
        Object valueTwo = this.getProperty(o2, this.sortProperty);
        Object valueOneName = this.getProperty(o1, this.nameProperty);
        Object valueTwoName = this.getProperty(o2, this.nameProperty);
        if (valueOne == null) {
            WebPage webPage1 = (WebPage)o1;
            WebPage webPage2 = (WebPage)o2;
            Integer meta1Id = webPage1.getMetaInfoContentId();
            Integer meta2Id = webPage2.getMetaInfoContentId();
            valueOne = this.templateController.getContentAttribute(meta1Id, this.templateController.getLanguageId(), this.sortProperty);
            valueTwo = this.templateController.getContentAttribute(meta2Id, this.templateController.getLanguageId(), this.sortProperty);
            if (valueOneName == null) {
                valueOneName = this.templateController.getContentAttribute(meta1Id, this.templateController.getLanguageId(), this.nameProperty);
                valueTwoName = this.templateController.getContentAttribute(meta2Id, this.templateController.getLanguageId(), this.nameProperty);
            }
            if (this.numberOrder) {
                try {
                    valueOne = valueOne != null && !valueOne.equals("") ? new Long(valueOne.toString()) : (this.sortOrder.equalsIgnoreCase("desc") ? new Long(Long.MIN_VALUE) : new Long(Long.MAX_VALUE));
                }
                catch (Exception e) {
                    logger.info((Object)("Not a number..." + e.getMessage()));
                }
                try {
                    valueTwo = valueTwo != null && !valueTwo.equals("") ? new Long(valueTwo.toString()) : (this.sortOrder.equalsIgnoreCase("desc") ? new Long(Long.MIN_VALUE) : new Long(Long.MAX_VALUE));
                }
                catch (Exception e) {
                    logger.info((Object)("Not a number..." + e.getMessage()));
                }
            }
        }
        if (this.after((Comparable)valueOne, (Comparable)valueTwo, (Comparable)valueOneName, (Comparable)valueTwoName)) {
            return 1;
        }
        return -1;
    }

    private boolean after(Comparable valueOne, Comparable valueTwo, Comparable valueOneName, Comparable valueTwoName) {
        int result;
        int index1 = this.namesInOrderString.indexOf(valueOneName.toString());
        int index2 = this.namesInOrderString.indexOf(valueTwoName.toString());
        if (index1 != -1 && index2 != -1) {
            return index1 > index2;
        }
        if (index1 == -1 && index2 != -1) {
            return true;
        }
        if (index2 == -1 && index1 != -1) {
            return false;
        }
        if (this.sortOrder.equalsIgnoreCase("desc")) {
            int n;
            if (valueOne != null && !valueOne.toString().equalsIgnoreCase("") && (valueTwo == null || valueTwo.toString().equalsIgnoreCase(""))) {
                n = -1;
            }
            if (valueTwo != null && !valueTwo.toString().equalsIgnoreCase("") && (valueOne == null || valueOne.toString().equalsIgnoreCase(""))) {
                n = 1;
            }
            result = valueTwo.compareTo(valueOne);
        } else {
            if (valueOne != null && !valueOne.toString().equalsIgnoreCase("") && (valueTwo == null || valueTwo.toString().equalsIgnoreCase(""))) {
                result = -1;
            }
            if (valueTwo != null && !valueTwo.toString().equalsIgnoreCase("") && (valueOne == null || valueOne.toString().equalsIgnoreCase(""))) {
                result = 1;
            }
            result = valueOne.compareTo(valueTwo);
        }
        return result > 0;
    }

    private Comparable getProperty(Object o, String property) {
        try {
            Object propertyObject = PropertyUtils.getProperty((Object)o, (String)this.sortProperty);
            if (propertyObject instanceof String) {
                return propertyObject.toString().toLowerCase();
            }
            return (Comparable)propertyObject;
        }
        catch (Exception e) {
            logger.info((Object)(String.valueOf(this.getClass().getName()) + " Error finding property " + property), (Throwable)e);
            return null;
        }
    }
}

