/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.infoglue.cms.entities.content.Content;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.util.sorters.SortElement;
import org.infoglue.cms.util.sorters.TemplateControllerAwareComparator;
import org.infoglue.deliver.controllers.kernel.impl.simple.TemplateController;

public class ContentSort {
    TemplateController controller;
    private final List elements = new ArrayList();

    public ContentSort(TemplateController controller, Collection elements) {
        this.controller = controller;
        this.addElements(elements);
    }

    private final void addElements(Collection elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        Object element = elements.toArray()[0];
        if (element instanceof Content) {
            this.initializeWithContent(elements);
        }
        if (element instanceof ContentVO) {
            this.initializeWithContentVO(elements);
        }
        if (element instanceof ContentVersion) {
            this.initializeWithContentVersion(elements);
        }
        if (element instanceof ContentVersionVO) {
            this.initializeWithContentVersionVO(elements);
        }
    }

    private final void initializeWithContent(Collection elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.addElement(((Content)i.next()).getValueObject());
        }
    }

    private final void initializeWithContentVO(Collection elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.addElement((ContentVO)i.next());
        }
    }

    private final void initializeWithContentVersion(Collection elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.addElement(((ContentVersion)i.next()).getValueObject());
        }
    }

    private final void initializeWithContentVersionVO(Collection elements) {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            this.addElement((ContentVersionVO)i.next());
        }
    }

    public void addContentProperty(String name, boolean ascending) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            ((SortElement)i.next()).addContentProperty(name, ascending);
        }
    }

    public void addContentVersionProperty(String name, boolean ascending) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            ((SortElement)i.next()).addContentVersionProperty(name, ascending);
        }
    }

    public void addContentVersionAttribute(String name, boolean ascending, boolean caseSensitive) {
        this.addContentVersionAttribute(name, String.class, ascending, caseSensitive);
    }

    public void addContentVersionAttribute(String name, String className, boolean ascending, boolean caseSensitive) {
        try {
            this.addContentVersionAttribute(name, Class.forName(className), ascending, caseSensitive);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void addContentVersionAttribute(String name, Class clazz, boolean ascending, boolean caseSensitive) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            ((SortElement)i.next()).addContentVersionAttribute(name, clazz, ascending, caseSensitive);
        }
    }

    private void addElement(ContentVO contentVO) {
        this.elements.add(new SortElement(this.controller, contentVO));
    }

    private void addElement(ContentVersionVO contentVersionVO) {
        this.elements.add(new SortElement(this.controller, contentVersionVO));
    }

    public List getContentResult() {
        Collections.sort(this.elements);
        ArrayList<ContentVO> result = new ArrayList<ContentVO>();
        for (SortElement struct : this.elements) {
            result.add(struct.getContentVO());
        }
        return result;
    }

    public List getContentResult(String comparatorClass) {
        TemplateControllerAwareComparator comp;
        block7: {
            comp = null;
            if (comparatorClass != null && !comparatorClass.equals("")) {
                try {
                    Class<?> clazz = Class.forName(comparatorClass);
                    if (clazz == null) break block7;
                    try {
                        comp = (TemplateControllerAwareComparator)clazz.newInstance();
                        comp.setController(this.controller);
                        break block7;
                    }
                    catch (InstantiationException e) {
                        throw new IllegalArgumentException("Couldnt instantiate comparator class " + comparatorClass + " " + e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("Couldnt access comparator class " + comparatorClass + " " + e.getMessage());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Couldnt find comparator class " + comparatorClass + " " + e.getMessage());
                }
            }
            throw new IllegalArgumentException("Must specify a comparator classname");
        }
        Collections.sort(this.elements, comp);
        ArrayList<ContentVO> result = new ArrayList<ContentVO>();
        for (SortElement struct : this.elements) {
            result.add(struct.getContentVO());
        }
        return result;
    }

    public List getContentVersionResult() {
        Collections.sort(this.elements);
        ArrayList<ContentVersionVO> result = new ArrayList<ContentVersionVO>();
        for (SortElement struct : this.elements) {
            result.add(struct.getContentVersionVO());
        }
        return result;
    }
}

