/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.sorters;

import java.util.Comparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.deliver.controllers.kernel.impl.simple.BasicTemplateController;

public class ContentComparator
implements Comparator {
    private static final Logger logger = Logger.getLogger((String)ContentComparator.class.getName());
    private String sortProperty;
    private String sortOrder;
    private BasicTemplateController basicTemplateController;
    private Database db;
    public long extractTime = 0L;

    public ContentComparator(String sortProperty, String sortOrder, BasicTemplateController basicTemplateController) {
        this.sortProperty = sortProperty;
        this.sortOrder = sortOrder;
        this.basicTemplateController = basicTemplateController;
        this.extractTime = 0L;
    }

    public int compare(Object o1, Object o2) {
        ContentVO contentVO1 = (ContentVO)o1;
        ContentVO contentVO2 = (ContentVO)o2;
        Object valueOne = (String)contentVO1.getExtraProperties().get(this.sortProperty);
        Object valueTwo = (String)contentVO2.getExtraProperties().get(this.sortProperty);
        long previousTime = System.currentTimeMillis();
        if (valueOne == null) {
            valueOne = this.getProperty(o1, this.sortProperty);
            valueTwo = this.getProperty(o2, this.sortProperty);
        }
        if (valueOne == null && this.basicTemplateController != null) {
            valueOne = this.basicTemplateController.getContentAttribute(contentVO1.getId(), this.basicTemplateController.getLanguageId(), this.sortProperty);
            valueTwo = this.basicTemplateController.getContentAttribute(contentVO2.getId(), this.basicTemplateController.getLanguageId(), this.sortProperty);
        }
        int result = this.sortOrder.equalsIgnoreCase("desc") ? valueTwo.compareTo(valueOne) : valueOne.compareTo(valueTwo);
        long elapsedTime = System.currentTimeMillis() - previousTime;
        this.extractTime += elapsedTime;
        return result;
    }

    private Comparable getProperty(Object o, String property) {
        try {
            Object propertyObject = PropertyUtils.getProperty((Object)o, (String)this.sortProperty);
            if (propertyObject instanceof String) {
                return propertyObject.toString().toLowerCase();
            }
            return (Comparable)propertyObject;
        }
        catch (Exception e) {
            logger.info((Object)(String.valueOf(this.getClass().getName()) + " Error finding property " + property), (Throwable)e);
            return null;
        }
    }
}

