/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.MailService;

public class MailServiceFactory {
    private static Session session;

    public static synchronized MailService getService() throws Exception {
        if (session == null) {
            session = MailServiceFactory.initializeSession();
        }
        return new MailService(session);
    }

    private MailServiceFactory() {
    }

    private static Session initializeSession() throws Exception {
        Properties properties = CmsPropertyHandler.getProperties();
        Properties props = new Properties();
        boolean needsAuthentication = false;
        try {
            needsAuthentication = new Boolean((String)properties.get("mail.smtp.auth"));
        }
        catch (Exception ex) {
            needsAuthentication = false;
        }
        if (needsAuthentication) {
            final String uName = (String)properties.get("mail.smtp.user");
            final String uPass = (String)properties.get("mail.smtp.password");
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(uName, uPass);
                }
            };
            return Session.getInstance((Properties)properties, (Authenticator)authenticator);
        }
        return Session.getInstance((Properties)properties);
    }
}

