/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.log4j.Logger;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.mail.StringDataSource;

public class MailService {
    private static final Logger logger = Logger.getLogger((String)MailService.class.getName());
    private Session session;

    public MailService(Session session) {
        this.session = session;
    }

    public MimeMessage createMessage() {
        return new MimeMessage(this.session);
    }

    public void send(Message message) throws SystemException {
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new SystemException("Unable to send message.", e);
        }
    }

    public void send(String from, String to, String bcc, String subject, String content) throws SystemException {
        this.send(this.createMessage(from, to, bcc, subject, content));
    }

    public void send(String from, String to, String subject, String content, String contentType, String encoding) throws SystemException {
        Message message = this.createMessage(from, to, null, subject, content, contentType, encoding);
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
            throw new SystemException("Unable to send message.", e);
        }
    }

    public void sendEmail(String from, String to, String bcc, String subject, String content, String encoding) throws SystemException {
        this.sendEmail(from, to, null, bcc, subject, content, encoding);
    }

    public void sendEmail(String from, String to, String cc, String bcc, String subject, String content, String encoding) throws SystemException {
        String contentType = CmsPropertyHandler.getMailContentType();
        if (contentType == null || contentType.length() == 0) {
            contentType = "text/html";
        }
        if (contentType.equalsIgnoreCase("text/html")) {
            this.sendHTML(from, to, cc, bcc, subject, content, encoding);
        } else {
            this.sendPlain(from, to, cc, bcc, subject, content, encoding);
        }
    }

    public void sendEmail(String contentType, String from, String to, String cc, String bcc, String subject, String content, String encoding) throws SystemException {
        if (contentType.equalsIgnoreCase("text/html")) {
            this.sendHTML(from, to, cc, bcc, subject, content, encoding);
        } else {
            this.sendPlain(from, to, cc, bcc, subject, content, encoding);
        }
    }

    public void sendHTML(String from, String to, String cc, String bcc, String subject, String content, String encoding) throws SystemException {
        try {
            HtmlEmail email = new HtmlEmail();
            String mailServer = CmsPropertyHandler.getMailSmtpHost();
            String mailPort = CmsPropertyHandler.getMailSmtpPort();
            String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
            email.setHostName(mailServer);
            if (mailPort != null && !mailPort.equals("")) {
                email.setSmtpPort(Integer.parseInt(mailPort));
            }
            boolean needsAuthentication = false;
            try {
                needsAuthentication = new Boolean(CmsPropertyHandler.getMailSmtpAuth());
            }
            catch (Exception ex) {
                needsAuthentication = false;
            }
            if (needsAuthentication) {
                String userName = CmsPropertyHandler.getMailSmtpUser();
                String password = CmsPropertyHandler.getMailSmtpPassword();
                email.setAuthentication(userName, password);
            }
            email.setBounceAddress(systemEmailSender);
            email.setCharset(encoding);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("systemEmailSender:" + systemEmailSender));
                logger.info((Object)("to:" + to));
                logger.info((Object)("from:" + from));
                logger.info((Object)("mailServer:" + mailServer));
                logger.info((Object)("mailPort:" + mailPort));
                logger.info((Object)("cc:" + cc));
                logger.info((Object)("bcc:" + bcc));
                logger.info((Object)("subject:" + subject));
            }
            email.addTo(to, to);
            email.setFrom(from, from);
            if (cc != null) {
                email.setCc((Collection)this.createInternetAddressesList(cc));
            }
            if (bcc != null) {
                email.setBcc((Collection)this.createInternetAddressesList(bcc));
            }
            email.setSubject(subject);
            email.setHtmlMsg(content);
            email.setTextMsg("Your email client does not support HTML messages");
            email.send();
            logger.info((Object)"Email sent!");
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to send this mail:" + e.getMessage()), (Throwable)e);
            throw new SystemException("An error occurred when we tried to send this mail:" + e.getMessage(), e);
        }
    }

    public void sendPlain(String from, String to, String cc, String bcc, String subject, String content, String encoding) throws SystemException {
        try {
            SimpleEmail email = new SimpleEmail();
            String mailServer = CmsPropertyHandler.getMailSmtpHost();
            String mailPort = CmsPropertyHandler.getMailSmtpPort();
            String systemEmailSender = CmsPropertyHandler.getSystemEmailSender();
            email.setHostName(mailServer);
            if (mailPort != null && !mailPort.equals("")) {
                email.setSmtpPort(Integer.parseInt(mailPort));
            }
            boolean needsAuthentication = false;
            try {
                needsAuthentication = new Boolean(CmsPropertyHandler.getMailSmtpAuth());
            }
            catch (Exception ex) {
                needsAuthentication = false;
            }
            if (needsAuthentication) {
                String userName = CmsPropertyHandler.getMailSmtpUser();
                String password = CmsPropertyHandler.getMailSmtpPassword();
                email.setAuthentication(userName, password);
            }
            email.setBounceAddress(systemEmailSender);
            email.setCharset(encoding);
            email.addTo(to, to);
            email.setFrom(from, from);
            if (cc != null) {
                email.setCc((Collection)this.createInternetAddressesList(cc));
            }
            if (bcc != null) {
                email.setBcc((Collection)this.createInternetAddressesList(bcc));
            }
            email.setSubject(subject);
            email.setMsg(content);
            email.send();
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we tried to send this mail:" + e.getMessage()), (Throwable)e);
        }
    }

    private Message createMessage(String from, String to, String bcc, String subject, String content) throws SystemException {
        try {
            MimeMessage message = new MimeMessage(this.session);
            message.setContent((Object)content, "text/html");
            message.setFrom(this.createInternetAddress(from));
            message.setRecipient(Message.RecipientType.TO, this.createInternetAddress(to));
            if (bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, this.createInternetAddresses(bcc));
            }
            message.setSubject(subject);
            message.setText(content);
            message.setDataHandler(new DataHandler((DataSource)new StringDataSource(content, "text/html")));
            return message;
        }
        catch (MessagingException e) {
            throw new Bug("Unable to create the message.", e);
        }
    }

    private Message createMessage(String from, String to, String bcc, String subject, String content, String contentType, String encoding) throws SystemException {
        try {
            MimeMessage message = new MimeMessage(this.session);
            String contentTypeWithEncoding = String.valueOf(contentType) + ";charset=" + encoding;
            message.setFrom(this.createInternetAddress(from));
            message.setRecipient(Message.RecipientType.TO, this.createInternetAddress(to));
            if (bcc != null) {
                message.setRecipients(Message.RecipientType.BCC, this.createInternetAddresses(bcc));
            }
            message.setSubject(subject, encoding);
            message.setDataHandler(new DataHandler((DataSource)new StringDataSource(content, contentTypeWithEncoding, encoding)));
            return message;
        }
        catch (MessagingException e) {
            throw new Bug("Unable to create the message.", e);
        }
    }

    private Address createInternetAddress(String address) {
        try {
            return new InternetAddress(address);
        }
        catch (AddressException e) {
            throw new Bug("Badly formatted email address [" + address + "].", e);
        }
    }

    private Address[] createInternetAddresses(String emailAddressString) throws SystemException {
        String[] emailAddresses = emailAddressString.split(";");
        Address[] addresses = new Address[emailAddresses.length];
        int i = 0;
        while (i < emailAddresses.length) {
            String email = emailAddresses[i];
            try {
                addresses[i] = new InternetAddress(email);
            }
            catch (AddressException e) {
                throw new SystemException("Badly formatted email address [" + email + "].", e);
            }
            ++i;
        }
        return addresses;
    }

    private List createInternetAddressesList(String emailAddressString) throws SystemException {
        String[] emailAddresses = emailAddressString.split(";");
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>();
        int i = 0;
        while (i < emailAddresses.length) {
            String email = emailAddresses[i];
            try {
                addresses.add(new InternetAddress(email));
            }
            catch (AddressException e) {
                throw new SystemException("Badly formatted email address [" + email + "].", e);
            }
            ++i;
        }
        return addresses;
    }
}

