/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.graphics;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;

public class ThumbnailGenerator {
    private static final Logger logger = Logger.getLogger((String)ThumbnailGenerator.class.getName());

    private void execCmd(String command) throws Exception {
        String line;
        logger.error((Object)command);
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = input.readLine()) != null) {
            logger.error((Object)line);
        }
        input.close();
    }

    public void transform(String originalFile, String thumbnailFile, int thumbWidth, int thumbHeight, int quality) throws Exception {
        int imageHeight;
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        BufferedImage image = ImageIO.read(new File(originalFile));
        int imageWidth = ((Image)image).getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = ((Image)image).getHeight(null));
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        if (imageWidth < thumbWidth && imageHeight < thumbHeight) {
            thumbWidth = imageWidth;
            thumbHeight = imageHeight;
        } else if (imageWidth < thumbWidth) {
            thumbWidth = imageWidth;
        } else if (imageHeight < thumbHeight) {
            thumbHeight = imageHeight;
        }
        if (thumbWidth < 1) {
            thumbWidth = 1;
        }
        if (thumbHeight < 1) {
            thumbHeight = 1;
        }
        if (CmsPropertyHandler.getExternalThumbnailGeneration() != null && !CmsPropertyHandler.getExternalThumbnailGeneration().equalsIgnoreCase("") && !CmsPropertyHandler.getExternalThumbnailGeneration().equalsIgnoreCase("@externalThumbnailGeneration@")) {
            String[] args = new String[]{CmsPropertyHandler.getExternalThumbnailGeneration(), "-resize", String.valueOf(String.valueOf(thumbWidth)) + "x" + String.valueOf(thumbHeight), originalFile, thumbnailFile};
            try {
                Process p = Runtime.getRuntime().exec(args);
                p.waitFor();
            }
            catch (InterruptedException e) {
                new Exception("Error resizing image for thumbnail", e);
            }
        } else {
            BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
            Graphics2D graphics2D = thumbImage.createGraphics();
            graphics2D.setBackground(Color.WHITE);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fillRect(0, 0, thumbWidth, thumbHeight);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
            ImageIO.write((RenderedImage)thumbImage, "JPG", new File(thumbnailFile));
        }
    }
}

