/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.io.FileHelper;
import org.xml.sax.InputSource;

public class DOMBuilder {
    private static final Logger logger = Logger.getLogger((String)DOMBuilder.class.getName());

    public Document createDocument() {
        return DocumentHelper.createDocument();
    }

    public Document getDocument(String xml) throws Exception {
        if (xml == null) {
            return null;
        }
        try {
            InputSource xmlSource = new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
            SAXReader xmlReader = new SAXReader();
            return xmlReader.read(xmlSource);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    public Document buildDocment(org.w3c.dom.Document domDocument) {
        DOMReader xmlReader = new DOMReader();
        return xmlReader.read(domDocument);
    }

    public Document getDocument(File file) throws Exception {
        if (file == null) {
            return null;
        }
        Document document = null;
        try {
            String xml = FileHelper.readUTF8FromFile(file);
            document = this.getDocument(xml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public Node selectSingleNode(Node contextNode, String xpathExpression, String namespaceName, String namespaceValue) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put(namespaceName, namespaceValue);
        XPath xpath = contextNode.createXPath(xpathExpression);
        xpath.setNamespaceURIs(namespaces);
        return xpath.selectSingleNode((Object)contextNode);
    }

    public Element addElement(Document document, String elementName) {
        Element newElement = document.addElement(elementName);
        return newElement;
    }

    public Element addElement(Element element, String elementName) {
        Element newElement = element.addElement(elementName);
        return newElement;
    }

    public void insertElement(Element element, Element childElement) {
        element.content().add(childElement);
    }

    public Element addTextElement(Element element, String text) {
        Element newElement = element.addText(text);
        return newElement;
    }

    public Element addCDATAElement(Element element, String text) {
        Element newElement = element.addCDATA(text);
        return newElement;
    }

    public void addAttribute(Element element, String attributeName, String attributeValue) {
        element.addAttribute(attributeName, attributeValue);
    }

    public void write(Document document, String fileName) throws Exception {
        OutputFormat format = OutputFormat.createCompactFormat();
        format.setEncoding("UTF-8");
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(fileName), format);
        writer.write(document);
        writer.close();
    }

    public void writePretty(Document document, String fileName) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(fileName), format);
        writer.write(document);
        writer.close();
    }

    public void writeDebug(Document document) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)System.out, format);
        writer.write(document);
    }

    public String encodeString(String value, String encoding) throws Exception {
        String encodedValue = new String(value.getBytes("UTF-8"), "ISO-8859-1");
        return encodedValue;
    }

    public void writeDebug(Element element) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((OutputStream)System.out, format);
        writer.write(element);
    }

    private String getEncodedString(Element element) throws Exception {
        OutputFormat outFormat = OutputFormat.createCompactFormat();
        outFormat.setEncoding("UTF-8");
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        XMLWriter out = new XMLWriter((OutputStream)bao, outFormat);
        out.write(element);
        out.flush();
        String s = bao.toString();
        logger.info((Object)("OUT: " + s));
        return s;
    }

    public String getFormattedDocument(Document doc, String encoding) {
        return this.getFormattedDocument(doc, true, false, encoding);
    }

    public String getFormattedDocument(Document doc, boolean compact, boolean supressDecl, String encoding) {
        OutputFormat format = compact ? OutputFormat.createCompactFormat() : OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(supressDecl);
        format.setEncoding(encoding);
        format.setExpandEmptyElements(false);
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter, format);
        try {
            writer.write(doc);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();
    }
}

