/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.infoglue.cms.util.NotificationListener;
import org.infoglue.cms.util.NotificationMessage;

public class XMLNotificationWriter
implements NotificationListener {
    private String boundary = "";
    private Writer out = null;
    private Thread workingThread = null;
    private XMLWriter xmlWriter = null;
    private XStream xStream = null;

    public XMLNotificationWriter(Writer out, String encoding, String boundary, Thread workingThread, boolean compact, boolean supressDecl) {
        this.out = out;
        this.boundary = boundary;
        this.workingThread = workingThread;
        OutputFormat format = compact ? OutputFormat.createCompactFormat() : OutputFormat.createPrettyPrint();
        format.setSuppressDeclaration(supressDecl);
        format.setEncoding(encoding);
        format.setExpandEmptyElements(!compact);
        this.xmlWriter = new XMLWriter(out, format);
        this.xStream = new XStream();
    }

    public void setContextParameters(Map map) {
    }

    public void notify(NotificationMessage message) {
        block3: {
            try {
                this.xmlWriter.write(DocumentHelper.parseText((String)this.xStream.toXML((Object)message)));
                this.xmlWriter.flush();
                this.out.write("\r\n" + this.boundary + "\r\n");
                this.out.flush();
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                if (this.workingThread == null) break block3;
                this.workingThread.interrupt();
            }
        }
    }
}

