/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    public static StringBuffer serializeDom(Node node, StringBuffer writeString) {
        short type = node.getNodeType();
        try {
            String outString;
            switch (type) {
                case 9: {
                    writeString.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writeString = XMLHelper.serializeDom(((Document)node).getDocumentElement(), writeString);
                    break;
                }
                case 1: {
                    writeString.append("<");
                    writeString.append(node.getNodeName());
                    NamedNodeMap attrs = node.getAttributes();
                    int i = 0;
                    while (i < attrs.getLength()) {
                        Node attr = attrs.item(i);
                        String outString2 = " " + attr.getNodeName() + "=\"" + XMLHelper.replaceSpecialCharacters(attr.getNodeValue()) + "\"";
                        writeString.append(outString2);
                        ++i;
                    }
                    writeString.append(">");
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i2 = 0;
                    while (i2 < len) {
                        writeString = XMLHelper.serializeDom(children.item(i2), writeString);
                        ++i2;
                    }
                    break;
                }
                case 5: {
                    outString = "&" + node.getNodeName() + ";";
                    writeString.append(outString);
                    break;
                }
                case 4: {
                    outString = "<![CDATA[" + node.getNodeValue() + "]]>";
                    writeString.append(outString);
                    break;
                }
                case 3: {
                    writeString.append(XMLHelper.replaceSpecialCharacters(node.getNodeValue()));
                    break;
                }
                case 7: {
                    String data = node.getNodeValue();
                    String outString3 = "<?" + node.getNodeName() + " " + data + "?>";
                    writeString.append(outString3);
                }
            }
            if (type == 1) {
                outString = "</" + node.getNodeName() + ">";
                writeString.append(outString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return writeString;
    }

    public static String replaceSpecialCharacters(String value) {
        if (value == null) {
            return "";
        }
        StringBuffer newValue = new StringBuffer();
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (c == '&') {
                newValue.append("&amp;");
            } else if (c == '<') {
                newValue.append("&lt;");
            } else if (c == '>') {
                newValue.append("&gt;");
            } else if (c == '\'') {
                newValue.append("&apos;");
            } else if (c == '\"') {
                newValue.append("&quot;");
            } else if (XMLHelper.isLegalCharacter(c)) {
                newValue.append(c);
            }
            ++i;
        }
        return newValue.toString();
    }

    private static boolean isLegalCharacter(int ch) {
        return ch == 9 || ch == 10 || ch == 13 || ch >= 32 && ch <= 65533 || ch >= 4096 && ch <= Integer.MAX_VALUE;
    }

    public static Document readDocumentFromFile(File xmlFile) throws IOException, SAXException {
        InputSource xmlSource = new InputSource(new FileReader(xmlFile));
        DOMParser parser = new DOMParser();
        parser.parse(xmlSource);
        return parser.getDocument();
    }

    public static Document readDocumentFromByteArray(byte[] xml) throws IOException, SAXException {
        InputSource xmlSource = new InputSource(new BufferedInputStream(new ByteArrayInputStream(xml)));
        DOMParser parser = new DOMParser();
        parser.parse(xmlSource);
        Document document = parser.getDocument();
        parser = null;
        return document;
    }
}

