/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.ChainedStringManager;
import org.infoglue.cms.util.SimpleStringManager;
import org.infoglue.cms.util.StringManager;

public class StringManagerFactory {
    private static final Logger logger = Logger.getLogger((String)StringManagerFactory.class.getName());
    private static final String SYSTEM = ".SystemStrings";
    private static final String PRESENTATION = ".PresentationStrings";
    private static Map managers = new HashMap();

    private StringManagerFactory() {
    }

    public static synchronized StringManager getSystemStringManager(String packageName) {
        return StringManagerFactory.getStringManager(packageName, SYSTEM, Locale.ENGLISH);
    }

    public static synchronized StringManager getPresentationStringManager(String packageName, Locale locale) {
        return StringManagerFactory.getStringManager(packageName, PRESENTATION, locale);
    }

    public static synchronized StringManager getPresentationStringManager(String[] packageNames, Locale locale) {
        logger.info((Object)"Getting stringManager");
        ChainedStringManager chain = new ChainedStringManager();
        int i = 0;
        while (i < packageNames.length) {
            chain.add(StringManagerFactory.getPresentationStringManager(packageNames[i], locale));
            ++i;
        }
        return chain;
    }

    private static StringManager getStringManager(String packageName, String suffix, Locale locale) {
        logger.info((Object)("packageName:" + packageName));
        String name = StringManagerFactory.getName(packageName, suffix, locale);
        String bundleName = StringManagerFactory.getBundleName(packageName, suffix);
        StringManager manager = (StringManager)managers.get(name);
        if (manager == null) {
            manager = new SimpleStringManager(bundleName, locale);
            managers.put(name, manager);
        }
        return manager;
    }

    private static final String getName(String packageName, String suffix, Locale locale) {
        return String.valueOf(packageName) + suffix + "_" + locale.toString() + ".properties";
    }

    private static final String getBundleName(String packageName, String suffix) {
        return String.valueOf(packageName) + suffix;
    }
}

