/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConfigurationError;
import org.infoglue.cms.util.StringManager;

public class SimpleStringManager
implements StringManager {
    private static final Logger logger = Logger.getLogger((String)SimpleStringManager.class.getName());
    private ResourceBundle bundle;

    SimpleStringManager(String bundleName, Locale locale) {
        if (locale == null || locale.getLanguage() == null || locale.getLanguage().equalsIgnoreCase("")) {
            logger.info((Object)("No locale sent in - must be a bug:" + locale));
            locale = Locale.ENGLISH;
        }
        try {
            logger.info((Object)("Created a SimpleStringManager for package bundleName" + bundleName + ":" + locale));
            this.bundle = ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException e) {
            throw new ConfigurationError("Unable to find resource bundle: " + e.getMessage(), e);
        }
        catch (NullPointerException e) {
            throw new Bug("Unable to create resource bundle.", e);
        }
    }

    public final String getString(String key) {
        try {
            return this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            logger.warn((Object)("Error trying to find a string for key " + key), (Throwable)e);
            throw new ConfigurationError("Key not found.", e);
        }
        catch (Throwable t) {
            logger.warn((Object)("Error trying to find a string for key " + key));
            throw new Bug("Unable to fetch the value for the specified key.", t);
        }
    }

    public final String getString(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    public final String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public final String getString(String key, Object arg1, Object arg2) {
        return this.getString(key, new Object[]{arg1, arg2});
    }

    public final String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getString(key, new Object[]{arg1, arg2, arg3});
    }

    boolean containsKey(String key) {
        try {
            this.bundle.getString(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }
}

