/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.util.CmsPropertyHandler;

public class SetCharacterEncodingFilter
implements Filter {
    public static final Logger logger = Logger.getLogger((String)SetCharacterEncodingFilter.class.getName());
    protected String encoding = null;
    protected FilterConfig filterConfig = null;
    protected boolean ignore = true;

    public void destroy() {
        this.encoding = null;
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String referer = ((HttpServletRequest)request).getHeader("referer");
        if (referer != null && referer.length() > 0 && referer.indexOf("ViewPage!renderDecoratedPage.action") > -1) {
            try {
                int startIndex = referer.indexOf("&languageId=");
                if (startIndex > -1) {
                    int endIndex = referer.indexOf("&", startIndex + 12);
                    String languageId = referer.substring(startIndex + 12);
                    if (endIndex != -1) {
                        languageId = referer.substring(startIndex + 12, endIndex);
                    }
                    LanguageVO languageVO = LanguageController.getController().getLanguageVOWithId(new Integer(languageId));
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("encoding decorated:" + languageVO.getCharset()));
                    }
                    request.setCharacterEncoding(languageVO.getCharset());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.ignore || request.getCharacterEncoding() == null) {
            String encoding = this.selectEncoding(request);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("encoding normal:" + encoding));
            }
            if (encoding != null) {
                request.setCharacterEncoding(encoding);
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String value;
        this.filterConfig = filterConfig;
        this.encoding = filterConfig.getInitParameter("encoding");
        if (this.encoding == null || this.encoding.equals("") || this.encoding.indexOf("@") > -1) {
            System.out.println("Encoding in web.xml was not set:" + this.encoding);
            this.encoding = this.encoding.indexOf("@deliverInputCharacterEncoding@") > -1 ? "ISO-8859-1" : "UTF-8";
            System.out.println("Defaulting to standard.");
        }
        this.ignore = (value = filterConfig.getInitParameter("ignore")) == null ? true : (value.equalsIgnoreCase("true") ? true : value.equalsIgnoreCase("yes"));
    }

    protected String selectEncoding(ServletRequest request) {
        String inputCharacterEncoding = CmsPropertyHandler.getInputCharacterEncoding(this.encoding);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("inputCharacterEncoding:" + inputCharacterEncoding));
        }
        if (inputCharacterEncoding != null && !inputCharacterEncoding.equals("") && !inputCharacterEncoding.equalsIgnoreCase("@inputCharacterEncoding@")) {
            return inputCharacterEncoding;
        }
        return this.encoding;
    }
}

