/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.infoglue.cms.exception.ConfigurationError;
import org.infoglue.cms.util.RegexpHelper;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;

public class ResourceHelper {
    private static final int CHAR_BUFFER_SIZE = 4096;
    private static final StringManager sm = StringManagerFactory.getSystemStringManager("org.infoglue.cms.util");
    private static final Logger logger = Logger.getLogger((String)RegexpHelper.class.getName());

    private ResourceHelper() {
    }

    public static synchronized Properties loadProperties(String name) {
        logger.debug((Object)sm.getString("resource.loadProperties.info", name));
        try {
            Properties properties = new Properties();
            properties.load(ResourceHelper.getResourceAsStream(name, ResourceHelper.class));
            return properties;
        }
        catch (Exception e) {
            throw new ConfigurationError(sm.getString("resource.loadProperties.error", name), e);
        }
    }

    public static synchronized String readResource(String name) {
        logger.debug((Object)sm.getString("resource.readResource.info", name));
        try {
            StringBuffer sb = new StringBuffer();
            InputStreamReader reader = new InputStreamReader(ResourceHelper.getResourceAsStream(name, ResourceHelper.class));
            char[] buf = new char[4096];
            int count = 0;
            while ((count = ((Reader)reader).read(buf, 0, 4096)) > 0) {
                sb.append(buf, 0, count);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new ConfigurationError(sm.getString("resource.readResource.error", name), e);
        }
    }

    public static InputStream getResourceAsStream(String resourceName, Class callingClass) {
        URL url = null;
        url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ResourceHelper.class.getClassLoader().getResource(resourceName);
        }
        if (url == null) {
            url = callingClass.getClassLoader().getResource(resourceName);
        }
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

