/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.NotificationListener;
import org.infoglue.cms.util.NotificationMessage;

public class RemoteCacheUpdater
implements NotificationListener {
    private static final Logger logger = Logger.getLogger((String)RemoteCacheUpdater.class.getName());
    private static List waitingSystemNotificationMessages = new ArrayList();

    public void setContextParameters(Map map) {
    }

    public static List getSystemNotificationMessages() {
        return waitingSystemNotificationMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSystemNotificationMessages() {
        List list = waitingSystemNotificationMessages;
        synchronized (list) {
            waitingSystemNotificationMessages.clear();
        }
    }

    public void notify(NotificationMessage notificationMessage) {
        try {
            logger.info((Object)"Update Remote caches....");
            this.updateRemoteCaches(notificationMessage);
            logger.info((Object)"Done updating remote caches....");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateRemoteCaches(NotificationMessage notificationMessage) throws Exception {
        throw new Exception("Wrong - this message handler should not be called...");
    }

    public void updateRemoteCaches(Hashtable internalMessage, Hashtable publicMessage) throws Exception {
        List internalUrls = CmsPropertyHandler.getInternalDeliveryUrls();
        if (internalMessage != null) {
            for (String deliverUrl : internalUrls) {
                String address = String.valueOf(deliverUrl) + "/" + CmsPropertyHandler.getCacheUpdateAction();
                logger.info((Object)("Updating cache at " + address));
                if (address.indexOf("@") > -1) {
                    logger.error((Object)("Skipping updating cache at " + address + ". You probably have not defined the correct addresses in application settings."));
                    continue;
                }
                try {
                    String response = this.postToUrl(address, internalMessage);
                }
                catch (Exception e) {
                    logger.error((Object)("Error updating cache at " + address + ":" + e.getMessage()), (Throwable)e);
                }
            }
        }
        List publicUrls = CmsPropertyHandler.getPublicDeliveryUrls();
        if (publicMessage != null) {
            for (String deliverUrl : publicUrls) {
                String address = String.valueOf(deliverUrl) + "/" + CmsPropertyHandler.getCacheUpdateAction();
                logger.info((Object)("Updating cache at " + address));
                if (address.indexOf("@") > -1) {
                    logger.error((Object)("Skipping updating cache at " + address + ". You probably have not defined the correct live addresses in application settings."));
                    continue;
                }
                try {
                    String response = this.postToUrl(address, publicMessage);
                }
                catch (Exception e) {
                    logger.error((Object)("Error updating cache at " + address + ":" + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private Hashtable notificationMessageToHashtable(NotificationMessage notificationMessage) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        logger.info((Object)("Serializing:" + notificationMessage));
        hash.put("className", notificationMessage.getClassName());
        hash.put("objectId", notificationMessage.getObjectId());
        hash.put("objectName", notificationMessage.getObjectName());
        hash.put("typeId", "" + notificationMessage.getType());
        return hash;
    }

    private String postToUrl(String urlAddress, Hashtable inHash) throws Exception {
        String line;
        URL url = new URL(urlAddress);
        URLConnection urlConn = url.openConnection();
        urlConn.setConnectTimeout(10000);
        urlConn.setReadTimeout(10000);
        urlConn.setAllowUserInteraction(false);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        PrintWriter printout = new PrintWriter(urlConn.getOutputStream(), true);
        String argString = "";
        if (inHash != null) {
            argString = this.toEncodedString(inHash);
        }
        printout.print(argString);
        printout.flush();
        printout.close();
        InputStream inStream = null;
        inStream = urlConn.getInputStream();
        InputStreamReader inStreamReader = new InputStreamReader(inStream);
        BufferedReader buffer = new BufferedReader(inStreamReader);
        StringBuffer strbuf = new StringBuffer();
        while ((line = buffer.readLine()) != null) {
            strbuf.append(line);
        }
        String readData = strbuf.toString();
        buffer.close();
        return readData;
    }

    private String toEncodedString(Hashtable inHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8"));
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    public String decodeHTTPEncodedString(String encoded) {
        StringBuffer decoded = new StringBuffer(encoded.length());
        int i = 0;
        int j = 0;
        while (i < encoded.length()) {
            char tecken = encoded.charAt(i);
            ++i;
            if (tecken == '+') {
                tecken = ' ';
            } else if (tecken == '%') {
                tecken = (char)Integer.parseInt(encoded.substring(i, i + 2), 16);
                i += 2;
            }
            decoded.append(tecken);
            ++j;
        }
        return new String(decoded);
    }

    public Hashtable httpEncodedStringToHashtable(String encodedstrang) {
        Hashtable<String, String> anropin = new Hashtable<String, String>();
        StringTokenizer andsplitter = new StringTokenizer(encodedstrang, "&");
        while (andsplitter.hasMoreTokens()) {
            String namevaluepair = andsplitter.nextToken();
            StringTokenizer equalsplitter = new StringTokenizer(namevaluepair, "=");
            if (equalsplitter.countTokens() != 2) continue;
            String name = equalsplitter.nextToken();
            String value = equalsplitter.nextToken();
            anropin.put(this.decodeHTTPEncodedString(name), this.decodeHTTPEncodedString(value));
        }
        return anropin;
    }
}

