/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import org.apache.log4j.Logger;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;

public class RegexpHelper {
    private static final StringManager sm = StringManagerFactory.getSystemStringManager("org.infoglue.cms.util");
    private static final Logger logger = Logger.getLogger((String)RegexpHelper.class.getName());
    private static final Perl5Util regexpDelegate = new Perl5Util();

    private RegexpHelper() {
    }

    public static synchronized boolean match(String pattern, String string) {
        logger.debug((Object)sm.getString("regexp.match.info", pattern, string));
        try {
            boolean result = regexpDelegate.match("/" + pattern + "/", string);
            return result;
        }
        catch (MalformedPerl5PatternException e) {
            throw new Bug(sm.getString("regexp.match.pattern_error", pattern), e);
        }
        catch (NullPointerException e) {
            throw new Bug(sm.getString("regexp.match.illegal_parameters_error", pattern, string), e);
        }
    }
}

