/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

public class NotificationMessage {
    public static final int TRANS_CREATE = 0;
    public static final int TRANS_UPDATE = 1;
    public static final int TRANS_DELETE = 2;
    public static final int PUBLISHING = 10;
    public static final int DENIED_PUBLISHING = 20;
    public static final int UNPUBLISHING = 30;
    public static final int SYSTEM = 100;
    public static final int AUTHENTICATION_SUCCESS = 200;
    public static final int AUTHENTICATION_FAILED = 201;
    public static final int AUTHORIZATION_FAILED = 202;
    public static final String TRANS_CREATE_TEXT = "create";
    public static final String TRANS_UPDATE_TEXT = "update";
    public static final String TRANS_DELETE_TEXT = "delete";
    public static final String PUBLISHING_TEXT = "publishing";
    public static final String DENIED_PUBLISHING_TEXT = "publishing denied";
    public static final String UNPUBLISHING_TEXT = "unpublishing";
    public static final String SYSTEM_TEXT = "general configuration change";
    public static final String AUTHENTICATION_SUCCESS_TEXT = "authentication success";
    public static final String AUTHENTICATION_FAILED_TEXT = "authentication failed";
    public static final String AUTHORIZATION_FAILED_TEXT = "authorization failed";
    private String name;
    private String systemUserName;
    private int type;
    private String className;
    private Object objectId;
    private String objectName;

    public NotificationMessage(String name, String className, String systemUserName, int type, Object objectId, String objectName) {
        this.name = name;
        this.className = className;
        this.systemUserName = systemUserName;
        this.type = type;
        this.objectId = objectId;
        this.objectName = objectName;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSystemUserName() {
        return this.systemUserName;
    }

    public int getType() {
        return this.type;
    }

    public Object getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public static String getTransactionTypeName(Integer transactionType) {
        switch (transactionType) {
            case 0: {
                return TRANS_CREATE_TEXT;
            }
            case 2: {
                return TRANS_DELETE_TEXT;
            }
            case 1: {
                return TRANS_UPDATE_TEXT;
            }
            case 10: {
                return PUBLISHING_TEXT;
            }
            case 20: {
                return DENIED_PUBLISHING_TEXT;
            }
            case 200: {
                return AUTHENTICATION_SUCCESS_TEXT;
            }
            case 201: {
                return AUTHORIZATION_FAILED_TEXT;
            }
            case 202: {
                return AUTHORIZATION_FAILED_TEXT;
            }
        }
        return "unknown - map " + transactionType + " to correct text";
    }
}

