/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.infoglue.cms.applications.common.VisualFormatter;
import org.infoglue.cms.util.CmsPropertyHandler;
import webwork.multipart.MultiPartRequestWrapper;

public class FileUploadHelper {
    private static final Logger logger = Logger.getLogger((String)FileUploadHelper.class.getName());

    public static File getUploadedFile(MultiPartRequestWrapper mpr) {
        File renamedFile = null;
        try {
            if (mpr != null) {
                Enumeration names = mpr.getFileNames();
                while (names.hasMoreElements()) {
                    String name = (String)names.nextElement();
                    File file = mpr.getFile(name);
                    logger.info((Object)("file:" + file.getPath() + ":" + file.exists()));
                    if (file == null) continue;
                    String fileSystemName = mpr.getFilesystemName(name);
                    String fileName = "Import_" + System.currentTimeMillis() + fileSystemName;
                    fileName = new VisualFormatter().replaceNonAscii(fileName, '_');
                    String filePath = CmsPropertyHandler.getDigitalAssetPath();
                    fileSystemName = String.valueOf(filePath) + File.separator + fileName;
                    renamedFile = new File(fileSystemName);
                    boolean isRenamed = file.renameTo(renamedFile);
                    logger.info((Object)("renamed file:" + renamedFile.getPath() + ":" + renamedFile.exists() + ":" + isRenamed));
                }
            } else {
                logger.error((Object)"File upload failed for some reason.");
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when we get and rename an uploaded file:" + e.getMessage()), (Throwable)e);
        }
        return renamedFile;
    }

    public static void listMultiPartFiles(HttpServletRequest req) {
        try {
            File tempDir = new File("c:/temp/uploads");
            logger.info((Object)("tempDir:" + tempDir.exists()));
            DiskFileItemFactory factory = new DiskFileItemFactory(1000, tempDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                List fileItems = upload.parseRequest(req);
                logger.info((Object)"******************************");
                logger.info((Object)("fileItems:" + fileItems.size()));
                logger.info((Object)"******************************");
                req.setAttribute("Test", (Object)"Mattias Testar");
                for (Object o : fileItems) {
                    DiskFileItem dfi = (DiskFileItem)o;
                    logger.info((Object)("dfi:" + dfi.getFieldName()));
                    logger.info((Object)("dfi:" + dfi));
                    if (dfi.isFormField()) continue;
                    String fieldName = dfi.getFieldName();
                    String fileName = dfi.getName();
                    String contentType = dfi.getContentType();
                    boolean isInMemory = dfi.isInMemory();
                    long sizeInBytes = dfi.getSize();
                    logger.info((Object)("fieldName:" + fieldName));
                    logger.info((Object)("fileName:" + fileName));
                    logger.info((Object)("contentType:" + contentType));
                    logger.info((Object)("isInMemory:" + isInMemory));
                    logger.info((Object)("sizeInBytes:" + sizeInBytes));
                    File uploadedFile = new File("c:/temp/uploads/" + fileName);
                    dfi.write(uploadedFile);
                    req.setAttribute(dfi.getFieldName(), (Object)uploadedFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

