/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.applications.databeans.ConvertedDocumentBean;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class DocumentConverterHelper {
    private static final Logger logger = Logger.getLogger((String)DocumentConverterHelper.class.getName());

    public ConvertedDocumentBean convert(File aDocFile, String aTitle, String aMenuTextLength, List aCssList, String rewrite) {
        ConvertedDocumentBean convertedDocument = new ConvertedDocumentBean();
        int menuMaxLength = 20;
        logger.info((Object)"START");
        try {
            if (aTitle == null || aTitle.trim().equals("")) {
                aTitle = "Inneh\u00e5llsf\u00f6rteckning";
            }
            if (aMenuTextLength == null || aMenuTextLength.trim().equals("")) {
                aMenuTextLength = "20";
            }
            try {
                menuMaxLength = new Integer(aMenuTextLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            SocketOpenOfficeConnection connection = new SocketOpenOfficeConnection(8100);
            String fileName = aDocFile.getName().substring(0, aDocFile.getName().indexOf("."));
            int idIndex = fileName.indexOf("_");
            String digitalAssetPath = CmsPropertyHandler.getDigitalAssetPath();
            String folderName = "";
            if (idIndex > -1) {
                String fileIdString = fileName.substring(0, idIndex);
                int fileId = Integer.parseInt(fileIdString);
                folderName = "" + fileId / 1000;
                digitalAssetPath = String.valueOf(digitalAssetPath) + File.separator + folderName;
            }
            digitalAssetPath = String.valueOf(digitalAssetPath) + File.separator + fileName;
            logger.info((Object)("Directory to write files to: " + digitalAssetPath));
            String newFilePath = String.valueOf(digitalAssetPath) + File.separator + fileName;
            File pdfFile = new File(String.valueOf(newFilePath) + ".pdf");
            File odtFile = new File(String.valueOf(newFilePath) + ".odt");
            File htmlFile = new File(String.valueOf(newFilePath) + ".html");
            File contentXmlFile = new File(String.valueOf(digitalAssetPath) + File.separator + "content.xml");
            File documentDir = new File(digitalAssetPath);
            if (!documentDir.exists() || rewrite.equals("true")) {
                logger.info((Object)("The directory " + digitalAssetPath + " does not exist. Creating it."));
                documentDir.mkdir();
                logger.info((Object)("The directory " + digitalAssetPath + " was successfully created."));
                logger.info((Object)"Connecting to server...");
                connection.connect();
                logger.info((Object)"Connection ok");
                logger.info((Object)"Conversion START");
                DocumentConverterHelper.convertDocument(aDocFile, htmlFile, (OpenOfficeConnection)connection);
                DocumentConverterHelper.convertDocument(aDocFile, odtFile, (OpenOfficeConnection)connection);
                DocumentConverterHelper.convertDocument(aDocFile, pdfFile, (OpenOfficeConnection)connection);
                connection.disconnect();
                logger.info((Object)"Conversion END");
                logger.info((Object)"Extracting content.xml...");
                logger.info((Object)("odtFile: " + odtFile.getPath()));
                logger.info((Object)("target path: : " + digitalAssetPath));
                contentXmlFile = DocumentConverterHelper.extractContentXml(odtFile, digitalAssetPath);
                logger.info((Object)"Done extracting content.xml");
                logger.info((Object)"Updating handbook with extra info");
                DocumentConverterHelper.adaptHandbook(htmlFile, aCssList);
                logger.info((Object)"Done updating handbook with extra info");
            }
            logger.info((Object)"Extracting URL:s to resources.");
            String digitalAssetUrl = CmsPropertyHandler.getDigitalAssetBaseUrl();
            if (!folderName.equals("")) {
                digitalAssetUrl = String.valueOf(digitalAssetUrl) + "/" + folderName;
            }
            String htmlFileUrl = String.valueOf(digitalAssetUrl) + "/" + fileName + "/" + htmlFile.getName();
            String pdfFileUrl = String.valueOf(digitalAssetUrl) + "/" + fileName + "/" + pdfFile.getName();
            String odtFileUrl = String.valueOf(digitalAssetUrl) + "/" + fileName + "/" + odtFile.getName();
            logger.info((Object)("htmlFileUrl: " + htmlFileUrl));
            logger.info((Object)("pdfFileUrl: " + pdfFileUrl));
            logger.info((Object)("odtFileUrl: " + odtFileUrl));
            logger.info((Object)"Generating TOC...");
            String tocString = DocumentConverterHelper.generateHtmlToc(contentXmlFile, htmlFileUrl, aTitle, menuMaxLength);
            logger.info((Object)"Done generating TOC");
            convertedDocument.setHtmlFileUrl(htmlFileUrl);
            convertedDocument.setPdfFileUrl(pdfFileUrl);
            convertedDocument.setOdtFileUrl(odtFileUrl);
            convertedDocument.setTocString(tocString);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred when converting document:" + e.getMessage()), (Throwable)e);
        }
        logger.info((Object)"END");
        return convertedDocument;
    }

    private static String generateHtmlToc(File aContentXmlFile, String aHtmlFileUrl, String aTitle, int aMenuMaxLength) throws Exception {
        logger.info((Object)("Start generating HTML TOC: xmlFile: " + aContentXmlFile.getPath() + ", htmlFileUrl: " + aHtmlFileUrl));
        Namespace officeNs = Namespace.getNamespace((String)"office", (String)"urn:oasis:names:tc:opendocument:xmlns:office:1.0");
        Namespace textNs = Namespace.getNamespace((String)"text", (String)"urn:oasis:names:tc:opendocument:xmlns:text:1.0");
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(aContentXmlFile);
        List tocElements = null;
        try {
            Element rootElement = doc.getRootElement();
            Element bodyElement = rootElement.getChild("body", officeNs);
            Element textElement = bodyElement.getChild("text", officeNs);
            Element tocElement = textElement.getChild("table-of-content", textNs);
            Element textIndexBodyElement = tocElement.getChild("index-body", textNs);
            tocElements = textIndexBodyElement.getChildren();
        }
        catch (Exception e) {
            throw new Exception("The document structure is incorrect. Please create a document containing a table of contents.");
        }
        if (tocElements != null) {
            logger.info((Object)"Found TOC elements, generating TOC.");
            StringBuffer htmlMenuSb = new StringBuffer();
            DocumentConverterHelper.generateHtml(tocElements.toArray(), htmlMenuSb, aHtmlFileUrl, aTitle, aMenuMaxLength);
            return htmlMenuSb.toString();
        }
        throw new Exception("The list of TOC elements was null.");
    }

    private static StringBuffer generateHtml(Object[] aTocElements, StringBuffer aReturnSb, String aHtmlFileUrl, String aTitle, int aMenuMaxLength) throws Exception {
        Element child = null;
        String elementText = "";
        String headingNumber = "";
        int startPosition = 0;
        String previousHeadingNumber = "";
        int level = 0;
        int previousLevel = 0;
        int numberOfEndUls = 0;
        StringTokenizer st = null;
        int linkCounter = 0;
        String croppedElementText = "";
        int cropCounter = 0;
        boolean willCrop = false;
        aReturnSb.append("<div id=\"submenu\">");
        aReturnSb.append("<div class=\"menuheader\">" + aTitle + "</div>");
        while (startPosition < aTocElements.length) {
            child = (Element)aTocElements[startPosition];
            elementText = child.getText();
            if (elementText != null && !elementText.equals("") && elementText.indexOf(" ") != -1) {
                headingNumber = elementText.substring(0, elementText.indexOf(" "));
                st = new StringTokenizer(headingNumber, ".");
                level = st.countTokens();
                if (level > previousLevel) {
                    aReturnSb.append("<ul>");
                } else if (level < previousLevel) {
                    numberOfEndUls = previousLevel - level;
                    int i = 0;
                    while (i < numberOfEndUls) {
                        aReturnSb.append("</ul>");
                        ++i;
                    }
                }
                cropCounter = elementText.length();
                char myChar = elementText.charAt(cropCounter - 1);
                while (cropCounter > 0 && Character.isDigit(myChar)) {
                    myChar = elementText.charAt(--cropCounter);
                    willCrop = true;
                }
                if (willCrop) {
                    ++cropCounter;
                }
                croppedElementText = (elementText = elementText.substring(0, cropCounter)).length() > aMenuMaxLength ? String.valueOf(elementText.substring(0, aMenuMaxLength)) + "..." : elementText;
                aReturnSb.append("<li><p><a target=\"handbookFrame\" href=\"" + aHtmlFileUrl + "#link" + linkCounter + "\" title=\"" + elementText + "\">" + croppedElementText + "</a></p></li>");
                previousHeadingNumber = headingNumber;
                previousLevel = level;
                ++linkCounter;
            }
            ++startPosition;
        }
        aReturnSb.append("</div>");
        return aReturnSb;
    }

    public static void adaptHandbook(File aHandbookHtmlFile, List aCssList) throws Exception {
        String originalHtmlContent = DocumentConverterHelper.readFileIntoString(aHandbookHtmlFile);
        String htmlContentWithoutToc = DocumentConverterHelper.removeTocFromHtml(originalHtmlContent);
        String htmlContentWithAnchors = DocumentConverterHelper.insertAnchors(htmlContentWithoutToc);
        String htmlWithProperCss = DocumentConverterHelper.fixCss(htmlContentWithAnchors, aCssList);
        DocumentConverterHelper.writeStringToFile(aHandbookHtmlFile, htmlWithProperCss);
    }

    private static String fixCss(String aHtmlContent, List aCssList) {
        StringBuffer sb = new StringBuffer();
        int cssStartIndex = aHtmlContent.indexOf("<STYLE TYPE=\"text/css\">");
        String start = aHtmlContent.substring(0, cssStartIndex);
        String temp = aHtmlContent.substring(cssStartIndex + 1);
        String end = temp.substring(temp.indexOf("</STYLE>") + 8);
        StringBuffer linkedCssString = new StringBuffer();
        Iterator it = aCssList.iterator();
        String cssString = "";
        while (it.hasNext()) {
            cssString = (String)it.next();
            cssString = "<link href=\"" + cssString + "\" rel=\"stylesheet\" type=\"text/css\" />" + '\n';
            linkedCssString.append(cssString);
        }
        sb.append(start);
        sb.append(linkedCssString.toString());
        sb.append(end);
        return sb.toString();
    }

    private static String removeTocFromHtml(String aHtmlContent) {
        logger.info((Object)"About to remove TOC from HTML");
        StringBuffer sb = new StringBuffer();
        int tocStartIndex = -1;
        tocStartIndex = aHtmlContent.indexOf("<DIV ID=\"Table of Contents1\" DIR=\"LTR\">");
        if (tocStartIndex == -1) {
            tocStartIndex = aHtmlContent.indexOf("<DIV ID=\"Inneh&aring;llsf&ouml;rteckning1\" DIR=\"LTR\">");
        }
        if (tocStartIndex > -1) {
            logger.info((Object)("The HTML string contains a TOC beginning at position " + tocStartIndex + ". Removing it."));
            String start = aHtmlContent.substring(0, tocStartIndex);
            String temp = aHtmlContent.substring(tocStartIndex + 1);
            String end = temp.substring(temp.indexOf("</DIV>") + 6);
            sb.append(start);
            sb.append(end);
            logger.info((Object)"The TOC was succesfully removed.");
        } else {
            logger.info((Object)"No TOC found in the HTML string.");
            sb.append(aHtmlContent);
        }
        return sb.toString();
    }

    private static String insertAnchors(String aOriginalHtmlContent) {
        StringBuffer modifiedHtmlContent = new StringBuffer();
        StringTokenizer st = new StringTokenizer(aOriginalHtmlContent, System.getProperty("line.separator"));
        String lineString = "";
        int linkCounter = 0;
        while (st.hasMoreTokens()) {
            lineString = st.nextToken();
            if (lineString.indexOf("<H1") > -1) {
                lineString = lineString.replaceAll("<H1", "<A NAME=\"link" + linkCounter + "\"></A><H1");
                ++linkCounter;
            } else if (lineString.indexOf("<H2") > -1) {
                lineString = lineString.replaceAll("<H2", "<A NAME=\"link" + linkCounter + "\"></A><H2");
                ++linkCounter;
            } else if (lineString.indexOf("<H3") > -1) {
                lineString = lineString.replaceAll("<H3", "<A NAME=\"link" + linkCounter + "\"></A><H3");
                ++linkCounter;
            } else if (lineString.indexOf("<H4") > -1) {
                lineString = lineString.replaceAll("<H4", "<A NAME=\"link" + linkCounter + "\"></A><H4");
                ++linkCounter;
            }
            modifiedHtmlContent.append(String.valueOf(lineString) + System.getProperty("line.separator"));
        }
        return modifiedHtmlContent.toString();
    }

    public static String readFileIntoString(File aFile) throws Exception {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(aFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
        return contents.toString();
    }

    public static void writeStringToFile(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + aFile);
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static void listChildren(Element aParentElement) {
        if (aParentElement == null) {
            logger.info((Object)"The supplied Element was null");
        } else {
            logger.info((Object)("Children to " + aParentElement.getNamespacePrefix() + ":" + aParentElement.getName() + ": "));
            logger.info((Object)"---------------------------------");
            List children = aParentElement.getChildren();
            for (Element child : children) {
                logger.info((Object)(String.valueOf(child.getNamespacePrefix()) + ":" + child.getName() + "=" + child.getText()));
            }
            logger.info((Object)"---------------------------------");
        }
    }

    public static void convertDocument(File aInputFile, File aOutputFile, OpenOfficeConnection aConnection) {
        String fileType = "";
        fileType = aOutputFile.getAbsolutePath().substring(aOutputFile.getAbsolutePath().lastIndexOf(".") + 1);
        logger.info((Object)("Converting document to " + fileType + "..."));
        OpenOfficeDocumentConverter converter = new OpenOfficeDocumentConverter(aConnection);
        logger.info((Object)("Converting from " + aInputFile.getPath() + " to " + aOutputFile.getPath()));
        converter.convert(aInputFile, aOutputFile);
        logger.info((Object)"Conversion complete");
    }

    public static File extractContentXml(File aOdtFile, String aTargetDirectory) throws ZipException, IOException {
        logger.info((Object)("Target directory for content.xml: " + aTargetDirectory));
        File contentXmlFile = null;
        ZipFile zipFile = new ZipFile(aOdtFile);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().equals("content.xml")) continue;
            logger.info((Object)"Found the content.xml file.");
            contentXmlFile = new File(String.valueOf(aTargetDirectory) + File.separator + entry.getName());
            logger.info((Object)("Copying entry " + entry.getName() + " from ODT file to " + contentXmlFile.getPath()));
            DocumentConverterHelper.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(contentXmlFile)));
            logger.info((Object)"Success!");
            break;
        }
        zipFile.close();
        logger.info((Object)"Content XML extraction successful.");
        return contentXmlFile;
    }

    public static final void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }
}

