/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.ConstraintException;

public class ConstraintExceptionBuffer {
    protected Set exceptions = new HashSet();

    public ConstraintExceptionBuffer() {
    }

    public ConstraintExceptionBuffer(ConstraintException exception) {
        this.add(exception);
    }

    public final boolean isEmpty() {
        return this.exceptions.isEmpty();
    }

    public final void add(ConstraintExceptionBuffer ceb) {
        if (ceb != null) {
            this.exceptions.addAll(ceb.exceptions);
        }
    }

    public final void add(ConstraintException exception) {
        if (exception != null) {
            String fieldName = exception.getFieldName();
            String errorCode = exception.getErrorCode();
            ConstraintException ce = new ConstraintException(fieldName, errorCode);
            this.exceptions.add(ce);
            this.add(exception.getChainedException());
        }
    }

    public void throwIfNotEmpty() throws AccessConstraintException, ConstraintException {
        if (!this.isEmpty()) {
            throw this.toConstraintException();
        }
    }

    public ConstraintException toConstraintException() {
        ConstraintException rootException = null;
        for (ConstraintException ce : this.exceptions) {
            ce.setChainedException(rootException);
            rootException = ce;
        }
        return rootException;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ConstraintExceptionBuffer>[{ ");
        Iterator iterator = this.exceptions.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next() + (iterator.hasNext() ? ", " : ""));
        }
        sb.append("}]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ConstraintExceptionBuffer)) {
            return false;
        }
        ConstraintExceptionBuffer ceb = (ConstraintExceptionBuffer)o;
        return this.exceptions.equals(ceb.exceptions);
    }

    public int hashCode() {
        return this.exceptions.hashCode();
    }
}

