/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.infoglue.cms.applications.databeans.SessionInfoBean;
import org.infoglue.cms.security.InfoGluePrincipal;

public class CmsSessionContextListener
implements HttpSessionListener {
    public static final Map sessions = Collections.synchronizedMap(new HashMap());
    private static int activeSessions = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionCreated(HttpSessionEvent se) {
        ++activeSessions;
        Map map = sessions;
        synchronized (map) {
            sessions.put(se.getSession().getId(), se.getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDestroyed(HttpSessionEvent se) {
        if (activeSessions > 0) {
            --activeSessions;
        }
        Map map = sessions;
        synchronized (map) {
            sessions.remove(se.getSession().getId());
        }
    }

    public static int getActiveSessions() {
        return activeSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getSessionInfoBeanList() {
        ArrayList<SessionInfoBean> stiList = new ArrayList<SessionInfoBean>();
        Map map = sessions;
        synchronized (map) {
            for (String s : sessions.keySet()) {
                HttpSession sess = (HttpSession)sessions.get(s);
                SessionInfoBean sib = new SessionInfoBean(sess.getId());
                InfoGluePrincipal principal = (InfoGluePrincipal)sess.getAttribute("org.infoglue.cms.security.user");
                if (principal == null) {
                    principal = (InfoGluePrincipal)sess.getAttribute("infogluePrincipal");
                }
                if (principal == null) continue;
                sib.setPrincipal(principal);
                sib.setLastAccessedDate(new Date(sess.getLastAccessedTime()));
                stiList.add(sib);
            }
        }
        return stiList;
    }
}

