/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ServerNodeController;
import org.infoglue.cms.entities.management.ServerNodeVO;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import org.infoglue.deliver.util.Timer;
import webwork.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsPropertyHandler {
    private static final Logger logger = Logger.getLogger((String)CmsPropertyHandler.class.getName());
    private static Properties cachedProperties = null;
    private static PropertySet propertySet = null;
    private static String serverNodeName = null;
    private static String globalSettingsServerNodeId = "-1";
    private static String localSettingsServerNodeId = null;
    private static String applicationName = null;
    private static String contextRootPath = null;
    private static String operatingMode = null;
    private static File propertyFile = null;
    private static Date startupTime = null;
    private static String servletContext = null;

    public static void setApplicationName(String theApplicationName) {
        applicationName = theApplicationName;
    }

    public static void setContextRootPath(String contextRootPath) {
        CmsPropertyHandler.contextRootPath = contextRootPath;
    }

    public static String getServletContext() {
        return servletContext;
    }

    public static void setServletContext(String servletContext) {
        CmsPropertyHandler.servletContext = servletContext;
    }

    public static void setOperatingMode(String operatingMode) {
        CmsPropertyHandler.operatingMode = operatingMode;
    }

    public static String getApplicationName() {
        return applicationName;
    }

    public static void setStartupTime(Date startupTime) {
        CmsPropertyHandler.startupTime = startupTime;
    }

    public static Date getStartupTime() {
        return startupTime;
    }

    public static void setPropertyFile(File aPropertyFile) {
        propertyFile = aPropertyFile;
    }

    private static void initializeProperties() {
        try {
            Timer timer = new Timer();
            timer.setActive(false);
            System.out.println("Initializing properties from file.....");
            cachedProperties = new Properties();
            if (propertyFile != null) {
                cachedProperties.load(new FileInputStream(propertyFile));
            } else {
                cachedProperties.load(CmsPropertyHandler.class.getResourceAsStream("/" + applicationName + ".properties"));
            }
            Enumeration<Object> enumeration = cachedProperties.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                if (key.indexOf("webwork.") <= 0) continue;
                Configuration.set((String)key, (Object)cachedProperties.getProperty(key));
            }
            timer.printElapsedTime("Initializing properties from file took");
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("globalKey", "infoglue");
            try {
                propertySet = PropertySetManager.getInstance((String)"jdbc", args);
                logger.info((Object)("propertySet: " + propertySet));
            }
            catch (Exception e) {
                propertySet = null;
                logger.error((Object)("Could not get property set: " + e.getMessage()), (Throwable)e);
            }
            timer.printElapsedTime("Initializing properties from jdbc");
            serverNodeName = cachedProperties.getProperty("serverNodeName");
            if (serverNodeName == null || serverNodeName.length() == 0) {
                try {
                    InetAddress localhost = InetAddress.getLocalHost();
                    serverNodeName = localhost.getHostName();
                }
                catch (Exception e) {
                    System.out.println("Error initializing serverNodeName:" + e.getMessage());
                }
            }
            System.out.println("serverNodeName:" + serverNodeName);
            CmsPropertyHandler.initializeLocalServerNodeId();
            timer.printElapsedTime("Initializing properties from local server jdbc");
        }
        catch (Exception e) {
            cachedProperties = null;
            logger.error((Object)("Error loading properties from file /" + applicationName + ".properties" + ". Reason:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static String getServerName() {
        String serverName = "Unknown";
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            serverName = localhost.getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    public static void initializeLocalServerNodeId() {
        try {
            List serverNodeVOList = ServerNodeController.getController().getServerNodeVOList();
            for (ServerNodeVO serverNodeVO : serverNodeVOList) {
                if (!serverNodeVO.getName().equalsIgnoreCase(serverNodeName)) continue;
                localSettingsServerNodeId = serverNodeVO.getId().toString();
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("An error occurred trying to get localSettingsServerNodeId: " + e.getMessage()), (Throwable)e);
        }
        System.out.println("localSettingsServerNodeId:" + localSettingsServerNodeId);
    }

    public static Properties getProperties() {
        if (cachedProperties == null) {
            CmsPropertyHandler.initializeProperties();
        }
        return cachedProperties;
    }

    public static String getProperty(String key) {
        String value;
        if (cachedProperties == null) {
            CmsPropertyHandler.initializeProperties();
        }
        if ((value = cachedProperties.getProperty(key)) != null) {
            value = value.trim();
        }
        return value;
    }

    public static void setProperty(String key, String value) {
        if (cachedProperties == null) {
            CmsPropertyHandler.initializeProperties();
        }
        cachedProperties.setProperty(key, value);
        CacheController.clearServerNodeProperty(false);
    }

    public static String getServerNodeProperty(String key, boolean inherit) {
        return CmsPropertyHandler.getServerNodeProperty(null, key, inherit, null);
    }

    public static String getServerNodeProperty(String key, boolean inherit, String defaultValue) {
        return CmsPropertyHandler.getServerNodeProperty(null, key, inherit, defaultValue);
    }

    public static String getServerNodeProperty(String prefix, String key, boolean inherit, String defaultValue) {
        String value = null;
        Object valueObject = null;
        StringBuffer sb = new StringBuffer();
        sb.append(prefix).append("_").append(key).append("_").append(inherit);
        String cacheKey = sb.toString();
        String cacheName = "serverNodePropertiesCache";
        if (logger.isInfoEnabled()) {
            logger.info((Object)("cacheKey:" + cacheKey));
        }
        if ((valueObject = CacheController.getCachedObject(cacheName, cacheKey)) != null) {
            if (valueObject instanceof NullObject) {
                return null;
            }
            return ((String)valueObject).trim();
        }
        Timer timer = new Timer();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting jdbc-property:" + cacheKey));
        }
        if (propertySet != null) {
            if (localSettingsServerNodeId != null) {
                if (prefix != null) {
                    value = propertySet.getString("serverNode_" + localSettingsServerNodeId + "_" + prefix + "_" + key);
                    if ((value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) && ((value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + prefix + "_" + key)) == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit)) {
                        value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + key);
                    }
                } else {
                    value = propertySet.getString("serverNode_" + localSettingsServerNodeId + "_" + key);
                    if (value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) {
                        value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + key);
                    }
                }
            } else if (prefix != null) {
                value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + prefix + "_" + key);
                if (value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) {
                    value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + key);
                }
            } else {
                value = propertySet.getString("serverNode_" + globalSettingsServerNodeId + "_" + key);
            }
        }
        if (value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) {
            value = CmsPropertyHandler.getProperty(key);
        }
        if ((value == null || value.indexOf(key) > -1) && defaultValue != null) {
            value = defaultValue;
        }
        if (value != null) {
            value = value.trim();
        }
        if (value != null) {
            CacheController.cacheObject(cacheName, cacheKey, value);
        } else {
            CacheController.cacheObject(cacheName, cacheKey, new NullObject());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting property " + cacheKey + " took:" + timer.getElapsedTime()));
        }
        return value;
    }

    public static String getServerNodeDataProperty(String prefix, String key, boolean inherit, String defaultValue) {
        return CmsPropertyHandler.getServerNodeDataProperty(prefix, key, inherit, defaultValue, false);
    }

    public static String getServerNodeDataProperty(String prefix, String key, boolean inherit, String defaultValue, boolean skipCache) {
        String value = null;
        String cacheKey = prefix + "_" + key + "_" + inherit;
        String cacheName = "serverNodePropertiesCache";
        if (logger.isInfoEnabled()) {
            logger.info((Object)("cacheKey:" + cacheKey));
        }
        if (!skipCache && (value = (String)CacheController.getCachedObject(cacheName, cacheKey)) != null) {
            return value;
        }
        Timer timer = new Timer();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting jdbc-property:" + cacheKey));
        }
        if (localSettingsServerNodeId != null) {
            if (prefix != null) {
                value = CmsPropertyHandler.getDataPropertyValue("serverNode_" + localSettingsServerNodeId + "_" + prefix + "_" + key);
                if ((value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) && ((value = CmsPropertyHandler.getDataPropertyValue("serverNode_" + globalSettingsServerNodeId + "_" + prefix + "_" + key)) == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit)) {
                    value = CmsPropertyHandler.getDataPropertyValue("serverNode_" + globalSettingsServerNodeId + "_" + key);
                }
            } else {
                value = CmsPropertyHandler.getDataPropertyValue("serverNode_" + localSettingsServerNodeId + "_" + key);
                if (value == null || value.equals("") || value.equalsIgnoreCase("inherit") && inherit) {
                    value = CmsPropertyHandler.getDataPropertyValue("serverNode_" + globalSettingsServerNodeId + "_" + key);
                }
            }
        } else {
            value = prefix != null ? CmsPropertyHandler.getDataPropertyValue("serverNode_" + globalSettingsServerNodeId + "_" + prefix + "_" + key) : CmsPropertyHandler.getDataPropertyValue("serverNode_" + globalSettingsServerNodeId + "_" + key);
        }
        if (value == null && defaultValue != null) {
            value = defaultValue;
        }
        if (!skipCache) {
            CacheController.cacheObject(cacheName, cacheKey, value);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Getting property " + cacheKey + " took:" + timer.getElapsedTime()));
        }
        return value;
    }

    public static String getDataPropertyValue(String fullKey) {
        String result = null;
        try {
            byte[] valueBytes = propertySet.getData(fullKey);
            result = valueBytes != null ? new String(valueBytes, "utf-8") : "";
        }
        catch (Exception e) {
            logger.error((Object)("Error getting DataPropertyValue for " + fullKey + ":" + e.getMessage()), (Throwable)e);
        }
        return result;
    }

    public static String getContextRootPath() {
        return contextRootPath;
    }

    public static String getOperatingMode() {
        if (operatingMode == null) {
            return CmsPropertyHandler.getProperty("operatingMode");
        }
        return operatingMode;
    }

    public static String getInputCharacterEncoding(String defaultEncoding) {
        String applicationName = CmsPropertyHandler.getApplicationName();
        String newInputCharacterEncoding = CmsPropertyHandler.getServerNodeProperty("inputCharacterEncoding", true, defaultEncoding);
        if (!applicationName.equalsIgnoreCase("cms")) {
            newInputCharacterEncoding = CmsPropertyHandler.getServerNodeProperty("deliver", "inputCharacterEncoding", true, defaultEncoding);
        }
        return newInputCharacterEncoding;
    }

    public static String getUp2dateUrl() {
        return CmsPropertyHandler.getProperty("up2dateUrl");
    }

    public static String getURLComposerClass() {
        return CmsPropertyHandler.getProperty("URLComposerClass");
    }

    public static String getMaxClients() {
        return CmsPropertyHandler.getProperty("maxClients");
    }

    public static String getAdministratorUserName() {
        return CmsPropertyHandler.getProperty("administratorUserName");
    }

    public static boolean getMatchesAdministratorPassword(String password) {
        try {
            String administratorPassword;
            if (CmsPropertyHandler.getUsePasswordEncryption()) {
                String encryptedPass;
                byte[] encryptedPassRaw = DigestUtils.sha((String)password);
                password = encryptedPass = new String(new Base64().encode(encryptedPassRaw), "ASCII");
            }
            if ((administratorPassword = CmsPropertyHandler.getProperty("administratorPassword")) != null) {
                return administratorPassword.equals(password);
            }
            return false;
        }
        catch (Exception e) {
            logger.error((Object)("There was an error when we encrypted the password:" + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean getUsePasswordEncryption() {
        boolean usePasswordEncryption = false;
        try {
            usePasswordEncryption = Boolean.parseBoolean(CmsPropertyHandler.getServerNodeProperty("usePasswordEncryption", true, "false"));
        }
        catch (Exception e) {
            logger.warn((Object)("Error parsing usePasswordEncryption:" + e.getMessage()));
        }
        return usePasswordEncryption;
    }

    public static String getAdministratorEmail() {
        return CmsPropertyHandler.getProperty("administratorEmail");
    }

    public static String getDbRelease() {
        return CmsPropertyHandler.getProperty("dbRelease");
    }

    public static String getDbUser() {
        return CmsPropertyHandler.getProperty("dbUser");
    }

    public static String getDbPassword() {
        return CmsPropertyHandler.getProperty("dbPassword");
    }

    public static String getMasterServer() {
        return CmsPropertyHandler.getProperty("masterServer");
    }

    public static String getSlaveServer() {
        return CmsPropertyHandler.getProperty("slaveServer");
    }

    public static String getBuildName() {
        return CmsPropertyHandler.getProperty("buildName");
    }

    public static String getAdminToolsPath() {
        return CmsPropertyHandler.getProperty("adminToolsPath");
    }

    public static String getDbScriptPath() {
        return CmsPropertyHandler.getProperty("dbScriptPath");
    }

    public static String getDigitalAssetUploadPath() {
        return CmsPropertyHandler.getServerNodeProperty("digitalAssetUploadPath", true, contextRootPath + "uploads");
    }

    public static String getDisableAssetDeletionInWorkThread() {
        return CmsPropertyHandler.getServerNodeProperty("disableAssetDeletionInWorkThread", true, "false");
    }

    public static String getDisableAssetDeletionInLiveThread() {
        return CmsPropertyHandler.getServerNodeProperty("getDisableAssetDeletionInLiveThread", true, "false");
    }

    public static String getExtranetCookieTimeout() {
        return CmsPropertyHandler.getServerNodeProperty("extranetCookieTimeout", true, "1800");
    }

    public static String getWebServicesBaseUrl() {
        return CmsPropertyHandler.getServerNodeProperty("webServicesBaseUrl", true);
    }

    public static String getLivePublicationThreadClass() {
        return CmsPropertyHandler.getServerNodeProperty("livePublicationThreadClass", true, "org.infoglue.deliver.util.PublicationThread");
    }

    public static String getPublicationThreadDelay() {
        return CmsPropertyHandler.getServerNodeProperty("publicationThreadDelay", true, "5000");
    }

    public static String getPathsToRecacheOnPublishing() {
        return CmsPropertyHandler.getServerNodeProperty("pathsToRecacheOnPublishing", true);
    }

    public static String getDisableTemplateDebug() {
        return CmsPropertyHandler.getServerNodeProperty("disableTemplateDebug", true, "false");
    }

    public static String getTree() {
        return CmsPropertyHandler.getServerNodeProperty("tree", true, "html");
    }

    public static String getTreeMode() {
        return CmsPropertyHandler.getServerNodeProperty("treemode", true, "dynamic");
    }

    public static String getDisableCustomIcons() {
        return CmsPropertyHandler.getServerNodeProperty("disableCustomIcons", true, "true");
    }

    public static String getWorkingStyleInformation() {
        return CmsPropertyHandler.getServerNodeProperty("workingStyleInformation", true, "color: #007900");
    }

    public static String getFinalStyleInformation() {
        return CmsPropertyHandler.getServerNodeProperty("finalStyleInformation", true, "color: #baaf00");
    }

    public static String getPublishStyleInformation() {
        return CmsPropertyHandler.getServerNodeProperty("publishStyleInformation", true, "color: #ba0000");
    }

    public static String getPublishedStyleInformation() {
        return CmsPropertyHandler.getServerNodeProperty("publishedStyleInformation", true, "");
    }

    public static String getPreviewDeliveryUrl() {
        return CmsPropertyHandler.getServerNodeProperty("previewDeliveryUrl", true);
    }

    public static String getStagingDeliveryUrl() {
        return CmsPropertyHandler.getServerNodeProperty("stagingDeliveryUrl", true);
    }

    public static String getEditionPageSize() {
        return CmsPropertyHandler.getServerNodeProperty("edition.pageSize", true, "10");
    }

    public static String getContentTreeSort() {
        return CmsPropertyHandler.getServerNodeProperty("content.tree.sort", true, "name");
    }

    public static String getStructureTreeSort() {
        return CmsPropertyHandler.getServerNodeProperty("structure.tree.sort", true, "name");
    }

    public static String getStructureTreeIsHiddenProperty() {
        return CmsPropertyHandler.getServerNodeProperty("structure.tree.isHidden", true);
    }

    public static String getUseAccessRightsOnContentTree() {
        return CmsPropertyHandler.getServerNodeProperty("content.tree.hideForbidden", true, "false");
    }

    public static String getUseAccessRightsOnStructureTree() {
        return CmsPropertyHandler.getServerNodeProperty("structure.tree.hideForbidden", true, "false");
    }

    public static String getEnforceRigidContentAccess() {
        return CmsPropertyHandler.getServerNodeProperty("enforceRigidContentAccess", true, "false");
    }

    public static String getDisableEmptyUrls() {
        return CmsPropertyHandler.getServerNodeProperty("disableEmptyUrls", true, "yes");
    }

    public static String getCacheUpdateAction() {
        return CmsPropertyHandler.getServerNodeProperty("cacheUpdateAction", true, "UpdateCache.action");
    }

    public static String getLogPath() {
        return CmsPropertyHandler.getServerNodeProperty("logPath", true, contextRootPath + "logs" + File.separator + applicationName + ".log");
    }

    public static String getLogTransactions() {
        return CmsPropertyHandler.getServerNodeProperty("logTransactions", true, "false");
    }

    public static String getEnableExtranetCookies() {
        return CmsPropertyHandler.getServerNodeProperty("enableExtranetCookies", true, "false");
    }

    public static String getUseAlternativeBrowserLanguageCheck() {
        return CmsPropertyHandler.getServerNodeProperty("useAlternativeBrowserLanguageCheck", true, "false");
    }

    public static String getCaseSensitiveRedirects() {
        return CmsPropertyHandler.getServerNodeProperty("caseSensitiveRedirects", true, "false");
    }

    public static String getUseDNSNameInURI() {
        return CmsPropertyHandler.getServerNodeProperty("useDNSNameInURI", true, "false");
    }

    public static String getWysiwygEditor() {
        return CmsPropertyHandler.getServerNodeProperty("wysiwygEditor", true, "FCKEditor");
    }

    public static String getDisableImageEditor() {
        return CmsPropertyHandler.getServerNodeProperty("disableImageEditor", true, "false");
    }

    public static String getProtectContentTypes() {
        return CmsPropertyHandler.getServerNodeProperty("protectContentTypes", true, "false");
    }

    public static String getProtectWorkflows() {
        return CmsPropertyHandler.getServerNodeProperty("protectWorkflows", true, "false");
    }

    public static String getProtectCategories() {
        return CmsPropertyHandler.getServerNodeProperty("protectCategories", true, "false");
    }

    public static String getHideProtectedProperties() {
        return CmsPropertyHandler.getServerNodeProperty("hideProtectedProperties", true, "true");
    }

    public static String getMaxRows() {
        return CmsPropertyHandler.getServerNodeProperty("maxRows", true, "100");
    }

    public static String getDefaultNumberOfYearsBeforeExpire() {
        return CmsPropertyHandler.getServerNodeProperty("defaultNumberOfYearsBeforeExpire", true, "50");
    }

    public static String getEnableDateTimeDirectEditing() {
        return CmsPropertyHandler.getServerNodeProperty("enableDateTimeDirectEditing", true, "false");
    }

    public static String getShowContentVersionFirst() {
        return CmsPropertyHandler.getServerNodeProperty("showContentVersionFirst", true, "true");
    }

    public static String getShowComponentsFirst() {
        return CmsPropertyHandler.getServerNodeProperty("showComponentsFirst", true, "true");
    }

    public static String getDecoratedPageInvoker() {
        return CmsPropertyHandler.getServerNodeProperty("decoratedPageInvoker", true, "simple");
    }

    public static String getShowAllWorkflows() {
        return CmsPropertyHandler.getServerNodeProperty("showAllWorkflows", true, "true");
    }

    public static String getIsPageCacheOn() {
        return CmsPropertyHandler.getServerNodeProperty("isPageCacheOn", true, "true");
    }

    public static String getEditOnSite() {
        return CmsPropertyHandler.getServerNodeProperty("editOnSite", true, "true");
    }

    public static String getUseSelectivePageCacheUpdate() {
        return CmsPropertyHandler.getServerNodeProperty("useSelectivePageCacheUpdate", true, "true");
    }

    public static String getExpireCacheAutomatically() {
        return CmsPropertyHandler.getServerNodeProperty("expireCacheAutomatically", true, "false");
    }

    public static String getCacheExpireInterval() {
        return CmsPropertyHandler.getServerNodeProperty("cacheExpireInterval", true, "1800");
    }

    public static String getDeliverRequestTimeout() {
        return CmsPropertyHandler.getServerNodeProperty("deliverRequestTimeout", true, "60000");
    }

    public static String getLiveDeliverRequestTimeout() {
        return CmsPropertyHandler.getServerNodeProperty("liveDeliverRequestTimeout", true, "60000");
    }

    public static boolean getKillLiveRequestWhichTimedout() {
        boolean killLiveRequestWhichTimedout = false;
        try {
            killLiveRequestWhichTimedout = Boolean.parseBoolean(CmsPropertyHandler.getServerNodeProperty("killLiveRequestWhichTimedout", true, "false"));
        }
        catch (Exception e) {
            logger.warn((Object)("Error parsing killLiveRequestWhichTimedout:" + e.getMessage()));
        }
        return killLiveRequestWhichTimedout;
    }

    public static String getUseHighLoadLimiter() {
        return CmsPropertyHandler.getServerNodeProperty("useHighLoadLimiter", true, "false");
    }

    public static String getMaxActiveRequests() {
        return CmsPropertyHandler.getServerNodeProperty("maxActiveRequests", true, "50");
    }

    public static String getMaxRequestTime() {
        return CmsPropertyHandler.getServerNodeProperty("maxRequestTime", true, "5000");
    }

    public static String getSessionTimeout() {
        return CmsPropertyHandler.getServerNodeProperty("session.timeout", true, "1800");
    }

    public static String getCompressPageCache() {
        return CmsPropertyHandler.getServerNodeProperty("compressPageCache", true, "true");
    }

    public static String getCompressPageResponse() {
        return CmsPropertyHandler.getServerNodeProperty("compressPageResponse", true, "false");
    }

    public static String getSiteNodesToRecacheOnPublishing() {
        return CmsPropertyHandler.getServerNodeProperty("siteNodesToRecacheOnPublishing", true);
    }

    public static String getRecachePublishingMethod() {
        return CmsPropertyHandler.getServerNodeProperty("recachePublishingMethod", true);
    }

    public static String getRecacheUrl() {
        return CmsPropertyHandler.getServerNodeProperty("recacheUrl", true);
    }

    public static String getUseUpdateSecurity() {
        return CmsPropertyHandler.getServerNodeProperty("useUpdateSecurity", true, "true");
    }

    public static String getAllowedAdminIP() {
        return CmsPropertyHandler.getServerNodeProperty("allowedAdminIP", true);
    }

    public static String getPageKey() {
        return CmsPropertyHandler.getServerNodeProperty("pageKey", true);
    }

    public static String getComponentKey() {
        return CmsPropertyHandler.getServerNodeProperty("componentKey", true);
    }

    public static String getCmsFullBaseUrl() {
        return CmsPropertyHandler.getServerNodeProperty("cmsFullBaseUrl", true);
    }

    public static String getCmsBaseUrl() {
        return CmsPropertyHandler.getServerNodeProperty("cmsBaseUrl", true);
    }

    public static String getComponentEditorUrl() {
        return CmsPropertyHandler.getServerNodeProperty("componentEditorUrl", true);
    }

    public static String getComponentRendererUrl() {
        return CmsPropertyHandler.getServerNodeProperty("componentRendererUrl", true);
    }

    public static String getComponentRendererAction() {
        return CmsPropertyHandler.getServerNodeProperty("componentRendererAction", true);
    }

    public static String getEditOnSiteUrl() {
        return CmsPropertyHandler.getServerNodeProperty("editOnSiteUrl", true);
    }

    public static String getUseFreeMarker() {
        return CmsPropertyHandler.getServerNodeProperty("useFreeMarker", true, "false");
    }

    public static String getWebServerAddress() {
        return CmsPropertyHandler.getServerNodeProperty("webServerAddress", true);
    }

    public static String getApplicationBaseAction() {
        return CmsPropertyHandler.getServerNodeProperty("applicationBaseAction", true);
    }

    public static String getDigitalAssetBaseUrl() {
        return CmsPropertyHandler.getServerNodeProperty("digitalAssetBaseUrl", true);
    }

    public static String getImagesBaseUrl() {
        return CmsPropertyHandler.getServerNodeProperty("imagesBaseUrl", true);
    }

    public static String getDigitalAssetPath() {
        return CmsPropertyHandler.getServerNodeProperty("digitalAssetPath", true, contextRootPath + "digitalAssets");
    }

    public static String getDigitalAssetPath0() {
        return CmsPropertyHandler.getServerNodeProperty("digitalAssetPath.0", true, contextRootPath + "digitalAssets");
    }

    public static String getEnableDiskAssets() {
        return CmsPropertyHandler.getServerNodeProperty("enableDiskAssets", true, "false");
    }

    public static String getEnableNiceURI() {
        return CmsPropertyHandler.getServerNodeProperty("enableNiceURI", true, "true");
    }

    public static String getNiceURIEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("niceURIEncoding", true, "UTF-8");
    }

    public static String getNiceURIAttributeName() {
        return CmsPropertyHandler.getServerNodeProperty("niceURIAttributeName", true, "NiceURIName");
    }

    public static String getRequestArgumentDelimiter() {
        return CmsPropertyHandler.getServerNodeProperty("requestArgumentDelimiter", true, "&amp;");
    }

    public static String getErrorUrl() {
        return CmsPropertyHandler.getServerNodeProperty("errorUrl", true);
    }

    public static String getErrorBusyUrl() {
        return CmsPropertyHandler.getServerNodeProperty("errorBusyUrl", true);
    }

    public static String getExternalThumbnailGeneration() {
        return CmsPropertyHandler.getServerNodeProperty("externalThumbnailGeneration", true);
    }

    public static String getURIEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("URIEncoding", true, "UTF-8");
    }

    public static String getWorkflowEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("workflowEncoding", true, "UTF-8");
    }

    public static String getFormsEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("formsEncoding", true, "UTF-8");
    }

    public static String getUploadFromEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("uploadFromEncoding", true, "ISO-8859-1");
    }

    public static String getUploadToEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("uploadToEncoding", true, "UTF-8");
    }

    public static String getAssetKeyFromEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("assetKeyFromEncoding", true, "ISO-8859-1");
    }

    public static String getAssetKeyToEncoding() {
        return CmsPropertyHandler.getServerNodeProperty("assetKeyToEncoding", true, "UTF-8");
    }

    public static String getUseShortTableNames() {
        return CmsPropertyHandler.getServerNodeProperty("useShortTableNames", true, "false");
    }

    public static String getUseImprovedContentCategorySearch() {
        return CmsPropertyHandler.getServerNodeProperty("useImprovedContentCategorySearch", true, "true");
    }

    public static String getDatabaseEngine() {
        return CmsPropertyHandler.getServerNodeProperty("databaseEngine", true, null);
    }

    public static String getLogDatabaseMessages() {
        return CmsPropertyHandler.getServerNodeProperty("logDatabaseMessages", true, "false");
    }

    public static String getStatisticsEnabled() {
        return CmsPropertyHandler.getServerNodeProperty("statistics.enabled", true, "false");
    }

    public static String getStatisticsLogPath() {
        return CmsPropertyHandler.getServerNodeProperty("statisticsLogPath", true, contextRootPath + "logs");
    }

    public static String getStatisticsLogOneFilePerDay() {
        return CmsPropertyHandler.getServerNodeProperty("statisticsLogOneFilePerDay", true, "false");
    }

    public static String getStatisticsLogger() {
        return CmsPropertyHandler.getServerNodeProperty("statisticsLogger", true, "W3CExtendedLogger");
    }

    public static String getEnablePortal() {
        return CmsPropertyHandler.getServerNodeProperty("enablePortal", true, "true");
    }

    public static String getPortletBase() {
        return CmsPropertyHandler.getServerNodeProperty("portletBase", true);
    }

    public static String getMailSmtpHost() {
        return CmsPropertyHandler.getServerNodeProperty("mail.smtp.host", true);
    }

    public static String getMailSmtpPort() {
        return CmsPropertyHandler.getServerNodeProperty("mail.smtp.port", true);
    }

    public static String getMailSmtpAuth() {
        return CmsPropertyHandler.getServerNodeProperty("mail.smtp.auth", true);
    }

    public static String getMailSmtpUser() {
        return CmsPropertyHandler.getServerNodeProperty("mail.smtp.user", true);
    }

    public static String getMailSmtpPassword() {
        return CmsPropertyHandler.getServerNodeProperty("mail.smtp.password", true);
    }

    public static String getMailContentType() {
        return CmsPropertyHandler.getServerNodeProperty("mail.contentType", true, "text/html");
    }

    public static String getSystemEmailSender() {
        return CmsPropertyHandler.getServerNodeProperty("systemEmailSender", true);
    }

    public static String getWarningEmailReceiver() {
        return CmsPropertyHandler.getServerNodeProperty("warningEmailReceiver", true);
    }

    public static String getExportFormat() {
        return CmsPropertyHandler.getServerNodeProperty("exportFormat", true, "2");
    }

    public static String getHelpUrl() {
        return CmsPropertyHandler.getServerNodeProperty("helpUrl", true);
    }

    public static String getProtectDeliverWorking() {
        return CmsPropertyHandler.getServerNodeProperty("protectDeliverWorking", true, "false");
    }

    public static String getProtectDeliverPreview() {
        return CmsPropertyHandler.getServerNodeProperty("protectDeliverPreview", true, "false");
    }

    public static String getForceIdentityCheck() {
        return CmsPropertyHandler.getServerNodeProperty("forceIdentityCheck", true, "false");
    }

    public static String getNumberOfVersionsToKeepDuringClean() {
        return CmsPropertyHandler.getServerNodeProperty("numberOfVersionsToKeepDuringClean", true, "-1");
    }

    public static String getKeepOnlyOldPublishedVersionsDuringClean() {
        return CmsPropertyHandler.getServerNodeProperty("keepOnlyOldPublishedVersionsDuringClean", true, "true");
    }

    public static String getAssetUploadTransformationsSettings() {
        return CmsPropertyHandler.getServerNodeDataProperty(null, "assetUploadTransformationsSettings", true, "");
    }

    public static String getAllowPublicationEventFilter() {
        return CmsPropertyHandler.getServerNodeProperty("allowPublicationEventFilter", true, "false");
    }

    public static String getDefaultPublicationEventFilter() {
        return CmsPropertyHandler.getServerNodeProperty("defaultPublicationEventFilter", true, "all");
    }

    public static String getPreferredLanguageCode(String userName) {
        return propertySet.getString("principal_" + userName + "_languageCode");
    }

    public static String getPreferredToolId(String userName) {
        return propertySet.getString("principal_" + userName + "_defaultToolId");
    }

    public static String getPreferredRepositoryId(String userName) {
        return propertySet.getString("principal_" + userName + "_defaultRepositoryId");
    }

    public static String getPropertiesParser() {
        return CmsPropertyHandler.getServerNodeProperty("propertiesParser", false, "xpp3");
    }

    public static String getAllowCrossSiteSubmitToPublish() {
        return CmsPropertyHandler.getServerNodeProperty("allowCrossSiteSubmitToPublish", true, "false");
    }

    public static String getEncodeValidateUrl() {
        return CmsPropertyHandler.getServerNodeProperty("encodeValidateUrl", true, "false");
    }

    public static String getEncodeCasServiceUrl() {
        return CmsPropertyHandler.getServerNodeProperty("encodeCasServiceUrl", true, "true");
    }

    public static boolean getDuplicateAssetsBetweenVersions() {
        String duplicateAssetsBetweenVersions = CmsPropertyHandler.getServerNodeProperty("duplicateAssetsBetweenVersions", true, "false");
        return Boolean.parseBoolean(duplicateAssetsBetweenVersions);
    }

    public static String getWYSIWYGToolbarComboPreviewCSS() {
        String WYSIWYGToolbarComboPreviewCSS = CmsPropertyHandler.getServerNodeDataProperty(null, "WYSIWYGToolbarComboPreviewCSS", true, "p, div, h1, h2, h3, h4, h5, h6, pre, address { font-family: Verdana, Arial, Sans serif; font-size: 10px; font-style: normal; font-weight: normal; }");
        if (WYSIWYGToolbarComboPreviewCSS == null || WYSIWYGToolbarComboPreviewCSS.equals("")) {
            WYSIWYGToolbarComboPreviewCSS = "p, div, h1, h2, h3, h4, h5, h6, pre, address { font-family: Verdana, Arial, Sans serif; font-size: 10px; font-style: normal; font-weight: normal; }";
        }
        return WYSIWYGToolbarComboPreviewCSS;
    }

    public static String getWYSIWYGEditorAreaCSS() {
        return CmsPropertyHandler.getServerNodeDataProperty(null, "WYSIWYGEditorAreaCSS", true, "");
    }

    public static List getInternalDeliveryUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        String internalDeliverUrlsString = CmsPropertyHandler.getServerNodeDataProperty(null, "internalDeliveryUrls", true, null);
        if (internalDeliverUrlsString != null && !internalDeliverUrlsString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(internalDeliverUrlsString.getBytes("UTF-8")));
                int i = 0;
                String deliverUrl = null;
                while ((deliverUrl = properties.getProperty("" + i)) != null) {
                    urls.add(deliverUrl);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            int i = 0;
            String deliverUrl = null;
            while ((deliverUrl = CmsPropertyHandler.getProperty("internalDeliverUrl." + i)) != null) {
                urls.add(deliverUrl);
                ++i;
            }
        }
        return urls;
    }

    public static List getPublicDeliveryUrls() {
        ArrayList<String> urls = new ArrayList<String>();
        String publicDeliverUrlString = CmsPropertyHandler.getServerNodeDataProperty(null, "publicDeliveryUrls", true, null);
        if (publicDeliverUrlString != null && !publicDeliverUrlString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(publicDeliverUrlString.getBytes("UTF-8")));
                int i = 0;
                String deliverUrl = null;
                while ((deliverUrl = properties.getProperty("" + i)) != null) {
                    urls.add(deliverUrl);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            int i = 0;
            String deliverUrl = null;
            while ((deliverUrl = CmsPropertyHandler.getProperty("publicDeliverUrl." + i)) != null) {
                urls.add(deliverUrl);
                ++i;
            }
        }
        return urls;
    }

    public static List<String> getDeploymentServers() {
        ArrayList<String> urls = new ArrayList<String>();
        String deploymentServersString = CmsPropertyHandler.getServerNodeDataProperty(null, "deploymentServers", true, null);
        if (deploymentServersString != null && !deploymentServersString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(deploymentServersString.getBytes("UTF-8")));
                int i = 0;
                String serverUrl = null;
                while ((serverUrl = properties.getProperty("" + i)) != null) {
                    urls.add(serverUrl);
                    ++i;
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        return urls;
    }

    public static List getToolLocales() {
        ArrayList<Locale> toolLocales = new ArrayList<Locale>();
        String toolLanguagesString = CmsPropertyHandler.getServerNodeDataProperty(null, "toolLanguages", true, null);
        if (toolLanguagesString != null && !toolLanguagesString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(toolLanguagesString.getBytes("UTF-8")));
                int index = 0;
                String languageCode = properties.getProperty("" + index);
                while (languageCode != null) {
                    Locale locale = new Locale(languageCode);
                    if (locale != null) {
                        toolLocales.add(locale);
                    }
                    languageCode = properties.getProperty("" + ++index);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        } else {
            int index = 0;
            String languageCode = CmsPropertyHandler.getProperty(String.valueOf(index) + ".toolLanguageCode");
            while (languageCode != null) {
                Locale locale = new Locale(languageCode);
                if (locale != null) {
                    toolLocales.add(locale);
                }
                languageCode = CmsPropertyHandler.getProperty(String.valueOf(++index) + ".toolLanguageCode");
            }
        }
        return toolLocales;
    }

    public static Map getCustomContentTypeIcons() {
        HashMap<Object, Object> customContentTypeIcons = new HashMap<Object, Object>();
        String customContentTypeIconsString = CmsPropertyHandler.getServerNodeDataProperty(null, "customContentTypeIcons", true, null);
        if (customContentTypeIconsString != null && !customContentTypeIconsString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(customContentTypeIconsString.getBytes("UTF-8")));
                customContentTypeIcons.putAll(properties);
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        return customContentTypeIcons;
    }

    public static Map getCacheSettings() {
        Map cacheSettings = new HashMap();
        String cacheSettingsString = CmsPropertyHandler.getServerNodeDataProperty(null, "cacheSettings", true, null, true);
        if (cacheSettingsString != null && !cacheSettingsString.equals("")) {
            try {
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(cacheSettingsString.getBytes("UTF-8")));
                cacheSettings = properties;
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        return cacheSettings;
    }

    public static String getPropertySetValue(String key) {
        String value = null;
        String cacheName = "propertySetCache";
        String cacheKey = key;
        value = (String)CacheController.getCachedObject(cacheName, cacheKey);
        if (value != null) {
            logger.info((Object)("Returning property " + cacheKey + " value " + value));
            return value;
        }
        value = propertySet.getString(key);
        logger.info((Object)("propertySetCache did not have value... refetched:" + value));
        CacheController.cacheObject(cacheName, cacheKey, value);
        return value;
    }

    public static String getAnonymousPassword() {
        String password = "anonymous";
        String specifiedPassword = CmsPropertyHandler.getServerNodeProperty("deliver", "security.anonymous.password", true, "anonymous");
        if (specifiedPassword != null && !specifiedPassword.equalsIgnoreCase("") && specifiedPassword.indexOf("security.anonymous.password") == -1) {
            password = specifiedPassword;
        }
        return password;
    }

    public static String getAnonymousUser() {
        String userName = "anonymous";
        String specifiedUserName = CmsPropertyHandler.getServerNodeProperty("deliver", "security.anonymous.username", true, "anonymous");
        if (specifiedUserName != null && !specifiedUserName.equalsIgnoreCase("") && specifiedUserName.indexOf("security.anonymous.username") == -1) {
            userName = specifiedUserName;
        }
        return userName;
    }

    public static Properties getCharacterReplacingMapping() {
        Properties properties = new Properties();
        String characterReplacingMappingString = CmsPropertyHandler.getServerNodeDataProperty(null, "niceURICharacterReplacingMapping", true, null);
        logger.info((Object)("characterReplacingMappingString:" + characterReplacingMappingString));
        if (characterReplacingMappingString != null && !characterReplacingMappingString.equals("")) {
            try {
                properties.load(new ByteArrayInputStream(characterReplacingMappingString.getBytes("ISO-8859-1")));
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        if (properties.size() == 0) {
            properties.put("\u00e5", "a");
            properties.put("\u00e4", "a");
            properties.put("\u00f6", "o");
            properties.put("\u00c5", "A");
            properties.put("\u00c4", "A");
            properties.put("\u00d6", "O");
        }
        return properties;
    }

    public static boolean getNiceURIUseLowerCase() {
        String niceURIUseLowerCase = CmsPropertyHandler.getServerNodeProperty("niceURIUseLowerCase", true, "false");
        return Boolean.parseBoolean(niceURIUseLowerCase);
    }
}

