/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import com.opensymphony.oscache.base.OSCacheUtility;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.apache.log4j.RollingFileAppender;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;

public final class CmsContextListener
implements ServletContextListener {
    private static final Logger logger = Logger.getLogger((String)CmsContextListener.class.getName());
    private static CacheController cacheController = new CacheController();

    public void contextInitialized(ServletContextEvent event) {
        try {
            String intervalString;
            String contextRootPath = event.getServletContext().getRealPath("/");
            if (!contextRootPath.endsWith("/") && !contextRootPath.endsWith("\\")) {
                contextRootPath = String.valueOf(contextRootPath) + "/";
            }
            System.out.println("\n**************************************");
            System.out.println("Initializing cms context for directory:" + contextRootPath);
            CmsPropertyHandler.setApplicationName("cms");
            CmsPropertyHandler.setContextRootPath(contextRootPath);
            String logPath = CmsPropertyHandler.getLogPath();
            Enumeration enumeration = Logger.getLogger((String)"org.infoglue.cms").getAllAppenders();
            while (enumeration.hasMoreElements()) {
                RollingFileAppender appender = (RollingFileAppender)enumeration.nextElement();
                if (!appender.getName().equalsIgnoreCase("INFOGLUE-FILE")) continue;
                appender.setFile(logPath);
                appender.activateOptions();
                Logger.getLogger((String)"org.infoglue.deliver.invokers.ComponentBasedHTMLPageInvoker").addAppender((Appender)appender);
                break;
            }
            String URIEncoding = CmsPropertyHandler.getURIEncoding();
            String expireCacheAutomaticallyString = CmsPropertyHandler.getExpireCacheAutomatically();
            if (expireCacheAutomaticallyString != null) {
                cacheController.setExpireCacheAutomatically(Boolean.parseBoolean(expireCacheAutomaticallyString));
            }
            if ((intervalString = CmsPropertyHandler.getCacheExpireInterval()) != null) {
                cacheController.setCacheExpireInterval(Integer.parseInt(intervalString));
            }
            if (cacheController.getExpireCacheAutomatically()) {
                cacheController.start();
            }
            OSCacheUtility.setServletCacheParams(event.getServletContext());
            CmsPropertyHandler.setStartupTime(new Date());
            System.out.println("**************************************\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        System.out.println("contextDestroyed....");
    }
}

