/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.NotificationListener;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.cms.util.RemoteCacheUpdater;
import org.infoglue.cms.util.TransactionHistoryWriter;

public class ChangeNotificationController {
    private static final Logger logger = Logger.getLogger((String)ChangeNotificationController.class.getName());
    private static ChangeNotificationController instance = null;
    private static ThreadLocalNotifications list = new ThreadLocalNotifications();
    private List listeners = new ArrayList();
    private List unregisteredlisteners = new ArrayList();

    public void put(NotificationMessage notificationMessage) {
        list.getList().add(notificationMessage);
    }

    public static void notifyListeners() {
        NotificationMessage notificationMessage;
        int i;
        if (list.getList().size() > 0) {
            logger.info((Object)"Now as the transaction is done and there are items in the notification list - let's notify the deliver app...");
        }
        ArrayList<NotificationMessage> internalMessageList = new ArrayList<NotificationMessage>();
        ArrayList<NotificationMessage> publicMessageList = new ArrayList<NotificationMessage>();
        Iterator iterator = list.getList().iterator();
        while (iterator.hasNext()) {
            NotificationMessage notificationMessage2 = (NotificationMessage)iterator.next();
            if (notificationMessage2.getType() == 10 || notificationMessage2.getType() == 30 || notificationMessage2.getType() == 100) {
                publicMessageList.add(notificationMessage2);
                if (notificationMessage2.getType() == 100) {
                    internalMessageList.add(notificationMessage2);
                }
            } else {
                internalMessageList.add(notificationMessage2);
            }
            iterator.remove();
        }
        Hashtable<String, Object> internalMessage = null;
        Hashtable<String, Object> publicMessage = null;
        if (internalMessageList.size() > 0) {
            internalMessage = new Hashtable<String, Object>();
            Iterator internalMessageListIterator = internalMessageList.iterator();
            i = 0;
            while (internalMessageListIterator.hasNext()) {
                notificationMessage = (NotificationMessage)internalMessageListIterator.next();
                internalMessage.put(String.valueOf(i) + ".className", notificationMessage.getClassName());
                internalMessage.put(String.valueOf(i) + ".objectId", notificationMessage.getObjectId());
                internalMessage.put(String.valueOf(i) + ".objectName", notificationMessage.getObjectName());
                internalMessage.put(String.valueOf(i) + ".typeId", "" + notificationMessage.getType());
                ++i;
            }
        }
        if (publicMessageList.size() > 0) {
            publicMessage = new Hashtable<String, Object>();
            Iterator publicMessageListIterator = publicMessageList.iterator();
            i = 0;
            while (publicMessageListIterator.hasNext()) {
                notificationMessage = (NotificationMessage)publicMessageListIterator.next();
                if (i == 0) {
                    publicMessage.put("className", notificationMessage.getClassName());
                    publicMessage.put("objectId", notificationMessage.getObjectId());
                    publicMessage.put("objectName", notificationMessage.getObjectName());
                    publicMessage.put("typeId", "" + notificationMessage.getType());
                }
                publicMessage.put(String.valueOf(i) + ".className", notificationMessage.getClassName());
                publicMessage.put(String.valueOf(i) + ".objectId", notificationMessage.getObjectId());
                publicMessage.put(String.valueOf(i) + ".objectName", notificationMessage.getObjectName());
                publicMessage.put(String.valueOf(i) + ".typeId", "" + notificationMessage.getType());
                ++i;
            }
        }
        try {
            new RemoteCacheUpdater().updateRemoteCaches(internalMessage, publicMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ChangeNotificationController getInstance() {
        if (instance == null) {
            instance = new ChangeNotificationController();
            String logTransactions = CmsPropertyHandler.getLogTransactions();
            if (logTransactions == null || !logTransactions.equalsIgnoreCase("false")) {
                instance.registerListener(new TransactionHistoryWriter());
            }
            instance.registerListener(list);
        }
        return instance;
    }

    private ChangeNotificationController() {
    }

    public void registerListener(NotificationListener notificationListener) {
        this.listeners.add(notificationListener);
    }

    public void unregisterListener(NotificationListener notificationListener) {
        this.unregisteredlisteners.add(notificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationMessage(NotificationMessage notificationMessage) {
        logger.info((Object)("Got a new notification:" + notificationMessage.getName() + ":" + notificationMessage.getType() + ":" + notificationMessage.getObjectId() + ":" + notificationMessage.getObjectName()));
        List list = this.listeners;
        synchronized (list) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                try {
                    NotificationListener nl = (NotificationListener)i.next();
                    if (this.unregisteredlisteners.contains(nl)) continue;
                    logger.info((Object)("Notifying the listener:" + nl.getClass().getName()));
                    nl.notify(notificationMessage);
                }
                catch (Exception e) {
                    logger.error((Object)("One of the listeners threw an exception but we carry on with the others. Error: " + e.getMessage()), (Throwable)e);
                }
            }
            this.listeners.removeAll(this.unregisteredlisteners);
        }
        list = this.unregisteredlisteners;
        synchronized (list) {
            this.unregisteredlisteners.clear();
        }
    }

    private static class ThreadLocalNotifications
    extends ThreadLocal
    implements NotificationListener {
        private ThreadLocalNotifications() {
        }

        public Object initialValue() {
            return new ArrayList();
        }

        public List getList() {
            return (List)super.get();
        }

        public void setContextParameters(Map map) {
        }

        public void notify(NotificationMessage message) {
            list.getList().add(message);
        }
    }
}

