/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.ConfigurationError;
import org.infoglue.cms.util.SimpleStringManager;
import org.infoglue.cms.util.StringManager;
import org.infoglue.cms.util.StringManagerFactory;

class ChainedStringManager
implements StringManager {
    private List managers = new ArrayList();
    private static final StringManager sm = StringManagerFactory.getSystemStringManager("org.infoglue.cms.util");

    ChainedStringManager() {
    }

    public final String getString(String key) {
        for (SimpleStringManager manager : this.managers) {
            if (!manager.containsKey(key)) continue;
            return manager.getString(key);
        }
        throw new ConfigurationError(sm.getString("chain.getString.not_found_error", key));
    }

    public final String getString(String key, Object[] args) {
        return MessageFormat.format(this.getString(key), args);
    }

    public final String getString(String key, Object arg) {
        return this.getString(key, new Object[]{arg});
    }

    public final String getString(String key, Object arg1, Object arg2) {
        return this.getString(key, new Object[]{arg1, arg2});
    }

    public final String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getString(key, new Object[]{arg1, arg2, arg3});
    }

    final void add(StringManager manager) {
        if (manager == null) {
            throw new Bug(sm.getString("chain.add.null_parameter_error"));
        }
        this.managers.add(manager);
    }
}

