/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeTreeUCC;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeTreeUCCFactory;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersion;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.entities.structure.SiteNode;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.treeservice.ss.SiteNodeNodeImpl;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.ConstraintExceptionBuffer;
import org.infoglue.cms.util.sorters.SiteNodeComparator;
import org.infoglue.deliver.util.Timer;

public class SiteNodeNodeSupplier
extends BaseNodeSupplier {
    private static final Logger logger = Logger.getLogger((String)SiteNodeNodeSupplier.class.getName());
    private ViewSiteNodeTreeUCC ucc;
    private ArrayList cacheLeafs;
    private InfoGluePrincipal infogluePrincipal = null;

    public SiteNodeNodeSupplier(Integer repositoryId, InfoGluePrincipal infoGluePrincipal) throws SystemException {
        this.infogluePrincipal = infoGluePrincipal;
        SiteNodeVO vo = null;
        this.ucc = ViewSiteNodeTreeUCCFactory.newViewSiteNodeTreeUCC();
        try {
            if (repositoryId != null && repositoryId > 0) {
                vo = this.ucc.getRootSiteNode(repositoryId, infoGluePrincipal);
                SiteNodeNodeImpl rootNode = new SiteNodeNodeImpl();
                rootNode.setChildren(true);
                rootNode.setId(vo.getId());
                rootNode.setTitle(vo.getName());
                rootNode.setContainer(vo.getIsBranch());
                this.setRootNode(rootNode);
            }
        }
        catch (ConstraintException e) {
            e.printStackTrace();
        }
    }

    public boolean hasChildren() {
        return false;
    }

    public Collection getChildContainerNodes(Integer parentNode) throws SystemException, Exception {
        Timer timer = new Timer();
        Database db = CastorDatabaseService.getDatabase();
        ConstraintExceptionBuffer ceb = new ConstraintExceptionBuffer();
        ArrayList<SiteNodeNodeImpl> ret = new ArrayList<SiteNodeNodeImpl>();
        this.cacheLeafs = new ArrayList();
        String sortProperty = CmsPropertyHandler.getStructureTreeSort();
        String isHiddenProperty = CmsPropertyHandler.getStructureTreeIsHiddenProperty();
        this.beginTransaction(db);
        try {
            SiteNode parentSiteNode = SiteNodeController.getSiteNodeWithId(parentNode, db, true);
            Collection children = parentSiteNode.getChildSiteNodes();
            List childrenVOList = SiteNodeController.toVOList(children);
            for (SiteNodeVO siteNodeVO : childrenVOList) {
                if (siteNodeVO.getMetaInfoContentId() == null || siteNodeVO.getMetaInfoContentId() <= -1) continue;
                try {
                    ContentVO contentVO = ContentController.getContentController().getContentVOWithId(siteNodeVO.getMetaInfoContentId(), db);
                    if (sortProperty == null) continue;
                    String[] sortOrders = sortProperty.split(",");
                    int i = sortOrders.length - 1;
                    while (i > -1) {
                        Object sortOrderProperty2 = sortOrders[i].trim();
                        if (((String)sortOrderProperty2).startsWith("extra:")) {
                            LanguageVO masterLanguage = LanguageController.getController().getMasterLanguage(contentVO.getRepositoryId(), db);
                            ContentVersion contentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersion(contentVO.getContentId(), masterLanguage.getId(), db);
                            if (contentVersion != null) {
                                sortOrderProperty2 = ((String)sortOrderProperty2).substring(6);
                                String propertyValue = ContentVersionController.getContentVersionController().getAttributeValue(contentVersion.getValueObject(), (String)sortOrderProperty2, false);
                                siteNodeVO.getExtraProperties().put(sortOrderProperty2, propertyValue);
                                if (isHiddenProperty != null && !isHiddenProperty.equals("")) {
                                    String hiddenProperty = ContentVersionController.getContentVersionController().getAttributeValue(contentVersion.getValueObject(), isHiddenProperty, false);
                                    if (hiddenProperty == null || hiddenProperty.equals("")) {
                                        hiddenProperty = "false";
                                    }
                                    siteNodeVO.getExtraProperties().put("isHidden", hiddenProperty);
                                }
                            }
                        }
                        --i;
                    }
                }
                catch (Exception e) {
                    logger.warn((Object)("The site node " + siteNodeVO.getName() + "[" + siteNodeVO.getId() + "] has problems: " + e.getMessage()), (Throwable)e);
                }
            }
            if (sortProperty != null) {
                String[] sortOrders = sortProperty.split(",");
                int i = sortOrders.length - 1;
                while (i > -1) {
                    String sortOrderProperty = sortOrders[i].trim();
                    if (sortOrderProperty.startsWith("extra:")) {
                        sortOrderProperty = sortOrderProperty.substring(6);
                    }
                    Collections.sort(childrenVOList, new SiteNodeComparator(sortOrderProperty, "asc", null));
                    for (Object sortOrderProperty2 : childrenVOList) {
                    }
                    --i;
                }
            }
            for (SiteNodeVO vo : childrenVOList) {
                boolean hasUserPageAccess = true;
                String useAccessRightsOnStructureTreeString = CmsPropertyHandler.getUseAccessRightsOnStructureTree();
                if (useAccessRightsOnStructureTreeString != null && useAccessRightsOnStructureTreeString.equalsIgnoreCase("true")) {
                    hasUserPageAccess = this.getHasUserPageAccess(this.infogluePrincipal, vo.getId());
                }
                if (!hasUserPageAccess) continue;
                SiteNodeNodeImpl node = new SiteNodeNodeImpl();
                node.setId(vo.getId());
                node.setTitle(vo.getName());
                node.getParameters().put("isHidden", vo.getExtraProperties().get("isHidden"));
                SiteNodeVersionVO latestSiteNodeVO = SiteNodeVersionController.getController().getLatestActiveSiteNodeVersionVO(db, vo.getId());
                if (latestSiteNodeVO != null) {
                    if (latestSiteNodeVO.getIsProtected().intValue() == SiteNodeVersionVO.YES.intValue()) {
                        node.getParameters().put("isProtected", "true");
                    }
                    if (!latestSiteNodeVO.getStateId().equals(SiteNodeVersionVO.PUBLISHED_STATE)) {
                        node.getParameters().put("stateId", "" + latestSiteNodeVO.getStateId());
                    }
                }
                if (vo.getIsBranch().booleanValue()) {
                    node.setContainer(true);
                    node.setChildren(vo.getChildCount() > 0);
                    ret.add(node);
                    continue;
                }
                node.setContainer(false);
                this.cacheLeafs.add(node);
            }
            this.commitTransaction(db);
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            this.rollbackTransaction(db);
            throw new SystemException(e.getMessage());
        }
        logger.info((Object)("Getting the sitenodes for the tree took " + timer.getElapsedTime() + "ms"));
        return ret;
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        return this.cacheLeafs;
    }
}

