/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.treeservice.ss.ManagementNodeImpl;

public class ManagementToolNodeSupplier
extends BaseNodeSupplier {
    private boolean showLeafs = true;
    private InfoGluePrincipal infogluePrincipal = null;

    public ManagementToolNodeSupplier(Integer repositoryId, InfoGluePrincipal infogluePrincipal) throws SystemException {
        this.infogluePrincipal = infogluePrincipal;
        if (repositoryId == 0) {
            this.setRootNode(new ManagementNodeImpl(repositoryId, "root", "ViewManagementToolStartPage.action"));
        } else {
            this.setRootNode(new ManagementNodeImpl(repositoryId, "root", "ViewRepository.action?repositoryId=" + repositoryId));
        }
    }

    public boolean hasChildren() {
        return !this.showLeafs;
    }

    public Collection getChildContainerNodes(Integer parentNode) {
        int cnt = 1;
        ArrayList<ManagementNodeImpl> r = new ArrayList<ManagementNodeImpl>();
        if (parentNode == 0) {
            if (this.hasAccessTo("ManagementToolMenu.Repositories", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Repositories", "ViewListRepository.action?title=Repositories"));
            }
            if (this.hasAccessTo("ManagementToolMenu.SystemUsers", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "SystemUsers", "ViewListSystemUser.action?title=SystemUsers"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Roles", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Roles", "ViewListRole.action?title=Roles"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Groups", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Groups", "ViewListGroup.action?title=Groups"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Languages", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Languages", "ViewListLanguage.action?title=Languages"));
            }
            if (this.hasAccessTo("ManagementToolMenu.InterceptionPoints", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "InterceptionPoints", "ViewListInterceptionPoint.action?title=InterceptionPoints"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Interceptors", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Interceptors", "ViewListInterceptor.action?title=Interceptors"));
            }
            if (this.hasAccessTo("ManagementToolMenu.ServiceDefinitions", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "ServiceDefinitions", "ViewListServiceDefinition.action?title=ServiceDefinitions"));
            }
            if (this.hasAccessTo("ManagementToolMenu.AvailableServiceBindings", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "AvailableServiceBindings", "ViewListAvailableServiceBinding.action?title=AvailableServiceBindings"));
            }
            if (this.hasAccessTo("ManagementToolMenu.SiteNodeTypeDefinitions", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "SiteNodeTypeDefinitions", "ViewListSiteNodeTypeDefinition.action?title=SiteNodeTypeDefinitions"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Categories", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Categories", "CategoryManagement!list.action?title=ContentCategories"));
            }
            if (this.hasAccessTo("ManagementToolMenu.ContentTypeDefinitions", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "ContentTypeDefinitions", "ViewListContentTypeDefinition.action?title=ContentTypeDefinitions"));
            }
            if (this.hasAccessTo("ManagementToolMenu.TransactionHistory", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "TransactionHistory", "ViewListTransactionHistory.action?title=TransactionHistory"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Up2Date", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Up2Date", "ViewListUp2Date.action?title=InfoGlue Up2Date"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Workflows", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Workflows", "ViewListWorkflowDefinition.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Portlets", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Portlets", "ViewListPortlet.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Redirects", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Redirects", "ViewListRedirect.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.ApplicationSettings", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Application settings", "ViewListServerNode.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.MessageCenter", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Message center", "ViewMessageCenter.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.Diagnostics", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "Diagnostics and status", "ViewDiagnosticCenter.action"));
            }
            if (this.hasAccessTo("ManagementToolMenu.SystemTools", this.infogluePrincipal, true)) {
                r.add(new ManagementNodeImpl(cnt++, "System tools", "ViewSystemTools.action"));
            }
        } else {
            r.add(new ManagementNodeImpl(cnt++, "Permissions", "ViewAccessRights.action?interceptionPointCategory=Repository&extraParameters=" + parentNode + "&colorScheme=ManagementTool&returnAddress=ViewRepositoryOverview.action?repositoryId=" + parentNode));
            r.add(new ManagementNodeImpl(cnt++, "Languages", "ViewListRepositoryLanguage.action?repositoryId=" + parentNode + "&title=Languages"));
        }
        return r;
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        ArrayList ret = new ArrayList();
        return ret;
    }
}

