/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.treeservice.ss.ContentNodeImpl;

public class ContentNodeVersionSupplier
extends BaseNodeSupplier {
    private ArrayList cacheLeafs;

    public ContentNodeVersionSupplier(Integer repositoryId, String userName) throws SystemException {
        ContentVO vo = null;
        try {
            vo = ContentControllerProxy.getController().getRootContentVO(repositoryId, userName);
            ContentNodeImpl rootNode = new ContentNodeImpl();
            rootNode.setChildren(true);
            rootNode.setId(vo.getId());
            rootNode.setTitle(vo.getName());
            rootNode.setContainer(vo.getIsBranch());
            this.setRootNode(rootNode);
        }
        catch (ConstraintException constraintException) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
    }

    public boolean hasChildren() {
        return false;
    }

    public Collection getChildContainerNodes(Integer parentNode) {
        ContentNodeImpl node;
        ArrayList<ContentNodeImpl> ret = new ArrayList<ContentNodeImpl>();
        this.cacheLeafs = new ArrayList();
        if (parentNode < 0) {
            return ret;
        }
        List l = null;
        try {
            l = ContentController.getContentController().getContentChildrenVOList(parentNode);
        }
        catch (ConstraintException constraintException) {
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        for (ContentVO vo : l) {
            if (!vo.getIsBranch().booleanValue()) continue;
            node = new ContentNodeImpl();
            node.setId(vo.getId());
            node.setContainer(true);
            node.setChildren(vo.getChildCount() > 0);
            node.setTitle(vo.getName());
            ret.add(node);
        }
        for (ContentVO vo : l) {
            if (vo.getIsBranch().booleanValue()) continue;
            node = new ContentNodeImpl();
            node.setId(new Integer(-vo.getId().intValue()));
            node.setContainer(true);
            node.setTitle(vo.getName());
            node.setChildren(vo.getChildCount() > 0);
            ret.add(node);
        }
        return ret;
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        ArrayList<ContentNodeImpl> ret = new ArrayList<ContentNodeImpl>();
        if (parentNode >= 0) {
            return ret;
        }
        List l = null;
        try {
            l = ContentVersionController.getContentVersionController().getContentVersionVOWithParent(new Integer(-parentNode.intValue()));
        }
        catch (SystemException systemException) {
            // empty catch block
        }
        for (ContentVersionVO vo : l) {
            ContentNodeImpl node = new ContentNodeImpl();
            node.setId(vo.getId());
            node.setState(vo.getStateId());
            node.setContainer(false);
            node.setTitle(String.valueOf(vo.getVersionComment()) + " (" + vo.getModifiedDateTime() + ")");
            node.getParameters().put("languageId", vo.getLanguageId());
            node.getParameters().put("languageName", vo.getLanguageName());
            ret.add(node);
        }
        return ret;
    }
}

