/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.treeservice.ss.ContentNodeImpl;

public class ContentNodeSupplierJDBC
extends BaseNodeSupplier {
    private ArrayList cacheLeafs;
    private Connection conn;

    public ContentNodeSupplierJDBC(Integer repositoryId, String userName) throws Exception, SystemException {
        Class.forName("com.mysql.jdbc.Driver").newInstance();
        this.conn = DriverManager.getConnection("jdbc:mysql://localhost/frovi_cms_dev?user=frovi_cms&password=pass123");
        Statement stmt = null;
        stmt = this.conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from cmContent where parentContentId is null and repositoryId=" + repositoryId);
        ContentNodeImpl rootNode = new ContentNodeImpl();
        if (rs.next()) {
            rootNode.setChildren(true);
            rootNode.setId(new Integer(rs.getInt("contentId")));
            rootNode.setTitle(rs.getString("name"));
            rootNode.setContainer(rs.getBoolean("isBranch"));
            this.setRootNode(rootNode);
        } else {
            ContentVO vo = null;
            try {
                vo = ContentControllerProxy.getController().getRootContentVO(repositoryId, userName);
                rootNode.setChildren(true);
                rootNode.setId(vo.getId());
                rootNode.setTitle(vo.getName());
                rootNode.setContainer(vo.getIsBranch());
                this.setRootNode(rootNode);
            }
            catch (ConstraintException constraintException) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    public boolean hasChildren() {
        return true;
    }

    public boolean hasChildren(Integer nodeId) {
        boolean res = false;
        ArrayList ret = new ArrayList();
        Object l = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery("select count(contentId) as cnt from cmContent where parentContentId=" + nodeId);
            if (rs.next()) {
                res = rs.getInt("cnt") > 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    public Collection getChildContainerNodes(Integer parentNode) {
        ArrayList<ContentNodeImpl> ret = new ArrayList<ContentNodeImpl>();
        this.cacheLeafs = new ArrayList();
        Object l = null;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery("select * from cmContent where parentContentId=" + parentNode);
            while (rs.next()) {
                ContentNodeImpl node = new ContentNodeImpl();
                node.setId(new Integer(rs.getInt("contentId")));
                node.setTitle(rs.getString("name"));
                node.setContainer(rs.getBoolean("isBranch"));
                if (node.isContainer()) {
                    ret.add(node);
                    continue;
                }
                this.cacheLeafs.add(node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        if (this.cacheLeafs == null) {
            this.getChildContainerNodes(parentNode);
        }
        return this.cacheLeafs;
    }
}

