/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentTypeDefinitionController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.LanguageController;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.ContentTypeDefinitionVO;
import org.infoglue.cms.entities.management.LanguageVO;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.treeservice.ss.ContentNodeImpl;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.sorters.ReflectionComparator;
import org.infoglue.deliver.util.Timer;

public class ContentNodeSupplier
extends BaseNodeSupplier {
    private static final Logger logger = Logger.getLogger((String)ContentNodeSupplier.class.getName());
    private ArrayList cacheLeafs;
    private boolean showLeafs = true;
    private String[] allowedContentTypeIds = null;
    private InfoGluePrincipal infogluePrincipal = null;
    private Integer repositoryId = null;
    private List languageVOList = null;

    public ContentNodeSupplier(Integer repositoryId, InfoGluePrincipal infogluePrincipal) throws SystemException {
        ContentVO vo = null;
        try {
            this.infogluePrincipal = infogluePrincipal;
            this.repositoryId = repositoryId;
            this.languageVOList = LanguageController.getController().getLanguageVOList(repositoryId);
            Timer t = new Timer();
            if (repositoryId != null && repositoryId > 0) {
                vo = ContentControllerProxy.getController().getRootContentVO(repositoryId, infogluePrincipal.getName());
                ContentNodeImpl rootNode = new ContentNodeImpl();
                rootNode.setChildren(true);
                rootNode.setId(vo.getId());
                rootNode.setTitle(vo.getName());
                rootNode.setContainer(vo.getIsBranch());
                this.setRootNode(rootNode);
            }
            if (logger.isDebugEnabled()) {
                t.printElapsedTime("root node processed");
            }
        }
        catch (ConstraintException e) {
            e.printStackTrace();
        }
    }

    public boolean hasChildren() {
        return !this.showLeafs;
    }

    public Collection getChildContainerNodes(Integer parentNode) {
        String sortProperty;
        ArrayList<ContentNodeImpl> ret = new ArrayList<ContentNodeImpl>();
        this.cacheLeafs = new ArrayList();
        Timer t = new Timer();
        ArrayList<ContentVO> children = null;
        try {
            children = ContentController.getContentController().getContentChildrenVOList(parentNode);
        }
        catch (ConstraintException e) {
            logger.warn((Object)"Error getting Content Children", (Throwable)e);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error getting Content Children", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            t.printElapsedTime("got children");
        }
        try {
            if (this.allowedContentTypeIds != null) {
                ArrayList<ContentVO> filteredList = new ArrayList<ContentVO>();
                for (ContentVO contentVO : children) {
                    if (contentVO.getContentTypeDefinitionId() != null && !contentVO.getIsBranch().booleanValue()) {
                        ContentTypeDefinitionVO contentTypeDefinitionVO = ContentTypeDefinitionController.getController().getContentTypeDefinitionVOWithId(contentVO.getContentTypeDefinitionId());
                        boolean exists = false;
                        int i = 0;
                        while (i < this.allowedContentTypeIds.length) {
                            String allowedId = this.allowedContentTypeIds[i];
                            if (allowedId.equalsIgnoreCase(contentTypeDefinitionVO.getId().toString())) {
                                exists = true;
                                break;
                            }
                            ++i;
                        }
                        if (!exists) continue;
                        filteredList.add(contentVO);
                        continue;
                    }
                    filteredList.add(contentVO);
                }
                children = filteredList;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error filtering Content Children", (Throwable)e);
        }
        if (logger.isDebugEnabled()) {
            t.printElapsedTime("Done filtering children");
        }
        if ((sortProperty = CmsPropertyHandler.getContentTreeSort()) != null) {
            Collections.sort(children, new ReflectionComparator(sortProperty));
        }
        for (ContentVO vo : children) {
            boolean hasUserContentAccess = true;
            String useAccessRightsOnContentTreeString = CmsPropertyHandler.getUseAccessRightsOnContentTree();
            if (useAccessRightsOnContentTreeString != null && useAccessRightsOnContentTreeString.equalsIgnoreCase("true")) {
                hasUserContentAccess = this.getHasUserContentAccess(this.infogluePrincipal, vo.getId());
            }
            if (vo.getName().equals("Meta info folder") && !this.infogluePrincipal.getIsAdministrator() || !hasUserContentAccess) continue;
            ContentNodeImpl node = new ContentNodeImpl();
            node.setId(vo.getId());
            node.setTitle(vo.getName());
            String disableCustomIcons = CmsPropertyHandler.getDisableCustomIcons();
            if (disableCustomIcons == null || !disableCustomIcons.equals("true")) {
                node.getParameters().put("contentTypeDefinitionId", vo.getContentTypeDefinitionId());
            }
            if (vo.getIsProtected().intValue() == ContentVO.YES.intValue()) {
                node.getParameters().put("isProtected", "true");
            }
            try {
                for (LanguageVO languageVO : this.languageVOList) {
                    ContentVersionVO latestContentVersion = ContentVersionController.getContentVersionController().getLatestActiveContentVersionVO(vo.getId(), languageVO.getId());
                    if (latestContentVersion == null || latestContentVersion.getStateId().equals(ContentVersionVO.PUBLISHED_STATE)) continue;
                    node.getParameters().put("stateId", "" + latestContentVersion.getStateId());
                    break;
                }
            }
            catch (Exception e) {
                logger.warn((Object)("A problem when fecthing latest master content version: " + e.getMessage()), (Throwable)e);
            }
            if (vo.getIsBranch().booleanValue()) {
                node.setContainer(true);
                node.setChildren(vo.getChildCount() > 0);
                ret.add(node);
                continue;
            }
            if (!this.showLeafs) continue;
            node.setContainer(false);
            this.cacheLeafs.add(node);
        }
        if (logger.isDebugEnabled()) {
            t.printElapsedTime("Done sorting children");
        }
        return ret;
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        return this.cacheLeafs == null ? new ArrayList() : this.cacheLeafs;
    }

    public void setShowLeafs(boolean showLeafs) {
        this.showLeafs = showLeafs;
    }

    public String[] getAllowedContentTypeIds() {
        return this.allowedContentTypeIds;
    }

    public void setAllowedContentTypeIds(String[] allowedContentTypeIds) {
        this.allowedContentTypeIds = allowedContentTypeIds;
    }
}

