/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice.ss;

import com.frovi.ss.Tree.BaseNodeSupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.CategoryController;
import org.infoglue.cms.entities.management.CategoryVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.treeservice.ss.CategoryNodeImpl;
import org.infoglue.cms.treeservice.ss.ContentNodeImpl;

public class CategoryNodeSupplier
extends BaseNodeSupplier {
    private static final Logger logger = Logger.getLogger((String)CategoryNodeSupplier.class.getName());
    public static final Integer ROOT = new Integer(-1);
    private CategoryController controller = CategoryController.getController();
    private ArrayList cacheLeafs;

    public CategoryNodeSupplier() {
        ContentNodeImpl rootNode = new ContentNodeImpl();
        rootNode.setChildren(true);
        rootNode.setId(ROOT);
        rootNode.setTitle("Categories");
        rootNode.setContainer(true);
        this.setRootNode(rootNode);
    }

    public boolean hasChildren() {
        return true;
    }

    public Collection getChildContainerNodes(Integer parentNode) {
        ArrayList<CategoryNodeImpl> ret = new ArrayList<CategoryNodeImpl>();
        this.cacheLeafs = new ArrayList();
        List children = null;
        try {
            children = ROOT.equals(parentNode) ? this.controller.findRootCategories() : this.controller.findActiveByParent(parentNode);
        }
        catch (SystemException e) {
            logger.warn((Object)"Error getting Category Children", (Throwable)e);
        }
        for (CategoryVO vo : children) {
            List grandkids = this.getGrandKids(vo.getId());
            CategoryNodeImpl node = new CategoryNodeImpl();
            node.setId(vo.getId());
            node.setTitle(vo.getName());
            node.setContainer(true);
            node.setChildren(!grandkids.isEmpty());
            ret.add(node);
        }
        return ret;
    }

    private List getGrandKids(Integer childId) {
        try {
            return this.controller.findActiveByParent(childId);
        }
        catch (SystemException e) {
            return Collections.EMPTY_LIST;
        }
    }

    public Collection getChildLeafNodes(Integer parentNode) {
        return Collections.EMPTY_LIST;
    }
}

