/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeTreeUCC;
import org.infoglue.cms.controllers.usecases.structuretool.ViewSiteNodeTreeUCCFactory;
import org.infoglue.cms.entities.structure.SiteNodeVO;
import org.infoglue.cms.net.CommunicationEnvelope;
import org.infoglue.cms.net.Node;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.treeservice.JServiceBuilder;

public class SiteNodeService
extends JServiceBuilder {
    private static final Logger logger = Logger.getLogger((String)SiteNodeService.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public CommunicationEnvelope execute(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            String action = envelope.getAction();
            logger.info((Object)("ACTION:" + action));
            if (action.equals("selectRootNode")) {
                responseEnvelope = this.getRootSiteNode(envelope);
            }
            if (action.equals("selectNode")) {
                responseEnvelope = this.getSiteNode(envelope);
            } else if (action.equals("selectChildNodes")) {
                responseEnvelope = this.getChildSiteNodes(envelope);
            }
            logger.info((Object)"Executing in SiteNodeService...");
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getRootSiteNode(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            Integer repositoryId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("repositoryId:" + repositoryId));
            ViewSiteNodeTreeUCC viewSiteNodeTreeUCC = ViewSiteNodeTreeUCCFactory.newViewSiteNodeTreeUCC();
            SiteNodeVO siteNodeVO = viewSiteNodeTreeUCC.getRootSiteNode(repositoryId, this.getInfoGluePrincipal());
            logger.info((Object)("siteNodeVO:" + siteNodeVO.getSiteNodeId() + " " + siteNodeVO.getName()));
            Node node = new Node();
            node.setId(siteNodeVO.getSiteNodeId());
            node.setName(siteNodeVO.getName());
            node.setIsBranch(siteNodeVO.getIsBranch());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(node);
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getSiteNode(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            Integer siteNodeId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("siteNodeId:" + siteNodeId));
            ViewSiteNodeTreeUCC viewSiteNodeTreeUCC = ViewSiteNodeTreeUCCFactory.newViewSiteNodeTreeUCC();
            SiteNodeVO siteNodeVO = viewSiteNodeTreeUCC.getSiteNode(siteNodeId);
            logger.info((Object)("siteNodeVO:" + siteNodeVO.getSiteNodeId() + " " + siteNodeVO.getName()));
            Node node = new Node();
            node.setId(siteNodeVO.getSiteNodeId());
            node.setName(siteNodeVO.getName());
            node.setIsBranch(siteNodeVO.getIsBranch());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(node);
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getChildSiteNodes(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            Integer siteNodeId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("siteNodeId:" + siteNodeId));
            ViewSiteNodeTreeUCC viewSiteNodeTreeUCC = ViewSiteNodeTreeUCCFactory.newViewSiteNodeTreeUCC();
            List childSiteNodes = viewSiteNodeTreeUCC.getSiteNodeChildren(siteNodeId);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (SiteNodeVO siteNodeVO : childSiteNodes) {
                Node node = new Node();
                node.setId(siteNodeVO.getSiteNodeId());
                node.setName(siteNodeVO.getName());
                node.setIsBranch(siteNodeVO.getIsBranch());
                nodes.add(node);
            }
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public InfoGluePrincipal getInfoGluePrincipal() {
        return (InfoGluePrincipal)this.request.getSession().getAttribute("org.infoglue.cms.security.user");
    }
}

