/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.infoglue.cms.net.CommunicationEnvelope;
import org.infoglue.cms.net.Node;

public abstract class JServiceBuilder
extends HttpServlet {
    private static final Logger logger = Logger.getLogger((String)JServiceBuilder.class.getName());
    protected HttpServletRequest request;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.request = request;
        Hashtable inHash = this.requestToHashtable(request);
        logger.info((Object)"Got request...");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            CommunicationEnvelope requestEnvelope = this.deserializeEnvelope(inHash);
            CommunicationEnvelope reponseEnvelope = this.execute(requestEnvelope);
            String responseString = this.toEncodedString(this.serializeEnvelope(reponseEnvelope));
            logger.info((Object)("Sending the string to the applet:" + responseString));
            out.println(responseString);
            out.flush();
            out.close();
            logger.info((Object)"Complete.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String toEncodedString(Hashtable inHash) throws Exception {
        StringBuffer buffer = new StringBuffer();
        Enumeration names = inHash.keys();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            String value = inHash.get(name).toString();
            buffer.append(String.valueOf(URLEncoder.encode(name, "UTF-8")) + "=" + URLEncoder.encode(value, "UTF-8"));
            if (!names.hasMoreElements()) continue;
            buffer.append("&");
        }
        return buffer.toString();
    }

    private CommunicationEnvelope deserializeEnvelope(Hashtable hash) {
        CommunicationEnvelope communicationEnvelope = new CommunicationEnvelope();
        communicationEnvelope.setAction("" + hash.get("action"));
        communicationEnvelope.setStatus("" + hash.get("status"));
        logger.info((Object)("Action:" + communicationEnvelope.getAction()));
        logger.info((Object)("Status:" + communicationEnvelope.getStatus()));
        ArrayList<Node> nodes = new ArrayList<Node>();
        int i = 0;
        String id = (String)hash.get("nodeList." + i + ".id");
        while (id != null) {
            Node n = new Node();
            n.setId(new Integer(id));
            n.setName((String)hash.get("nodeList." + i + ".name"));
            n.setIsBranch(new Boolean((String)hash.get("nodeList." + i + ".isBranch")));
            nodes.add(n);
            logger.info((Object)("Node:" + n));
            id = (String)hash.get("nodeList." + ++i + ".id");
        }
        communicationEnvelope.setNodes(nodes);
        return communicationEnvelope;
    }

    private Hashtable serializeEnvelope(CommunicationEnvelope requestEnvelope) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        logger.info((Object)("Serializing:" + requestEnvelope));
        hash.put("action", requestEnvelope.getAction());
        hash.put("status", requestEnvelope.getStatus());
        List nodes = requestEnvelope.getNodes();
        int i = 0;
        for (Node n : nodes) {
            hash.put("nodeList." + i + ".id", "" + n.getId());
            hash.put("nodeList." + i + ".name", n.getName());
            hash.put("nodeList." + i + ".isBranch", "" + n.getIsBranch());
            ++i;
        }
        return hash;
    }

    public Hashtable requestToHashtable(HttpServletRequest req) {
        Hashtable<String, String> input = new Hashtable<String, String>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getParameter(name);
            input.put(name, value);
        }
        return input;
    }

    public abstract CommunicationEnvelope execute(CommunicationEnvelope var1);
}

