/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.treeservice;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.net.CommunicationEnvelope;
import org.infoglue.cms.net.Node;
import org.infoglue.cms.treeservice.JServiceBuilder;

public class ContentService
extends JServiceBuilder {
    private static final Logger logger = Logger.getLogger((String)ContentService.class.getName());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public CommunicationEnvelope execute(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            String action = envelope.getAction();
            logger.info((Object)("ACTION:" + action));
            if (action.equals("selectRootNode")) {
                responseEnvelope = this.getRootContent(envelope);
            }
            if (action.equals("selectNode")) {
                responseEnvelope = this.getContent(envelope);
            } else if (action.equals("selectChildNodes")) {
                responseEnvelope = this.getChildContents(envelope);
            }
            logger.info((Object)"Executing in ContentService...");
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getRootContent(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            logger.info((Object)("arguments:" + arguments.size()));
            Integer repositoryId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("repositoryId:" + repositoryId));
            ContentVO contentVO = ContentControllerProxy.getController().getRootContentVO(repositoryId, this.request.getRemoteUser());
            logger.info((Object)("contentVO:" + contentVO.getContentId() + " " + contentVO.getName()));
            Node node = new Node();
            node.setId(contentVO.getContentId());
            node.setName(contentVO.getName());
            node.setIsBranch(contentVO.getIsBranch());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(node);
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getContent(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            Integer contentId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("contentId:" + contentId));
            ContentVO contentVO = ContentController.getContentController().getContentVOWithId(contentId);
            logger.info((Object)("contentVO:" + contentVO.getContentId() + " " + contentVO.getName()));
            Node node = new Node();
            node.setId(contentVO.getContentId());
            node.setName(contentVO.getName());
            node.setIsBranch(contentVO.getIsBranch());
            ArrayList<Node> nodes = new ArrayList<Node>();
            nodes.add(node);
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }

    public CommunicationEnvelope getChildContents(CommunicationEnvelope envelope) {
        CommunicationEnvelope responseEnvelope = new CommunicationEnvelope();
        try {
            List arguments = envelope.getNodes();
            Integer contentId = ((Node)arguments.get(0)).getId();
            logger.info((Object)("contentId:" + contentId));
            List childContents = ContentController.getContentController().getContentChildrenVOList(contentId);
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (ContentVO contentVO : childContents) {
                Node node = new Node();
                node.setId(contentVO.getContentId());
                node.setName(contentVO.getName());
                node.setIsBranch(contentVO.getIsBranch());
                nodes.add(node);
            }
            responseEnvelope.setNodes(nodes);
        }
        catch (Exception e) {
            responseEnvelope.setStatus("1");
            e.printStackTrace();
        }
        return responseEnvelope;
    }
}

