/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security.interceptors;

import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.structure.SiteNodeVersion;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.interceptors.InfoGlueInterceptor;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;

public class InfoGlueOSWorkflowInterceptor
implements InfoGlueInterceptor {
    private static final Logger logger = Logger.getLogger((String)InfoGlueOSWorkflowInterceptor.class.getName());

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess) throws ConstraintException, SystemException, Exception {
        Integer siteNodeId;
        Integer siteNodeVersionId;
        Integer contentVersionId;
        Integer contentId;
        logger.info((Object)("interceptionPointVO:" + interceptionPointVO.getName()));
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        try {
            BasicWorkflow workflowInit = new BasicWorkflow(infoGluePrincipal.getName());
            long id = workflowInit.initialize("MattiasWF", 1, new HashMap());
            logger.info((Object)"Workflow initialized....");
            logger.info((Object)("id:" + id));
            logger.info((Object)("name:" + workflowInit.getWorkflowName(id)));
            BasicWorkflow workflow = workflowInit;
            int[] actions = workflow.getAvailableActions(id, null);
            logger.info((Object)("actions:" + actions.length));
            WorkflowDescriptor wd = workflow.getWorkflowDescriptor(workflow.getWorkflowName(id));
            int i = 0;
            while (i < actions.length) {
                int availableActionId = actions[i];
                String name = wd.getAction(availableActionId).getName();
                logger.info((Object)("Action:" + availableActionId + ":" + name));
                ++i;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userName", "Mattias");
            workflow.doAction(id, 1, map);
            actions = workflow.getAvailableActions(id, null);
            logger.info((Object)("actions:" + actions.length));
            wd = workflow.getWorkflowDescriptor(workflow.getWorkflowName(id));
            int i2 = 0;
            while (i2 < actions.length) {
                int availableActionId = actions[i2];
                String name = wd.getAction(availableActionId).getName();
                logger.info((Object)("Action:" + availableActionId + ":" + name));
                ++i2;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (interceptionPointVO.getName().equalsIgnoreCase("Content.Read")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Write")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Create")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Delete")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Move")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.CreateVersion")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.SubmitToPublish")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.ChangeAccessRights")) {
            contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Read")) {
            contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Write")) {
            contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Delete")) {
            contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Read")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Write")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.CreateSiteNode")) {
            Integer parentSiteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(parentSiteNodeId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.DeleteSiteNode")) {
            siteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.MoveSiteNode")) {
            siteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.SubmitToPublish")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.ChangeAccessRights")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
        }
        ceb.throwIfNotEmpty();
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, Database db) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true, db);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess, Database db) throws ConstraintException, SystemException, Exception {
        logger.info((Object)("interceptionPointVO:" + interceptionPointVO.getName()));
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Write")) {
            Integer protectedSiteNodeVersionId;
            logger.info((Object)"******************************************************");
            logger.info((Object)"SiteNodeVersion.ChangeAccessRights");
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersion siteNodeVersion = SiteNodeVersionController.getController().getSiteNodeVersionWithId(siteNodeVersionId, db);
            logger.info((Object)("VersionModifier:" + siteNodeVersion.getVersionModifier()));
            logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal.getName()));
            if (!siteNodeVersion.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) && (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId, db)) != null && !AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "SiteNodeVersion.Write", siteNodeVersionId.toString())) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1001"));
            }
        }
        ceb.throwIfNotEmpty();
    }
}

