/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security.interceptors;

import java.util.Map;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.AccessRightController;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.ContentVersionControllerProxy;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionController;
import org.infoglue.cms.controllers.kernel.impl.simple.SiteNodeVersionControllerProxy;
import org.infoglue.cms.entities.content.ContentVO;
import org.infoglue.cms.entities.content.ContentVersionVO;
import org.infoglue.cms.entities.management.InterceptionPointVO;
import org.infoglue.cms.entities.structure.SiteNodeVersionVO;
import org.infoglue.cms.exception.AccessConstraintException;
import org.infoglue.cms.exception.ConstraintException;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.interceptors.InfoGlueInterceptor;
import org.infoglue.cms.util.AccessConstraintExceptionBuffer;

public class InfoGlueCommonAccessRightsInterceptor
implements InfoGlueInterceptor {
    private static final Logger logger = Logger.getLogger((String)InfoGlueCommonAccessRightsInterceptor.class.getName());

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess) throws ConstraintException, SystemException, Exception {
        logger.info((Object)("interceptionPointVO:" + interceptionPointVO.getName()));
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (interceptionPointVO.getName().equalsIgnoreCase("Content.Read")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Read", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1000"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Write")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Write", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1001"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Create")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Create", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1002"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Delete")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Delete", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1003"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.Move")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Move", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1004"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.CreateVersion")) {
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!allowCreatorAccess || !contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName())) {
                Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId);
                if (ContentVersionControllerProxy.getController().getIsContentProtected(contentId, true) && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.CreateVersion", protectedContentId.toString())) {
                    ceb.add(new AccessConstraintException("Content.contentId", "1002"));
                }
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.SubmitToPublish")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.SubmitToPublish", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1005"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("Content.ChangeAccessRights")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.ChangeAccessRights", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1006"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Read")) {
            Integer contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
            if (!allowCreatorAccess || !contentVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName())) {
                if (ContentVersionControllerProxy.getController().getIsContentProtected(contentVersionVO.getContentId(), false) && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "ContentVersion.Read", contentVersionId.toString())) {
                    ceb.add(new AccessConstraintException("ContentVersion.contentVersionId", "1000"));
                } else {
                    Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentVersionVO.getContentId());
                    if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Read", protectedContentId.toString())) {
                        ceb.add(new AccessConstraintException("Content.contentId", "1000"));
                    }
                }
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Write")) {
            Integer contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
            if (!allowCreatorAccess || !contentVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName())) {
                if (ContentVersionControllerProxy.getController().getIsContentProtected(contentVersionVO.getContentId(), false) && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "ContentVersion.Write", contentVersionId.toString())) {
                    ceb.add(new AccessConstraintException("ContentVersion.contentVersionId", "1001"));
                } else {
                    Integer protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentVersionVO.getContentId());
                    if (protectedContentId != null && !AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "Content.Write", protectedContentId.toString())) {
                        ceb.add(new AccessConstraintException("Content.contentId", "1001"));
                    }
                }
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("ContentVersion.Delete")) {
            Integer contentVersionId = (Integer)extradata.get("contentVersionId");
            ContentVersionVO contentVersionVO = ContentVersionControllerProxy.getController().getContentVersionVOWithId(contentVersionId);
            if (!(allowCreatorAccess && contentVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || !ContentVersionControllerProxy.getController().getIsContentProtected(contentVersionVO.getContentId(), false) || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "ContentVersion.Delete", contentVersionId.toString()))) {
                ceb.add(new AccessConstraintException("ContentVersion.contentVersionId", "1003"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Read")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1000"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Write")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.Write", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1001"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.CreateSiteNode")) {
            Integer protectedSiteNodeVersionId;
            Integer parentSiteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(parentSiteNodeId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionVO.getId())) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.CreateSiteNode", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1002"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.DeleteSiteNode")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionVO.getId())) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.DeleteSiteNode", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1003"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.MoveSiteNode")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeId = (Integer)extradata.get("siteNodeId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(siteNodeId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionVO.getId())) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.MoveSiteNode", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1004"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.SubmitToPublish")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.SubmitToPublish", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1005"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.ChangeAccessRights")) {
            Integer protectedSiteNodeVersionId;
            Integer siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            SiteNodeVersionVO siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId)) == null || AccessRightController.getController().getIsPrincipalAuthorized(infoGluePrincipal, "SiteNodeVersion.ChangeAccessRights", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1006"));
            }
        }
        ceb.throwIfNotEmpty();
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, Database db) throws ConstraintException, SystemException, Exception {
        this.intercept(infoGluePrincipal, interceptionPointVO, extradata, true, db);
    }

    public void intercept(InfoGluePrincipal infoGluePrincipal, InterceptionPointVO interceptionPointVO, Map extradata, boolean allowCreatorAccess, Database db) throws ConstraintException, SystemException, Exception {
        Integer siteNodeVersionId;
        Integer protectedSiteNodeVersionId;
        SiteNodeVersionVO siteNodeVersionVO;
        logger.info((Object)("interceptionPointVO:" + interceptionPointVO.getName()));
        AccessConstraintExceptionBuffer ceb = new AccessConstraintExceptionBuffer();
        if (interceptionPointVO.getName().equalsIgnoreCase("Content.Read")) {
            Integer protectedContentId;
            Integer contentId = (Integer)extradata.get("contentId");
            ContentVO contentVO = ContentControllerProxy.getController().getContentVOWithId(contentId, db);
            if (!(allowCreatorAccess && contentVO.getCreatorName().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedContentId = ContentControllerProxy.getController().getProtectedContentId(contentId, db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "Content.Read", protectedContentId.toString()))) {
                ceb.add(new AccessConstraintException("Content.contentId", "1000"));
            }
        }
        if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.CreateSiteNode")) {
            Integer parentSiteNodeId = (Integer)extradata.get("siteNodeId");
            siteNodeVersionVO = SiteNodeVersionController.getController().getLatestSiteNodeVersionVO(db, parentSiteNodeId);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionVO.getId(), db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "SiteNodeVersion.CreateSiteNode", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeId", "1002"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Read")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId, db);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId, db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "SiteNodeVersion.Read", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1000"));
            }
        } else if (interceptionPointVO.getName().equalsIgnoreCase("SiteNodeVersion.Write")) {
            siteNodeVersionId = (Integer)extradata.get("siteNodeVersionId");
            siteNodeVersionVO = SiteNodeVersionController.getController().getSiteNodeVersionVOWithId(siteNodeVersionId, db);
            if (!(allowCreatorAccess && siteNodeVersionVO.getVersionModifier().equalsIgnoreCase(infoGluePrincipal.getName()) || (protectedSiteNodeVersionId = SiteNodeVersionControllerProxy.getSiteNodeVersionControllerProxy().getProtectedSiteNodeVersionId(siteNodeVersionId, db)) == null || AccessRightController.getController().getIsPrincipalAuthorized(db, infoGluePrincipal, "SiteNodeVersion.Write", protectedSiteNodeVersionId.toString()))) {
                ceb.add(new AccessConstraintException("SiteNodeVersion.siteNodeVersionId", "1001"));
            }
        }
        ceb.throwIfNotEmpty();
    }
}

