/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;
import org.infoglue.deliver.util.Timer;

public class SimplifiedJNDIBasicAuthorizationModule
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)SimplifiedJNDIBasicAuthorizationModule.class.getName());
    protected Properties extraProperties = null;

    public boolean getSupportUpdate() {
        return false;
    }

    public boolean getSupportDelete() {
        return false;
    }

    public boolean getSupportCreate() {
        return false;
    }

    public DirContext getContext() throws Exception {
        String connectionURL = this.extraProperties.getProperty("connectionURL");
        String ldapVersion = this.extraProperties.getProperty("ldapVersion");
        String socketFactory = this.extraProperties.getProperty("socketFactory");
        String authenticationMethod = this.extraProperties.getProperty("authenticationMethod");
        String connectionName = this.extraProperties.getProperty("connectionName");
        String connectionPassword = this.extraProperties.getProperty("connectionPassword");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionURL);
        env.put("java.naming.batchsize", "100");
        if (ldapVersion != null && !ldapVersion.equals("3")) {
            env.put("java.naming.ldap.version", ldapVersion);
        } else {
            env.put("java.naming.ldap.version", "3");
        }
        if (socketFactory != null && !socketFactory.equals("")) {
            env.put("java.naming.ldap.factory.socket", "org.infoglue.cms.security.DummySSLSocketFactory");
        }
        if (authenticationMethod != null && authenticationMethod.equals("none")) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", connectionName);
            env.put("java.naming.security.credentials", connectionPassword);
        }
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public DirContext getContext(Control[] controls) throws Exception {
        String connectionURL = this.extraProperties.getProperty("connectionURL");
        String ldapVersion = this.extraProperties.getProperty("ldapVersion");
        String socketFactory = this.extraProperties.getProperty("socketFactory");
        String authenticationMethod = this.extraProperties.getProperty("authenticationMethod");
        String connectionName = this.extraProperties.getProperty("connectionName");
        String connectionPassword = this.extraProperties.getProperty("connectionPassword");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionURL);
        if (ldapVersion != null && !ldapVersion.equals("3")) {
            env.put("java.naming.ldap.version", ldapVersion);
        } else {
            env.put("java.naming.ldap.version", "3");
        }
        if (socketFactory != null && !socketFactory.equals("")) {
            env.put("java.naming.ldap.factory.socket", "org.infoglue.cms.security.DummySSLSocketFactory");
        }
        if (authenticationMethod != null && authenticationMethod.equals("none")) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", connectionName);
            env.put("java.naming.security.credentials", connectionPassword);
        }
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        InitialLdapContext ctx = new InitialLdapContext(env, controls);
        return ctx;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        boolean isAdministrator;
        String userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        logger.info((Object)("userName:" + userName));
        String userBase = this.extraProperties.getProperty("userBase");
        String key = "user_" + userName + authorizerIndex;
        InfoGluePrincipal infogluePrincipal = null;
        Object infogluePrincipalObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(userCacheTimeout));
        if (infogluePrincipalObject != null) {
            if (infogluePrincipalObject instanceof NullObject) {
                return null;
            }
            infogluePrincipal = (InfoGluePrincipal)infogluePrincipalObject;
            return infogluePrincipal;
        }
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            DirContext ctx = this.getContext();
            try {
                try {
                    String[] userBases = null;
                    if (userBase != null) {
                        userBases = userBase.split(";");
                    }
                    boolean isFullName = false;
                    int i = 0;
                    while (i < userBases.length) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Looking if the userName " + userName + " is a full name:" + userBases[i] + "=" + (userName.indexOf(userBases[i]) > -1)));
                        }
                        if (userName.toLowerCase().indexOf(userBases[i].toLowerCase()) > -1) {
                            isFullName = true;
                            break;
                        }
                        ++i;
                    }
                    if (!isFullName) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("UserName " + userName + " was not a full name"));
                        }
                        userName = this.getDistinguishedUserName(userName, ctx);
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("userName:" + userName));
                        }
                    }
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("userAttributes:" + userName));
                    }
                    Map userAttributes = this.getUserAttributes(userName, ctx);
                    List roles = this.getRoles(userName, ctx);
                    List groups = this.getGroups(userName, ctx);
                    infogluePrincipal = new InfoGluePrincipal(userName, (String)userAttributes.get("displayName"), (String)userAttributes.get("firstName"), (String)userAttributes.get("lastName"), (String)userAttributes.get("mail"), roles, groups, isAdministrator, (AuthorizationModule)this);
                    infogluePrincipal.getMetaInformation().putAll(userAttributes);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("metaInformation 2:" + infogluePrincipal.hasCode() + ":" + infogluePrincipal.getMetaInformation() + ":" + userAttributes));
                    }
                    if (infogluePrincipal != null) {
                        CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infogluePrincipal, null, false);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error:" + e.getMessage()));
                    CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
                    ctx.close();
                }
            }
            finally {
                ctx.close();
            }
        }
        return infogluePrincipal;
    }

    /*
     * Unable to fully structure code
     */
    private String getDistinguishedUserName(String userName, DirContext ctx) throws Exception {
        distinguishedUserName = null;
        userBase = this.extraProperties.getProperty("userBase");
        userBases = null;
        if (userBase != null) {
            userBases = userBase.split(";");
        }
        userSearch = this.extraProperties.getProperty("userSearch");
        userAttributesFilter = this.extraProperties.getProperty("userAttributesFilter", "cn, distinguishedName");
        userNameAttributeFilter = this.extraProperties.getProperty("userNameAttributeFilter", "distinguishedName");
        userBaseIndex = 0;
        while (userBaseIndex < userBases.length) {
            baseDN = userBases[userBaseIndex];
            if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Searching for distinguished name in " + baseDN));
            }
            try {
                anonymousUserName = CmsPropertyHandler.getAnonymousUser();
                if (userName.equals(anonymousUserName) && (anonymousUserBase = this.extraProperties.getProperty("anonymousUserBase")) != null && !anonymousUserBase.equals("")) {
                    baseDN = anonymousUserBase;
                }
                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userName:" + userName));
                index = 0;
                samAccountDomainName = this.extraProperties.getProperty("samAccountDomainName." + index);
                while (samAccountDomainName != null) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("samAccountDomainName:" + samAccountDomainName));
                    if (samAccountDomainName != null && !samAccountDomainName.equals("") && (startIndex = userName.indexOf(samAccountDomainName)) > -1) {
                        userName = String.valueOf(userName.substring(0, startIndex)) + userName.substring(startIndex + samAccountDomainName.length());
                    }
                    samAccountDomainName = this.extraProperties.getProperty("samAccountDomainName." + ++index);
                }
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userName:" + userName));
                }
                searchFilter = "(CN=" + userName + ")";
                if (userSearch != null && userSearch.length() > 0) {
                    searchFilter = userSearch.replaceAll("\\{1\\}", userName);
                }
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
                }
                attributesFilter = "cn, distinguishedName";
                if (userAttributesFilter != null && userAttributesFilter.length() > 0) {
                    attributesFilter = userAttributesFilter;
                }
                attrID = attributesFilter.split(",");
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN));
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attrID" + attrID));
                }
                ctls = new SearchControls();
                ctls.setSearchScope(2);
                ctls.setReturningAttributes(attrID);
                answer = ctx.search(baseDN, searchFilter, ctls);
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN + " - " + searchFilter + "\n" + answer.hasMore()));
                }
                if (answer.hasMore()) ** GOTO lbl67
                throw new Exception("The user with userName=" + userName + " was not found in the JNDI Data Source.");
lbl-1000:
                // 1 sources

                {
                    sr = answer.next();
                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Person:" + sr.toString() + "\n"));
                    }
                    attributes = sr.getAttributes();
                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attributes:" + attributes + "\n"));
                    }
                    userNameAttribute = attributes.get(userNameAttributeFilter);
                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userNameAttribute:" + userNameAttribute.toString()));
                    }
                    if (userNameAttribute == null) continue;
                    allEnum = userNameAttribute.getAll();
                    while (allEnum.hasMore()) {
                        value = (String)allEnum.next();
                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("value:" + value));
                        }
                        if ((distinguishedUserName = value) == null) continue;
                        return distinguishedUserName;
                    }
lbl67:
                    // 3 sources

                    ** while (answer.hasMore())
                }
lbl68:
                // 1 sources

            }
            catch (Exception e) {
                SimplifiedJNDIBasicAuthorizationModule.logger.warn((Object)e);
            }
            ++userBaseIndex;
        }
        if (distinguishedUserName == null) {
            throw new Exception("No user called " + userName + " was found.");
        }
        return distinguishedUserName;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName, boolean attachRolesAndGroups, DirContext ctx) throws Exception {
        boolean isAdministrator;
        String userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        String key = "user_" + userName + authorizerIndex;
        InfoGluePrincipal infogluePrincipal = null;
        Object infogluePrincipalObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(userCacheTimeout));
        if (infogluePrincipalObject != null) {
            if (infogluePrincipalObject instanceof NullObject) {
                return null;
            }
            infogluePrincipal = (InfoGluePrincipal)infogluePrincipalObject;
            return infogluePrincipal;
        }
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            try {
                Map userAttributes = this.getUserAttributes(userName, ctx);
                List roles = new ArrayList();
                List groups = new ArrayList();
                if (attachRolesAndGroups) {
                    roles = this.getRoles(userName, ctx);
                    groups = this.getGroups(userName, ctx);
                }
                infogluePrincipal = new InfoGluePrincipal(userName, (String)userAttributes.get("displayName"), (String)userAttributes.get("firstName"), (String)userAttributes.get("lastName"), (String)userAttributes.get("mail"), roles, groups, isAdministrator, (AuthorizationModule)this);
                infogluePrincipal.getMetaInformation().putAll(userAttributes);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("metaInformation 1:" + infogluePrincipal.hasCode() + ":" + infogluePrincipal.getMetaInformation() + ":" + userAttributes));
                }
                if (infogluePrincipal != null) {
                    CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infogluePrincipal, null, false);
                }
            }
            catch (Exception e) {
                CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
            }
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = null;
        DirContext ctx = this.getContext();
        try {
            role = this.getAuthorizedInfoGlueRole(roleName, ctx);
        }
        finally {
            ctx.close();
        }
        return role;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName, DirContext ctx) throws Exception {
        String roleCacheTimeout = this.extraProperties.getProperty("roleCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        String key = "role_" + roleName.hashCode() + "_" + authorizerIndex;
        InfoGlueRole infoglueRole = null;
        Object infoglueRoleObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(roleCacheTimeout));
        if (infoglueRoleObject != null) {
            if (infoglueRoleObject instanceof NullObject) {
                return null;
            }
            infoglueRole = (InfoGlueRole)infoglueRoleObject;
            return infoglueRole;
        }
        logger.info((Object)"\n\n\n ---------- getAuthorizedInfoGlueRole starting ---------\n\n\n");
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute", "distinguishedName");
        String roleDisplayNameAttribute = this.extraProperties.getProperty("roleDisplayNameAttribute", "cn");
        String roleDescriptionAttribute = this.extraProperties.getProperty("roleDescriptionAttribute", "description");
        try {
            logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
            logger.info((Object)("roleDisplayNameAttribute:" + roleDisplayNameAttribute));
            logger.info((Object)("roleDescriptionAttribute:" + roleDescriptionAttribute));
            Attributes attributes = ctx.getAttributes(roleName);
            logger.info((Object)("attributes:" + attributes.toString()));
            if (attributes == null) {
                logger.info((Object)("Could not find " + roleName));
            }
            String name = null;
            Attribute nameAttribute = attributes.get(roleNameAttribute);
            logger.info((Object)("nameAttribute:" + nameAttribute.toString()));
            NamingEnumeration<?> nameAttributeAllEnum = nameAttribute.getAll();
            while (nameAttributeAllEnum.hasMore()) {
                String roleNameCandidate = (String)nameAttributeAllEnum.next();
                logger.info((Object)("roleNameCandidate:" + roleNameCandidate));
                name = roleNameCandidate;
            }
            String displayName = name;
            Attribute displayNameAttribute = attributes.get(roleDisplayNameAttribute);
            if (displayNameAttribute != null) {
                logger.info((Object)("attribute:" + displayNameAttribute.toString()));
                NamingEnumeration<?> displayNameAttributeAllEnum = displayNameAttribute.getAll();
                while (displayNameAttributeAllEnum.hasMore()) {
                    String displayNameCandidate = (String)displayNameAttributeAllEnum.next();
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    displayName = displayNameCandidate;
                }
            }
            String description = "Not available from JNDI-source";
            logger.info((Object)("descriptionAttribute:" + roleDescriptionAttribute));
            Attribute descriptionAttribute = attributes.get(roleDescriptionAttribute);
            if (descriptionAttribute != null) {
                logger.info((Object)("descriptionAttribute:" + descriptionAttribute.toString()));
                NamingEnumeration<?> descriptionAllEnum = descriptionAttribute.getAll();
                while (descriptionAllEnum.hasMore()) {
                    String descriptionCandidate = (String)descriptionAllEnum.next();
                    logger.info((Object)("descriptionCandidate:" + descriptionCandidate));
                    description = descriptionCandidate;
                }
            }
            if ((infoglueRole = new InfoGlueRole(roleName, displayName, description, this)) != null) {
                CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infoglueRole, null, false);
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
            logger.info((Object)("Could not find Role: " + e.getMessage()));
        }
        return infoglueRole;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = null;
        DirContext ctx = this.getContext();
        try {
            group = this.getAuthorizedInfoGlueGroup(groupName, ctx);
        }
        finally {
            ctx.close();
        }
        return group;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName, DirContext ctx) throws Exception {
        String userCacheTimeout = this.extraProperties.getProperty("groupCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        String key = "group_" + groupName + "_" + authorizerIndex;
        InfoGlueGroup infoglueGroup = null;
        Object infoglueGroupObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(userCacheTimeout));
        if (infoglueGroupObject != null) {
            if (infoglueGroupObject instanceof NullObject) {
                return null;
            }
            infoglueGroup = (InfoGlueGroup)infoglueGroupObject;
            return infoglueGroup;
        }
        logger.info((Object)"\n\n\n ---------- getAuthorizedInfoGlueGroup starting ---------\n\n\n");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute", "distinguishedName");
        String groupDisplayNameAttribute = this.extraProperties.getProperty("groupDisplayNameAttribute", "cn");
        String groupDescriptionAttribute = this.extraProperties.getProperty("groupDescriptionAttribute", "description");
        try {
            logger.info((Object)("groupNameAttribute:" + groupNameAttribute));
            logger.info((Object)("groupDisplayNameAttribute:" + groupDisplayNameAttribute));
            logger.info((Object)("groupDescriptionAttribute:" + groupDescriptionAttribute));
            Attributes attributes = ctx.getAttributes(groupName);
            logger.info((Object)("attributes:" + attributes.toString()));
            String name = null;
            Attribute nameAttribute = attributes.get(groupNameAttribute);
            logger.info((Object)("nameAttribute:" + nameAttribute.toString()));
            NamingEnumeration<?> nameAttributeAllEnum = nameAttribute.getAll();
            while (nameAttributeAllEnum.hasMore()) {
                String groupNameCandidate = (String)nameAttributeAllEnum.next();
                logger.info((Object)("groupNameCandidate:" + groupNameCandidate));
                name = groupNameCandidate;
            }
            String displayName = name;
            Attribute displayNameAttribute = attributes.get(groupDisplayNameAttribute);
            logger.info((Object)("attribute:" + displayNameAttribute));
            if (displayNameAttribute != null) {
                NamingEnumeration<?> displayNameAttributeAllEnum = displayNameAttribute.getAll();
                while (displayNameAttributeAllEnum.hasMore()) {
                    String displayNameCandidate = (String)displayNameAttributeAllEnum.next();
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    displayName = displayNameCandidate;
                }
            }
            String description = "Not available from JNDI-source";
            logger.info((Object)("descriptionAttribute:" + groupDescriptionAttribute));
            Attribute descriptionAttribute = attributes.get(groupDescriptionAttribute);
            logger.info((Object)("descriptionAttribute:" + descriptionAttribute));
            if (displayNameAttribute != null) {
                NamingEnumeration<?> descriptionAllEnum = descriptionAttribute.getAll();
                while (descriptionAllEnum.hasMore()) {
                    String descriptionCandidate = (String)descriptionAllEnum.next();
                    logger.info((Object)("descriptionCandidate:" + descriptionCandidate));
                    description = descriptionCandidate;
                }
            }
            if ((infoglueGroup = new InfoGlueGroup(name, displayName, description, this)) != null) {
                CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infoglueGroup, null, false);
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
            logger.info((Object)("Could not find Group: " + e.getMessage()));
        }
        return infoglueGroup;
    }

    public List authorizeUser(String userName) throws Exception {
        return this.getRoles(userName);
    }

    protected Map getUserAttributes(String userName) throws NamingException, Exception {
        Map attributes = null;
        DirContext ctx = this.getContext();
        try {
            attributes = this.getUserAttributes(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return attributes;
    }

    protected Map getUserAttributes(String userName, DirContext ctx) throws NamingException, Exception {
        logger.info((Object)("userName:" + userName));
        logger.info((Object)("userName:" + userName));
        HashMap<String, String> userAttributes = new HashMap<String, String>();
        String userAttributesFilter = this.extraProperties.getProperty("userAttributesFilter", "cn, distinguishedName");
        String userDisplayNameFilter = this.extraProperties.getProperty("displayNameFilter", "displayName");
        String userNameAttributeFilter = this.extraProperties.getProperty("userNameAttributeFilter", "distinguishedName");
        String userFirstNameAttributeFilter = this.extraProperties.getProperty("userFirstNameAttributeFilter", "givenName");
        String userLastNameAttributeFilter = this.extraProperties.getProperty("userLastNameAttributeFilter", "sn");
        String userMailAttributeFilter = this.extraProperties.getProperty("userMailAttributeFilter", "mail");
        try {
            Attributes attributes = ctx.getAttributes(userName);
            logger.info((Object)("attributes:" + attributes.toString()));
            if (attributes == null) {
                throw new SystemException("No user attributes found for user:" + userName);
            }
            Attribute userNameAttribute = attributes.get(userNameAttributeFilter);
            Attribute userDisplayNameAttribute = attributes.get(userDisplayNameFilter);
            Attribute userFirstNameAttribute = attributes.get(userFirstNameAttributeFilter);
            Attribute userLastNameAttribute = attributes.get(userLastNameAttributeFilter);
            Attribute userMailAttribute = attributes.get(userMailAttributeFilter);
            if (logger.isInfoEnabled()) {
                logger.info((Object)("userNameAttribute:" + userNameAttribute));
                logger.info((Object)("userDisplayNameAttribute:" + userDisplayNameAttribute));
                logger.info((Object)("userFirstNameAttribute:" + userFirstNameAttribute));
                logger.info((Object)("userLastNameAttribute:" + userLastNameAttribute));
                logger.info((Object)("userMailAttribute:" + userMailAttribute));
            }
            userAttributes.put("displayName", userDisplayNameAttribute == null ? userName : userDisplayNameAttribute.get().toString());
            userAttributes.put("firstName", userFirstNameAttribute == null ? "Unknown" : userFirstNameAttribute.get().toString());
            userAttributes.put("lastName", userLastNameAttribute == null ? "Unknown" : userLastNameAttribute.get().toString());
            userAttributes.put("mail", userMailAttribute == null ? "Unknown" : userMailAttribute.get().toString());
            if (logger.isInfoEnabled()) {
                logger.info((Object)("userAttributesFilter:" + userAttributesFilter));
            }
            String[] attrID = userAttributesFilter.split(",");
            int i = 0;
            while (i < attrID.length) {
                String attributeName = attrID[i];
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("attributeName:" + attributeName));
                }
                if (!(attributeName.equals(userNameAttributeFilter) || attributeName.equals(userNameAttributeFilter) || attributeName.equals(userNameAttributeFilter) || attributeName.equals(userNameAttributeFilter) || attributeName.equals(userNameAttributeFilter))) {
                    Attribute value = attributes.get(attributeName);
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("value:" + value));
                    }
                    userAttributes.put(attributeName, value == null ? "Unknown" : value.get().toString());
                }
                ++i;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e);
            e.printStackTrace();
            throw e;
        }
        return userAttributes;
    }

    protected List getRoles(String userName) throws NamingException, Exception {
        List roles = null;
        DirContext ctx = this.getContext();
        try {
            roles = this.getRoles(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return roles;
    }

    protected List getRoles(String userName, DirContext ctx) throws NamingException, Exception {
        logger.info((Object)"**************************************************");
        logger.info((Object)"*In JNDI version\t\t\t\t\t\t\t\t *");
        logger.info((Object)"**************************************************");
        logger.info((Object)("userName:" + userName));
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        List allRoles = this.getRoles(ctx);
        String memberOfAttribute = this.extraProperties.getProperty("memberOfAttributeFilter");
        String roleFilter = this.extraProperties.getProperty("roleFilter", "InfoGlue");
        try {
            String[] memberOfAttributes;
            Attributes attributes;
            String memberOfAttributeFilter = "memberOf";
            if (memberOfAttribute != null && memberOfAttribute.length() > 0) {
                memberOfAttributeFilter = memberOfAttribute;
            }
            if ((attributes = ctx.getAttributes(userName, memberOfAttributes = (memberOfAttributeFilter = memberOfAttributeFilter.toLowerCase().trim()).split(","))) == null) {
                throw new SystemException("No user attributes found for user:" + userName);
            }
            NamingEnumeration<? extends Attribute> allEnum = attributes.getAll();
            while (allEnum.hasMore()) {
                Attribute attr = allEnum.next();
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    InfoGlueRole infoGlueRole;
                    String fullRoleName;
                    Object roleNameObject = e.next();
                    logger.info((Object)("roleNameObject:" + roleNameObject));
                    String roleName = fullRoleName = roleNameObject.toString().trim();
                    logger.info((Object)("roleName:" + fullRoleName));
                    if (!roleFilter.equalsIgnoreCase("*") && roleName.indexOf(roleFilter) <= -1 || !allRoles.contains(infoGlueRole = this.getAuthorizedInfoGlueRole(roleName, ctx))) continue;
                    logger.info((Object)("Adding role.................:" + fullRoleName));
                    roles.add(infoGlueRole);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not find Group for empID: " + userName + e));
            e.printStackTrace();
            throw e;
        }
        return roles;
    }

    protected List getGroups(String userName) throws NamingException, Exception {
        List groups = null;
        DirContext ctx = this.getContext();
        try {
            groups = this.getGroups(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return groups;
    }

    protected List getGroups(String userName, DirContext ctx) throws NamingException, Exception {
        logger.info((Object)"**************************************************");
        logger.info((Object)"*In JNDI version\t\t\t\t\t\t\t\t  *");
        logger.info((Object)"**************************************************");
        logger.info((Object)("userName:" + userName));
        ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
        List allGroups = this.getGroups(ctx);
        String memberOfAttribute = this.extraProperties.getProperty("memberOfAttributeFilter");
        String groupFilter = this.extraProperties.getProperty("groupFilter", "InfoGlue");
        try {
            String[] memberOfAttributes;
            Attributes attributes;
            String memberOfAttributeFilter = "memberOf";
            if (memberOfAttribute != null && memberOfAttribute.length() > 0) {
                memberOfAttributeFilter = memberOfAttribute;
            }
            if ((attributes = ctx.getAttributes(userName, memberOfAttributes = (memberOfAttributeFilter = memberOfAttributeFilter.toLowerCase().trim()).split(","))) == null) {
                throw new SystemException("No user attributes found for user:" + userName);
            }
            NamingEnumeration<? extends Attribute> allEnum = attributes.getAll();
            while (allEnum.hasMore()) {
                Attribute attr = allEnum.next();
                NamingEnumeration<?> e = attr.getAll();
                while (e.hasMore()) {
                    InfoGlueGroup infoGlueGroup;
                    String fullGroupName;
                    Object groupNameObject = e.next();
                    logger.info((Object)("groupNameObject:" + groupNameObject));
                    String groupName = fullGroupName = groupNameObject.toString().trim();
                    logger.info((Object)("groupName:" + fullGroupName));
                    if (!groupFilter.equalsIgnoreCase("*") && groupName.indexOf(groupFilter) <= -1 || !allGroups.contains(infoGlueGroup = this.getAuthorizedInfoGlueGroup(groupName, ctx))) continue;
                    logger.info((Object)("Adding group.................:" + fullGroupName));
                    groups.add(infoGlueGroup);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not find Group for empID: " + userName + e));
            e.printStackTrace();
            throw e;
        }
        return groups;
    }

    public List getRoles() throws Exception {
        List roles = null;
        DirContext ctx = this.getContext();
        try {
            roles = this.getRoles(ctx);
        }
        finally {
            ctx.close();
        }
        return roles;
    }

    /*
     * Unable to fully structure code
     */
    public List getRoles(DirContext ctx) throws Exception {
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"getRoles start....");
        roleCacheTimeout = this.extraProperties.getProperty("roleCacheTimeout", "1800");
        authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((roles = (ArrayList<InfoGlueRole>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allRoles" + authorizerIndex, new Integer(roleCacheTimeout))) != null) {
            return roles;
        }
        roles = new ArrayList<InfoGlueRole>();
        roleBase = this.extraProperties.getProperty("roleBase");
        roleBases = null;
        if (roleBase != null) {
            roleBases = roleBase.split(";");
        }
        rolesFilter = this.extraProperties.getProperty("rolesFilter");
        rolesAttributeFilter = this.extraProperties.getProperty("rolesAttributesFilter");
        roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        roleDisplayNameAttribute = this.extraProperties.getProperty("roleDisplayNameAttribute", "cn");
        roleSearchScope = this.extraProperties.getProperty("roleSearchScope");
        roleBaseIndex = 0;
        while (roleBaseIndex < roleBases.length) {
            baseDN = roleBases[roleBaseIndex];
            if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Searching for roles in " + baseDN + " - roles was " + roles.size()));
            }
            try {
                searchFilter = "(cn=InfoGlue*)";
                if (rolesFilter != null && rolesFilter.length() > 0) {
                    searchFilter = rolesFilter;
                }
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN));
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleSearchScope:" + roleSearchScope));
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("rolesAttributeFilter:" + rolesAttributeFilter));
                }
                rolesAttribute = "distinguishedName";
                if (rolesAttributeFilter != null && rolesAttributeFilter.length() > 0) {
                    rolesAttribute = rolesAttributeFilter;
                }
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("rolesAttribute:" + rolesAttribute));
                }
                attrID = rolesAttribute.split(",");
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attrID:" + attrID));
                }
                ctls = new SearchControls();
                roleSearchScopeInt = 2;
                if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                    roleSearchScopeInt = 1;
                } else if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                    roleSearchScopeInt = 0;
                }
                ctls.setSearchScope(roleSearchScopeInt);
                ctls.setReturningAttributes(attrID);
                answer = ctx.search(baseDN, searchFilter, ctls);
                if (answer.hasMore()) ** GOTO lbl77
                throw new Exception("There was no roles found in the JNDI Data Source.");
lbl-1000:
                // 1 sources

                {
                    sr = answer.next();
                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Group:" + sr.toString() + "\n"));
                    }
                    attributes = sr.getAttributes();
                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attributes:" + attributes.toString()));
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                    }
                    attribute = attributes.get(roleNameAttribute);
                    roleName = "";
                    allEnum = attribute.getAll();
                    while (allEnum.hasMore()) {
                        roleName = (String)allEnum.next();
                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleName:" + roleName));
                    }
                    displayName = roleName;
                    displayNameAttribute = attributes.get(roleDisplayNameAttribute);
                    if (displayNameAttribute != null) {
                        allEnumDisplayName = displayNameAttribute.getAll();
                        while (allEnumDisplayName.hasMore()) {
                            displayName = (String)allEnumDisplayName.next();
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("displayName:" + displayName));
                        }
                    }
                    infoGlueRole = new InfoGlueRole(roleName, displayName, "Not available from JNDI-source", this);
                    roles.add(infoGlueRole);
lbl77:
                    // 2 sources

                    ** while (answer.hasMore())
                }
lbl78:
                // 1 sources

                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"-----------------------\n");
            }
            catch (Exception e) {
                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Could not find Roles: " + e.getMessage()));
            }
            ++roleBaseIndex;
        }
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"getRoles end....");
        if (roles != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, roles, null, false);
        }
        return roles;
    }

    /*
     * Unable to fully structure code
     */
    public List getUsers() throws Exception {
        t = new Timer();
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"*******************");
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"* getUsers start  *");
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"*******************");
        userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
        authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((users = (ArrayList<InfoGluePrincipal>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allUsers" + authorizerIndex, new Integer(userCacheTimeout))) != null) {
            return users;
        }
        users = new ArrayList<InfoGluePrincipal>();
        userBase = this.extraProperties.getProperty("userBase");
        userBases = null;
        if (userBase != null) {
            userBases = userBase.split(";");
        }
        userListSearch = this.extraProperties.getProperty("userListSearch");
        userAttributesFilter = this.extraProperties.getProperty("userAttributesFilter");
        userNameAttributeFilter = this.extraProperties.getProperty("userNameAttributeFilter", "distinguishedName");
        userDisplayNameAttributeFilter = this.extraProperties.getProperty("userDisplayNameAttributeFilter", "cn");
        userFirstNameAttributeFilter = this.extraProperties.getProperty("userFirstNameAttributeFilter", "givenName");
        userLastNameAttributeFilter = this.extraProperties.getProperty("userLastNameAttributeFilter", "sn");
        userMailAttributeFilter = this.extraProperties.getProperty("userMailAttributeFilter", "mail");
        memberOfAttributeFilter = this.extraProperties.getProperty("memberOfAttributeFilter", "memberOf");
        roleFilter = this.extraProperties.getProperty("roleFilter", "InfoGlue");
        roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        userSearchScope = this.extraProperties.getProperty("userSearchScope");
        userFirstNameDummy = this.extraProperties.getProperty("userFirstNameDummy");
        userLastNameDummy = this.extraProperties.getProperty("userLastNameDummy");
        userDisplayNameDummy = this.extraProperties.getProperty("userDisplayNameDummy");
        userMailDummy = this.extraProperties.getProperty("userMailDummy");
        t.printElapsedTime("Got context took:");
        index = 0;
        userBaseIndex = 0;
        while (userBaseIndex < userBases.length) {
            block52: {
                baseDN = userBases[userBaseIndex];
                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Searching for users in " + baseDN + " - users was " + users.size()));
                }
                ctx = this.getContext();
                try {
                    try {
                        searchFilter = "(CN=*)";
                        if (userListSearch != null && userListSearch.length() > 0) {
                            searchFilter = userListSearch;
                        }
                        attributesFilter = "name, displayName, givenName, sn, mail, memberOf";
                        if (userAttributesFilter != null && userAttributesFilter.length() > 0) {
                            attributesFilter = userAttributesFilter;
                        }
                        attrID = attributesFilter.split(",");
                        userMailAttributeFilterAttributeId = userMailAttributeFilter.split(",");
                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attributesFilter:" + attributesFilter));
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userMailAttributeFilterAttributeId:" + userMailAttributeFilterAttributeId));
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN));
                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
                        }
                        ctls = new SearchControls();
                        userSearchScopeInt = 2;
                        if (userSearchScope != null && userSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                            userSearchScopeInt = 1;
                        } else if (userSearchScope != null && userSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                            userSearchScopeInt = 0;
                        }
                        ctls.setSearchScope(userSearchScopeInt);
                        ctls.setReturningAttributes(attrID);
                        answer = ctx.search(baseDN, searchFilter, ctls);
                        t.printElapsedTime("Answer took:");
                        if (answer.hasMore()) ** GOTO lbl167
                        throw new Exception("The was no users found in the JNDI Data Source.");
lbl-1000:
                        // 1 sources

                        {
                            try {
                                sr = answer.next();
                                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("Person:" + sr.toString() + "\n"));
                                }
                                attributes = sr.getAttributes();
                                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("attributes:" + attributes.toString()));
                                }
                                userNameAttribute = attributes.get(userNameAttributeFilter);
                                userDisplayNameAttribute = attributes.get(userDisplayNameAttributeFilter);
                                userFirstNameAttribute = attributes.get(userFirstNameAttributeFilter);
                                userLastNameAttribute = attributes.get(userLastNameAttributeFilter);
                                userMailAttribute = null;
                                i = 0;
                                while (i < userMailAttributeFilterAttributeId.length) {
                                    userMailAttribute = attributes.get(userMailAttributeFilterAttributeId[i]);
                                    if (userMailAttribute != null) break;
                                    ++i;
                                }
                                memberOfAttribute = attributes.get(memberOfAttributeFilter);
                                memberOfGroupsAttribute = attributes.get(memberOfAttributeFilter);
                                userFirstName = null;
                                if (userFirstNameAttribute != null) {
                                    userFirstName = userFirstNameAttribute.get().toString();
                                } else if (userFirstNameDummy != null && !userFirstNameDummy.equals("")) {
                                    userFirstName = userFirstNameDummy;
                                }
                                userLastName = null;
                                if (userLastNameAttribute != null) {
                                    userLastName = userLastNameAttribute.get().toString();
                                } else if (userLastNameDummy != null && !userLastNameDummy.equals("")) {
                                    userLastName = userLastNameDummy;
                                }
                                userDisplayName = null;
                                if (userDisplayNameAttribute != null) {
                                    userDisplayName = userDisplayNameAttribute.get().toString();
                                } else if (userDisplayNameDummy != null && !userDisplayNameDummy.equals("")) {
                                    userDisplayName = userDisplayNameDummy;
                                }
                                userMail = null;
                                if (userMailAttribute != null) {
                                    userMail = userMailAttribute.get().toString();
                                } else if (userMailDummy != null && !userMailDummy.equals("")) {
                                    userMail = userMailDummy;
                                }
                                if (userFirstName == null || userLastName == null || userDisplayName == null || userMail == null) {
                                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("User not valid " + userNameAttribute));
                                    }
                                    throw new SystemException("The user " + userNameAttribute + " did not have firstName, lastName or email attribute which InfoGlue requires");
                                }
                                if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userNameAttribute:" + userNameAttribute));
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userDisplayName:" + userDisplayName));
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userFirstName:" + userFirstName));
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userLastName:" + userLastName));
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("userMail:" + userMail));
                                }
                                roles = new ArrayList<InfoGlueRole>();
                                groups = new ArrayList<InfoGlueGroup>();
                                if (memberOfAttribute != null) {
                                    if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("memberOfAttribute:" + memberOfAttribute));
                                    }
                                    allEnum = memberOfAttribute.getAll();
                                    while (allEnum.hasMore()) {
                                        roleName = (String)allEnum.next();
                                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleName:" + roleName));
                                        }
                                        if (!roleFilter.equalsIgnoreCase("*") && roleName.indexOf(roleFilter) <= -1) continue;
                                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + roleName));
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("indexOf:" + roleName.indexOf(roleNameAttribute)));
                                        }
                                        infoGlueRole = this.getAuthorizedInfoGlueRole(roleName, ctx);
                                        roles.add(infoGlueRole);
                                    }
                                } else if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("No memberOfAttribute named :" + memberOfAttributeFilter + " was found."));
                                }
                                if (memberOfGroupsAttribute != null) {
                                    allGroupsEnum = memberOfGroupsAttribute.getAll();
                                    while (allGroupsEnum.hasMore()) {
                                        groupName = (String)allGroupsEnum.next();
                                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + groupName));
                                        }
                                        if (!roleFilter.equalsIgnoreCase("*") && groupName.indexOf(roleFilter) <= -1) continue;
                                        if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + groupName));
                                            SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("indexOf:" + groupName.indexOf(roleNameAttribute)));
                                        }
                                        infoGlueGroup = this.getAuthorizedInfoGlueGroup(groupName, ctx);
                                        groups.add(infoGlueGroup);
                                    }
                                } else if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                                    SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("No memberOfGroupsAttribute named :" + memberOfAttributeFilter + " was found."));
                                }
                                infoGluePrincipal = new InfoGluePrincipal(userNameAttribute.get().toString(), userDisplayName, userFirstName, userLastName, userMail, roles, groups, false, (AuthorizationModule)this);
                                users.add(infoGluePrincipal);
                                continue;
                            }
                            catch (Exception e) {
                                SimplifiedJNDIBasicAuthorizationModule.logger.warn((Object)("An error occurred when we tried to read user: " + e.getMessage()), (Throwable)e);
                            }
lbl167:
                            // 3 sources

                            ** while (answer.hasMore())
                        }
lbl168:
                        // 1 sources

                    }
                    catch (Exception e) {
                        SimplifiedJNDIBasicAuthorizationModule.logger.warn((Object)("Could not find Users: " + e.getMessage()), (Throwable)e);
                        ctx.close();
                        break block52;
                    }
                }
                catch (Throwable var52_55) {
                    ctx.close();
                    throw var52_55;
                }
                ctx.close();
            }
            if (SimplifiedJNDIBasicAuthorizationModule.logger.isInfoEnabled()) {
                SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)("After searching for users in " + baseDN + " - users was " + users.size()));
            }
            ++userBaseIndex;
        }
        t.printElapsedTime("all users took " + index + ":");
        SimplifiedJNDIBasicAuthorizationModule.logger.info((Object)"getUsers end...");
        if (users != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, users, null, false);
        }
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws SystemException, Bug {
        ArrayList users = new ArrayList();
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        List users = null;
        DirContext ctx = this.getContext();
        try {
            users = this.getRoleUsers(roleName, ctx);
        }
        finally {
            ctx.close();
        }
        return users;
    }

    public List getRoleUsers(String roleName, DirContext ctx) throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute", "distinguishedName");
        String roleDisplayNameAttribute = this.extraProperties.getProperty("roleDisplayNameAttribute", "cn");
        String roleDescriptionAttribute = this.extraProperties.getProperty("roleDescriptionAttribute", "description");
        String usersAttributeFilter = this.extraProperties.getProperty("usersAttributesFilter");
        try {
            logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
            logger.info((Object)("roleDisplayNameAttribute:" + roleDisplayNameAttribute));
            logger.info((Object)("roleDescriptionAttribute:" + roleDescriptionAttribute));
            logger.info((Object)("Getting users with role:" + roleName));
            Attributes attributes = ctx.getAttributes(roleName);
            logger.info((Object)("attributes:" + attributes.toString()));
            String name = null;
            Attribute nameAttribute = attributes.get(roleNameAttribute);
            logger.info((Object)("nameAttribute:" + nameAttribute.toString()));
            NamingEnumeration<?> nameAttributeAllEnum = nameAttribute.getAll();
            while (nameAttributeAllEnum.hasMore()) {
                String roleNameCandidate = (String)nameAttributeAllEnum.next();
                logger.info((Object)("roleNameCandidate:" + roleNameCandidate));
                name = roleNameCandidate;
            }
            String displayName = name;
            logger.info((Object)("roleDisplayNameAttribute:" + roleDisplayNameAttribute));
            Attribute displayNameAttribute = attributes.get(roleDisplayNameAttribute);
            logger.info((Object)("attribute:" + displayNameAttribute));
            if (displayNameAttribute != null) {
                logger.info((Object)("attribute:" + displayNameAttribute.toString()));
                NamingEnumeration<?> displayNameAttributeAllEnum = displayNameAttribute.getAll();
                while (displayNameAttributeAllEnum.hasMore()) {
                    String displayNameCandidate = (String)displayNameAttributeAllEnum.next();
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    displayName = displayNameCandidate;
                }
            }
            String description = "Not available from JNDI-source";
            logger.info((Object)("descriptionAttribute:" + roleDescriptionAttribute));
            Attribute descriptionAttribute = attributes.get(roleDescriptionAttribute);
            logger.info((Object)("descriptionAttribute:" + descriptionAttribute));
            if (displayNameAttribute != null) {
                NamingEnumeration<?> descriptionAllEnum = descriptionAttribute.getAll();
                while (descriptionAllEnum.hasMore()) {
                    String descriptionCandidate = (String)descriptionAllEnum.next();
                    logger.info((Object)("descriptionCandidate:" + descriptionCandidate));
                    description = descriptionCandidate;
                }
            }
            logger.info((Object)("usersAttributeFilter:" + usersAttributeFilter));
            Attribute usersAttribute = attributes.get(usersAttributeFilter);
            logger.info((Object)("usersAttribute:" + usersAttribute));
            NamingEnumeration<?> allUsersEnum = usersAttribute.getAll();
            while (allUsersEnum.hasMore()) {
                String userName = (String)allUsersEnum.next();
                logger.info((Object)("userName:" + userName));
                logger.info((Object)("userName:" + userName));
                InfoGluePrincipal infoGluePrincipal = this.getAuthorizedInfoGluePrincipal(userName, false, ctx);
                logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal));
                users.add(infoGluePrincipal);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Could not find users for role: " + e.getMessage()));
        }
        logger.info((Object)"--------------------END---------------------");
        return users;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public void setTransactionObject(Object transactionObject) {
    }

    public Object getTransactionObject() {
        return null;
    }

    public List getGroups() throws Exception {
        List groups = null;
        DirContext ctx = this.getContext();
        try {
            groups = this.getGroups(ctx);
        }
        finally {
            ctx.close();
        }
        return groups;
    }

    public List getGroups(DirContext ctx) throws Exception {
        String key;
        ArrayList<InfoGlueGroup> groups;
        logger.info((Object)"getGroups start....");
        String groupCacheTimeout = this.extraProperties.getProperty("groupCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((groups = (ArrayList<InfoGlueGroup>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allGroups" + authorizerIndex, new Integer(groupCacheTimeout))) != null) {
            return groups;
        }
        groups = new ArrayList<InfoGlueGroup>();
        String groupBase = this.extraProperties.getProperty("groupBase");
        String[] groupBases = null;
        if (groupBase != null) {
            groupBases = groupBase.split(";");
        }
        String groupsFilter = this.extraProperties.getProperty("groupsFilter");
        String groupsAttributeFilter = this.extraProperties.getProperty("groupsAttributesFilter");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute");
        String groupDisplayNameAttribute = this.extraProperties.getProperty("groupDisplayNameAttribute", "cn");
        String groupSearchScope = this.extraProperties.getProperty("groupSearchScope");
        int groupBaseIndex = 0;
        while (groupBaseIndex < groupBases.length) {
            String baseDN = groupBases[groupBaseIndex];
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Searching for groups in " + baseDN + " - groups was " + groups.size()));
            }
            try {
                String searchFilter = "(cn=InfoGlue*)";
                if (groupsFilter != null && groupsFilter.length() > 0) {
                    searchFilter = groupsFilter;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("searchFilter:" + searchFilter));
                    logger.info((Object)("groupSearchScope:" + groupSearchScope));
                }
                String groupsAttribute = "distinguishedName";
                if (groupsAttributeFilter != null && groupsAttributeFilter.length() > 0) {
                    groupsAttribute = groupsAttributeFilter;
                }
                String[] attrID = groupsAttribute.split(",");
                logger.info((Object)("attrID:" + attrID));
                SearchControls ctls = new SearchControls();
                int groupSearchScopeInt = 2;
                if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                    groupSearchScopeInt = 1;
                } else if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                    groupSearchScopeInt = 0;
                }
                ctls.setSearchScope(groupSearchScopeInt);
                ctls.setReturningAttributes(attrID);
                NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
                if (!answer.hasMore()) {
                    throw new Exception("The was no groups found in the JNDI Data Source.");
                }
                logger.info((Object)"-----------------------\n");
                while (answer.hasMore()) {
                    SearchResult sr = answer.next();
                    Attributes attributes = sr.getAttributes();
                    Attribute attribute = attributes.get(groupNameAttribute);
                    String groupName = "";
                    NamingEnumeration<?> allEnum = attribute.getAll();
                    while (allEnum.hasMore()) {
                        groupName = (String)allEnum.next();
                        logger.info((Object)("groupName:" + groupName));
                    }
                    Attribute displayNameAttribute = attributes.get(groupDisplayNameAttribute);
                    String displayName = groupName;
                    if (displayNameAttribute != null) {
                        NamingEnumeration<?> allEnumDisplayName = displayNameAttribute.getAll();
                        while (allEnumDisplayName.hasMore()) {
                            displayName = (String)allEnumDisplayName.next();
                        }
                    }
                    InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupName, displayName, "Not available from JNDI-source", this);
                    groups.add(infoGlueGroup);
                }
                logger.info((Object)"-----------------------\n");
            }
            catch (Exception e) {
                logger.info((Object)("Could not find Groups: " + e.getMessage()));
            }
            ++groupBaseIndex;
        }
        logger.info((Object)"getGroups end....");
        if (groups != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, groups, null, false);
        }
        return groups;
    }

    public List getGroupUsers(String groupName) throws Exception {
        List users = null;
        DirContext ctx = this.getContext();
        try {
            users = this.getGroupUsers(groupName, ctx);
        }
        finally {
            ctx.close();
        }
        return users;
    }

    public List getGroupUsers(String groupName, DirContext ctx) throws Exception {
        logger.info((Object)"--------getGroupUsers(String groupName) start---------------");
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute", "distinguishedName");
        String groupDisplayNameAttribute = this.extraProperties.getProperty("groupDisplayNameAttribute", "cn");
        String groupDescriptionAttribute = this.extraProperties.getProperty("groupDescriptionAttribute", "description");
        String usersAttributeFilter = this.extraProperties.getProperty("usersAttributesFilter");
        try {
            Attributes attributes = ctx.getAttributes(groupName);
            logger.info((Object)("attributes:" + attributes.toString()));
            String name = null;
            Attribute nameAttribute = attributes.get(groupNameAttribute);
            logger.info((Object)("nameAttribute:" + nameAttribute.toString()));
            NamingEnumeration<?> nameAttributeAllEnum = nameAttribute.getAll();
            while (nameAttributeAllEnum.hasMore()) {
                String groupNameCandidate = (String)nameAttributeAllEnum.next();
                logger.info((Object)("groupNameCandidate:" + groupNameCandidate));
                name = groupNameCandidate;
            }
            String displayName = name;
            logger.info((Object)("groupDisplayNameAttribute:" + groupDisplayNameAttribute));
            Attribute displayNameAttribute = attributes.get(groupDisplayNameAttribute);
            logger.info((Object)("attribute:" + displayNameAttribute));
            if (displayNameAttribute != null) {
                NamingEnumeration<?> displayNameAttributeAllEnum = displayNameAttribute.getAll();
                while (displayNameAttributeAllEnum.hasMore()) {
                    String displayNameCandidate = (String)displayNameAttributeAllEnum.next();
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    logger.info((Object)("displayNameCandidate:" + displayNameCandidate));
                    displayName = displayNameCandidate;
                }
            }
            String description = "Not available from JNDI-source";
            logger.info((Object)("descriptionAttribute:" + groupDescriptionAttribute));
            Attribute descriptionAttribute = attributes.get(groupDescriptionAttribute);
            logger.info((Object)("descriptionAttribute:" + descriptionAttribute));
            if (displayNameAttribute != null) {
                NamingEnumeration<?> descriptionAllEnum = descriptionAttribute.getAll();
                while (descriptionAllEnum.hasMore()) {
                    String descriptionCandidate = (String)descriptionAllEnum.next();
                    logger.info((Object)("descriptionCandidate:" + descriptionCandidate));
                    description = descriptionCandidate;
                }
            }
            logger.info((Object)("usersAttributeFilter:" + usersAttributeFilter));
            Attribute usersAttribute = attributes.get(usersAttributeFilter);
            logger.info((Object)("usersAttribute:" + usersAttribute));
            NamingEnumeration<?> allUsersEnum = usersAttribute.getAll();
            while (allUsersEnum.hasMore()) {
                String userName = (String)allUsersEnum.next();
                logger.info((Object)("userName:" + userName));
                InfoGluePrincipal infoGluePrincipal = this.getAuthorizedInfoGluePrincipal(userName, false, ctx);
                logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal));
                users.add(infoGluePrincipal);
            }
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Groups: " + e.getMessage()));
        }
        logger.info((Object)"--------------------END---------------------");
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of users yet...");
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of user password yet....");
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of user password yet...");
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of users yet...");
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of roles yet...");
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of groups yet...");
    }

    public void updateInfoGlueGroup(GroupVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of groups yet...");
    }
}

