/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import org.apache.log4j.Logger;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.Bug;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.NullObject;

public class JNDIBasicAuthorizationModule
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)JNDIBasicAuthorizationModule.class.getName());
    protected Properties extraProperties = null;

    public boolean getSupportUpdate() {
        return false;
    }

    public boolean getSupportDelete() {
        return false;
    }

    public boolean getSupportCreate() {
        return false;
    }

    public DirContext getContext() throws Exception {
        String connectionURL = this.extraProperties.getProperty("connectionURL");
        String ldapVersion = this.extraProperties.getProperty("ldapVersion");
        String socketFactory = this.extraProperties.getProperty("socketFactory");
        String authenticationMethod = this.extraProperties.getProperty("authenticationMethod");
        String connectionName = this.extraProperties.getProperty("connectionName");
        String connectionPassword = this.extraProperties.getProperty("connectionPassword");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionURL);
        if (ldapVersion != null && !ldapVersion.equals("3")) {
            env.put("java.naming.ldap.version", ldapVersion);
        } else {
            env.put("java.naming.ldap.version", "3");
        }
        if (socketFactory != null && !socketFactory.equals("")) {
            env.put("java.naming.ldap.factory.socket", "org.infoglue.cms.security.DummySSLSocketFactory");
        }
        if (authenticationMethod != null && authenticationMethod.equals("none")) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", connectionName);
            env.put("java.naming.security.credentials", connectionPassword);
        }
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        InitialDirContext ctx = new InitialDirContext(env);
        return ctx;
    }

    public DirContext getContext(Control[] controls) throws Exception {
        String connectionURL = this.extraProperties.getProperty("connectionURL");
        String ldapVersion = this.extraProperties.getProperty("ldapVersion");
        String socketFactory = this.extraProperties.getProperty("socketFactory");
        String authenticationMethod = this.extraProperties.getProperty("authenticationMethod");
        String connectionName = this.extraProperties.getProperty("connectionName");
        String connectionPassword = this.extraProperties.getProperty("connectionPassword");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionURL);
        if (ldapVersion != null && !ldapVersion.equals("3")) {
            env.put("java.naming.ldap.version", ldapVersion);
        } else {
            env.put("java.naming.ldap.version", "3");
        }
        if (socketFactory != null && !socketFactory.equals("")) {
            env.put("java.naming.ldap.factory.socket", "org.infoglue.cms.security.DummySSLSocketFactory");
        }
        if (authenticationMethod != null && authenticationMethod.equals("none")) {
            env.put("java.naming.security.authentication", "none");
        } else {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", connectionName);
            env.put("java.naming.security.credentials", connectionPassword);
        }
        env.put("com.sun.jndi.ldap.connect.pool", "true");
        InitialLdapContext ctx = new InitialLdapContext(env, controls);
        return ctx;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        boolean isAdministrator;
        String userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        String key = "user_" + userName + authorizerIndex;
        InfoGluePrincipal infogluePrincipal = null;
        Object infogluePrincipalObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(userCacheTimeout));
        if (infogluePrincipalObject != null) {
            if (infogluePrincipalObject instanceof NullObject) {
                return null;
            }
            infogluePrincipal = (InfoGluePrincipal)infogluePrincipalObject;
            return infogluePrincipal;
        }
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            DirContext ctx = this.getContext();
            try {
                try {
                    Map userAttributes = this.getUserAttributes(userName, ctx);
                    List roles = this.getRoles(userName, ctx);
                    List groups = this.getGroups(userName, ctx);
                    infogluePrincipal = new InfoGluePrincipal(userName, (String)userAttributes.get("firstName"), (String)userAttributes.get("lastName"), (String)userAttributes.get("mail"), roles, groups, isAdministrator, this);
                    if (infogluePrincipal != null) {
                        CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infogluePrincipal, null, false);
                    }
                }
                catch (Exception e) {
                    CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
                    ctx.close();
                }
            }
            finally {
                ctx.close();
            }
        }
        return infogluePrincipal;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName, DirContext ctx) throws Exception {
        boolean isAdministrator;
        String userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        String key = "user_" + userName + authorizerIndex;
        InfoGluePrincipal infogluePrincipal = null;
        Object infogluePrincipalObject = CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key, new Integer(userCacheTimeout));
        if (infogluePrincipalObject != null) {
            if (infogluePrincipalObject instanceof NullObject) {
                return null;
            }
            infogluePrincipal = (InfoGluePrincipal)infogluePrincipalObject;
            return infogluePrincipal;
        }
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            try {
                Map userAttributes = this.getUserAttributes(userName, ctx);
                List roles = this.getRoles(userName, ctx);
                List groups = this.getGroups(userName, ctx);
                infogluePrincipal = new InfoGluePrincipal(userName, (String)userAttributes.get("firstName"), (String)userAttributes.get("lastName"), (String)userAttributes.get("mail"), roles, groups, isAdministrator, this);
                if (infogluePrincipal != null) {
                    CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, infogluePrincipal, null, false);
                }
            }
            catch (Exception e) {
                CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, new NullObject(), null, false);
            }
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole role = null;
        DirContext ctx = this.getContext();
        try {
            role = this.getAuthorizedInfoGlueRole(roleName, ctx);
        }
        finally {
            ctx.close();
        }
        return role;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName, DirContext ctx) throws Exception {
        logger.info((Object)"\n\n\n ---------- getAuthorizedInfoGlueRole starting ---------\n\n\n");
        InfoGlueRole infoglueRole = null;
        String roleBase = this.extraProperties.getProperty("roleBase").toLowerCase().trim();
        String rolesFilter = this.extraProperties.getProperty("rolesFilter");
        String rolesAttributeFilter = this.extraProperties.getProperty("rolesAttributesFilter");
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        String roleSearchScope = this.extraProperties.getProperty("roleSearchScope");
        try {
            logger.info((Object)"Connected...");
            String baseDN = roleBase;
            String searchFilter = "(cn=" + roleName + ")";
            if (roleName.indexOf("cn=") > -1) {
                searchFilter = "(" + roleName + ")";
            }
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("roleSearchScope:" + roleSearchScope));
            String rolesAttribute = "distinguishedName";
            if (rolesAttributeFilter != null && rolesAttributeFilter.length() > 0) {
                rolesAttribute = rolesAttributeFilter;
            }
            String[] attrID = rolesAttribute.split(",");
            logger.info((Object)("attrID:" + attrID));
            SearchControls ctls = new SearchControls();
            int roleSearchScopeInt = 2;
            if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                roleSearchScopeInt = 1;
            } else if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                roleSearchScopeInt = 0;
            }
            ctls.setSearchScope(roleSearchScopeInt);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The was no groups found in the JNDI Data Source.");
            }
            logger.info((Object)"-----------------------\n");
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Role:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                Attribute attribute = attributes.get(roleNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String roleNameCandidate = (String)allEnum.next();
                    logger.info((Object)("roleNameCandidate:" + roleNameCandidate));
                    infoglueRole = new InfoGlueRole(roleNameCandidate, "Not available from JNDI-source", this);
                }
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Role: " + e.getMessage()));
        }
        return infoglueRole;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup group = null;
        DirContext ctx = this.getContext();
        try {
            group = this.getAuthorizedInfoGlueGroup(groupName, ctx);
        }
        finally {
            ctx.close();
        }
        return group;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName, DirContext ctx) throws Exception {
        logger.info((Object)"\n\n\n ---------- getAuthorizedInfoGlueGroup starting ---------\n\n\n");
        InfoGlueGroup infoglueGroup = null;
        String groupBase = this.extraProperties.getProperty("groupBase").toLowerCase().trim();
        String groupsFilter = this.extraProperties.getProperty("groupsFilter");
        String groupsAttributeFilter = this.extraProperties.getProperty("groupsAttributesFilter");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute");
        String groupSearchScope = this.extraProperties.getProperty("groupSearchScope");
        try {
            logger.info((Object)"Connected...");
            String baseDN = groupBase;
            String searchFilter = "(cn=" + groupName + ")";
            if (groupName.indexOf("cn=") > -1) {
                searchFilter = "(" + groupName + ")";
            }
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("baseDN:" + baseDN));
            logger.info((Object)("groupSearchScope:" + groupSearchScope));
            String groupsAttribute = "distinguishedName";
            if (groupsAttributeFilter != null && groupsAttributeFilter.length() > 0) {
                groupsAttribute = groupsAttributeFilter;
            }
            String[] attrID = groupsAttribute.split(",");
            logger.info((Object)("attrID:" + attrID));
            SearchControls ctls = new SearchControls();
            int groupSearchScopeInt = 2;
            if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                groupSearchScopeInt = 1;
            } else if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                groupSearchScopeInt = 0;
            }
            ctls.setSearchScope(groupSearchScopeInt);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The was no groups found in the JNDI Data Source.");
            }
            logger.info((Object)"-----------------------\n");
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Group:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("groupNameAttribute:" + groupNameAttribute));
                Attribute attribute = attributes.get(groupNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String groupNameCandidate = (String)allEnum.next();
                    logger.info((Object)("groupNameCandidate:" + groupNameCandidate));
                    infoglueGroup = new InfoGlueGroup(groupNameCandidate, "Not available from JNDI-source", this);
                }
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Group: " + e.getMessage()));
        }
        return infoglueGroup;
    }

    public List authorizeUser(String userName) throws Exception {
        return this.getRoles(userName);
    }

    protected Map getUserAttributes(String userName) throws NamingException, Exception {
        Map attributes = null;
        DirContext ctx = this.getContext();
        try {
            attributes = this.getUserAttributes(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return attributes;
    }

    /*
     * Unable to fully structure code
     */
    protected Map getUserAttributes(String userName, DirContext ctx) throws NamingException, Exception {
        JNDIBasicAuthorizationModule.logger.info((Object)("userName:" + userName));
        userAttributes = new HashMap<String, String>();
        roleBase = this.extraProperties.getProperty("roleBase");
        userBase = this.extraProperties.getProperty("userBase");
        userSearch = this.extraProperties.getProperty("userSearch");
        userAttributesFilter = this.extraProperties.getProperty("userAttributesFilter");
        userNameAttributeFilter = this.extraProperties.getProperty("userNameAttributeFilter", "name");
        userFirstNameAttributeFilter = this.extraProperties.getProperty("userFirstNameAttributeFilter", "givenName");
        userLastNameAttributeFilter = this.extraProperties.getProperty("userLastNameAttributeFilter", "sn");
        userMailAttributeFilter = this.extraProperties.getProperty("userMailAttributeFilter", "mail");
        memberOfAttributeFilter = this.extraProperties.getProperty("memberOfAttributeFilter", "memberOf");
        roleFilter = this.extraProperties.getProperty("roleFilter", "InfoGlue");
        try {
            baseDN = userBase;
            anonymousUserName = CmsPropertyHandler.getAnonymousUser();
            if (userName.equals(anonymousUserName) && (anonymousUserBase = this.extraProperties.getProperty("anonymousUserBase")) != null && !anonymousUserBase.equals("")) {
                baseDN = anonymousUserBase;
            }
            searchFilter = "(CN=" + userName + ")";
            if (userSearch != null && userSearch.length() > 0) {
                searchFilter = userSearch.replaceAll("\\{1\\}", userName);
            }
            if (searchFilter.indexOf(",") > -1) {
                searchFilter = searchFilter.substring(1, searchFilter.indexOf(","));
            }
            attributesFilter = "name, givenName, sn, mail, memberOf";
            if (userAttributesFilter != null && userAttributesFilter.length() > 0) {
                attributesFilter = userAttributesFilter;
            }
            attrID = attributesFilter.split(",");
            userMailAttributeFilterAttributeId = userMailAttributeFilter.split(",");
            JNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN));
            JNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
            JNDIBasicAuthorizationModule.logger.info((Object)("attrID" + attrID));
            ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(attrID);
            answer = ctx.search(baseDN, searchFilter, ctls);
            if (answer.hasMore()) ** GOTO lbl78
            throw new Exception("The user with userName=" + userName + " was not found in the JNDI Data Source.");
lbl-1000:
            // 1 sources

            {
                sr = answer.next();
                JNDIBasicAuthorizationModule.logger.info((Object)("Person:" + sr.toString() + "\n"));
                attributes = sr.getAttributes();
                JNDIBasicAuthorizationModule.logger.info((Object)("attributes:" + attributes + "\n"));
                i = 0;
                while (i < attrID.length) {
                    JNDIBasicAuthorizationModule.logger.info((Object)("attrID[i]:" + attrID[i]));
                    attribute = attributes.get(attrID[i]);
                    if (attribute == null && !attrID[i].equals("mail")) {
                        throw new Exception("The attribute " + attrID[i] + " was not found among the user attributes. [" + attributes + "]");
                    }
                    if (attribute != null) {
                        JNDIBasicAuthorizationModule.logger.info((Object)("attribute:" + attribute.toString()));
                        allEnum = attribute.getAll();
                        while (allEnum.hasMore()) {
                            value = (String)allEnum.next();
                            JNDIBasicAuthorizationModule.logger.info((Object)("value:" + value));
                            userAttributes.put(attrID[i], value);
                        }
                    }
                    ++i;
                }
                userNameAttribute = attributes.get(userNameAttributeFilter);
                JNDIBasicAuthorizationModule.logger.info((Object)("userNameAttribute:" + userNameAttribute.toString()));
                userFirstNameAttribute = attributes.get(userFirstNameAttributeFilter);
                JNDIBasicAuthorizationModule.logger.info((Object)("userFirstNameAttribute:" + userFirstNameAttribute.toString()));
                userLastNameAttribute = attributes.get(userLastNameAttributeFilter);
                JNDIBasicAuthorizationModule.logger.info((Object)("userLastNameAttribute:" + userLastNameAttribute.toString()));
                userMailAttribute = null;
                i = 0;
                while (i < userMailAttributeFilterAttributeId.length) {
                    userMailAttribute = attributes.get(userMailAttributeFilterAttributeId[i]);
                    if (userMailAttribute != null) break;
                    ++i;
                }
                JNDIBasicAuthorizationModule.logger.info((Object)("userMailAttribute:" + userMailAttribute.toString()));
                userAttributes.put("firstName", userFirstNameAttribute.get().toString());
                userAttributes.put("lastName", userLastNameAttribute.get().toString());
                userAttributes.put("mail", userMailAttribute.get().toString());
lbl78:
                // 2 sources

                ** while (answer.hasMore())
            }
lbl79:
            // 1 sources

        }
        catch (Exception e) {
            JNDIBasicAuthorizationModule.logger.warn((Object)e);
            throw e;
        }
        return userAttributes;
    }

    protected List getRoles(String userName) throws NamingException, Exception {
        List roles = null;
        DirContext ctx = this.getContext();
        try {
            roles = this.getRoles(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return roles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getRoles(String userName, DirContext ctx) throws NamingException, Exception {
        logger.info((Object)"**************************************************");
        logger.info((Object)"*In JNDI version\t\t\t\t\t\t\t\t *");
        logger.info((Object)"**************************************************");
        logger.info((Object)("userName:" + userName));
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        List allRoles = this.getRoles(ctx);
        String roleBase = this.extraProperties.getProperty("roleBase").toLowerCase().trim();
        String userBase = this.extraProperties.getProperty("userBase").toLowerCase().trim();
        String userSearch = this.extraProperties.getProperty("userSearch");
        String memberOfAttribute = this.extraProperties.getProperty("memberOfAttributeFilter");
        String rolesAttributeFilter = this.extraProperties.getProperty("rolesAttributesFilter");
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        String roleFilter = this.extraProperties.getProperty("roleFilter", "InfoGlue");
        String removeRoleBaseDN = this.extraProperties.getProperty("removeRoleBaseDN", "true");
        try {
            String baseDN = userBase;
            String anonymousUserName = CmsPropertyHandler.getAnonymousUser();
            if (userName.equals(anonymousUserName)) {
                baseDN = this.extraProperties.getProperty("anonymousUserBase");
            }
            String searchFilter = "(CN=" + userName + ")";
            if (userSearch != null && userSearch.length() > 0) {
                searchFilter = userSearch.replaceAll("\\{1\\}", userName);
            }
            searchFilter = searchFilter.toLowerCase().trim();
            String memberOfAttributeFilter = "memberOf";
            if (memberOfAttribute != null && memberOfAttribute.length() > 0) {
                memberOfAttributeFilter = memberOfAttribute;
            }
            memberOfAttributeFilter = memberOfAttributeFilter.toLowerCase().trim();
            String[] attrID = memberOfAttributeFilter.split(",");
            String rolesAttribute = "distinguishedName";
            if (rolesAttributeFilter != null && rolesAttributeFilter.length() > 0) {
                rolesAttribute = rolesAttributeFilter;
            }
            rolesAttribute = rolesAttribute.toLowerCase().trim();
            logger.info((Object)("baseDN:" + baseDN));
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("attrID" + attrID));
            logger.info((Object)("roleBase:" + roleBase));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The user with userName=" + userName + " was not found in the JNDI Data Source.");
            }
            block2: while (true) {
                if (!answer.hasMore()) {
                    return roles;
                }
                SearchResult sr = answer.next();
                logger.info((Object)("Person:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                Attribute attribute = attributes.get(memberOfAttributeFilter);
                logger.info((Object)("..................attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (true) {
                    InfoGlueRole infoGlueRole;
                    String fullRoleName;
                    if (!allEnum.hasMore()) continue block2;
                    Object roleNameObject = allEnum.next();
                    String roleName = fullRoleName = roleNameObject.toString().toLowerCase().trim();
                    logger.info((Object)("roleName:" + fullRoleName));
                    logger.info((Object)("indexOf:" + fullRoleName.indexOf(roleBase)));
                    if (roleBase == null || fullRoleName.indexOf(roleBase) <= -1 || !removeRoleBaseDN.equals("true")) continue;
                    roleName = roleName.substring(0, roleName.indexOf(roleBase));
                    roleName = roleName.substring(0, roleName.lastIndexOf(","));
                    logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                    logger.info((Object)("roleName:" + roleName));
                    logger.info((Object)("indexOf:" + roleName.indexOf(roleNameAttribute)));
                    if (roleNameAttribute != null && roleName.indexOf(roleNameAttribute) > -1) {
                        roleName = roleName.substring(roleName.indexOf(roleNameAttribute) + roleNameAttribute.length() + 1);
                    }
                    logger.info((Object)"*****************************");
                    logger.info((Object)("roleName:" + roleName));
                    logger.info((Object)("roleBase:" + roleBase));
                    logger.info((Object)"*****************************");
                    if (!roleFilter.equalsIgnoreCase("*") && roleName.indexOf(roleFilter) <= -1 || !allRoles.contains(infoGlueRole = this.getAuthorizedInfoGlueRole(roleName, ctx))) continue;
                    logger.info((Object)("Adding role.................:" + fullRoleName));
                    roles.add(infoGlueRole);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not find Group for empID: " + userName + e));
            throw e;
        }
    }

    protected List getGroups(String userName) throws NamingException, Exception {
        List groups = null;
        DirContext ctx = this.getContext();
        try {
            groups = this.getGroups(userName, ctx);
        }
        finally {
            ctx.close();
        }
        return groups;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getGroups(String userName, DirContext ctx) throws NamingException, Exception {
        logger.info((Object)"**************************************************");
        logger.info((Object)"*In JNDI version\t\t\t\t\t\t\t\t  *");
        logger.info((Object)"**************************************************");
        logger.info((Object)("userName:" + userName));
        ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
        List allGroups = this.getGroups(ctx);
        String groupBase = this.extraProperties.getProperty("groupBase").toLowerCase().trim();
        String userBase = this.extraProperties.getProperty("userBase").toLowerCase().trim();
        String userSearch = this.extraProperties.getProperty("userSearch");
        String memberOfAttribute = this.extraProperties.getProperty("memberOfAttributeFilter");
        String groupsAttributeFilter = this.extraProperties.getProperty("groupsAttributesFilter");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute");
        String groupFilter = this.extraProperties.getProperty("groupFilter", "InfoGlue");
        String removeGroupBaseDN = this.extraProperties.getProperty("removeGroupBaseDN", "true");
        logger.info((Object)("groupBase:" + groupBase));
        logger.info((Object)("userBase:" + userBase));
        try {
            String baseDN = userBase;
            String anonymousUserName = CmsPropertyHandler.getAnonymousUser();
            if (userName.equals(anonymousUserName)) {
                baseDN = this.extraProperties.getProperty("anonymousUserBase");
            }
            String searchFilter = "(CN=" + userName + ")";
            if (userSearch != null && userSearch.length() > 0) {
                searchFilter = userSearch.replaceAll("\\{1\\}", userName);
            }
            String memberOfAttributeFilter = "memberOf";
            if (memberOfAttribute != null && memberOfAttribute.length() > 0) {
                memberOfAttributeFilter = memberOfAttribute;
            }
            memberOfAttributeFilter = memberOfAttributeFilter.toLowerCase().trim();
            String[] attrID = memberOfAttributeFilter.split(",");
            String groupsAttribute = "distinguishedName";
            if (groupsAttributeFilter != null && groupsAttributeFilter.length() > 0) {
                groupsAttribute = groupsAttributeFilter;
            }
            groupsAttribute = groupsAttribute.toLowerCase().trim();
            logger.info((Object)("baseDN:" + baseDN));
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("attrID" + attrID));
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The user with userName=" + userName + " was not found in the JNDI Data Source.");
            }
            block2: while (true) {
                if (!answer.hasMore()) {
                    return groups;
                }
                SearchResult sr = answer.next();
                logger.info((Object)("Person:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                Attribute attribute = attributes.get(memberOfAttributeFilter);
                logger.info((Object)("..................attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (true) {
                    InfoGlueGroup infoGlueGroup;
                    String fullGroupName;
                    if (!allEnum.hasMore()) continue block2;
                    Object groupNameObject = allEnum.next();
                    String groupName = fullGroupName = groupNameObject.toString().toLowerCase().trim();
                    logger.info((Object)("groupName:" + groupName));
                    logger.info((Object)("groupBase:" + groupBase));
                    logger.info((Object)("indexOf:" + groupName.indexOf(groupBase)));
                    if (groupBase == null || fullGroupName.indexOf(groupBase) <= -1 || !removeGroupBaseDN.equals("true")) continue;
                    groupName = groupName.substring(0, groupName.indexOf(groupBase));
                    groupName = groupName.substring(0, groupName.lastIndexOf(","));
                    logger.info((Object)("groupNameAttribute:" + groupNameAttribute));
                    logger.info((Object)("groupName:" + groupName));
                    logger.info((Object)("indexOf:" + groupName.indexOf(groupNameAttribute)));
                    if (groupNameAttribute != null && groupName.indexOf(groupNameAttribute) > -1) {
                        groupName = groupName.substring(groupName.indexOf(groupNameAttribute) + groupNameAttribute.length() + 1);
                    }
                    logger.info((Object)("groupName:" + groupName));
                    if (!groupFilter.equalsIgnoreCase("*") && groupName.indexOf(groupFilter) <= -1 || !allGroups.contains(infoGlueGroup = this.getAuthorizedInfoGlueGroup(groupName, ctx))) continue;
                    logger.info((Object)("Adding group.................:" + groupName));
                    groups.add(infoGlueGroup);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Group for empID: " + userName + e));
            throw e;
        }
    }

    public List getRoles() throws Exception {
        List roles = null;
        DirContext ctx = this.getContext();
        try {
            roles = this.getRoles(ctx);
        }
        finally {
            ctx.close();
        }
        return roles;
    }

    public List getRoles(DirContext ctx) throws Exception {
        String key;
        ArrayList<InfoGlueRole> roles;
        logger.info((Object)"getRoles start....");
        String roleCacheTimeout = this.extraProperties.getProperty("roleCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((roles = (ArrayList<InfoGlueRole>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allRoles" + authorizerIndex, new Integer(roleCacheTimeout))) != null) {
            return roles;
        }
        roles = new ArrayList<InfoGlueRole>();
        String roleBase = this.extraProperties.getProperty("roleBase");
        String rolesFilter = this.extraProperties.getProperty("rolesFilter");
        String rolesAttributeFilter = this.extraProperties.getProperty("rolesAttributesFilter");
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        String roleSearchScope = this.extraProperties.getProperty("roleSearchScope");
        try {
            logger.info((Object)"Connected...");
            String baseDN = roleBase;
            String searchFilter = "(cn=InfoGlue*)";
            if (rolesFilter != null && rolesFilter.length() > 0) {
                searchFilter = rolesFilter;
            }
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("roleSearchScope:" + roleSearchScope));
            logger.info((Object)("rolesAttributeFilter:" + rolesAttributeFilter));
            String rolesAttribute = "distinguishedName";
            if (rolesAttributeFilter != null && rolesAttributeFilter.length() > 0) {
                rolesAttribute = rolesAttributeFilter;
            }
            String[] attrID = rolesAttribute.split(",");
            logger.info((Object)("attrID:" + attrID));
            SearchControls ctls = new SearchControls();
            int roleSearchScopeInt = 2;
            if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                roleSearchScopeInt = 1;
            } else if (roleSearchScope != null && roleSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                roleSearchScopeInt = 0;
            }
            ctls.setSearchScope(roleSearchScopeInt);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The was no groups found in the JNDI Data Source.");
            }
            logger.info((Object)"-----------------------\n");
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Group:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                Attribute attribute = attributes.get(roleNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String groupName = (String)allEnum.next();
                    logger.info((Object)("groupName:" + groupName));
                    InfoGlueRole infoGlueRole = new InfoGlueRole(groupName, "Not available from JNDI-source", this);
                    roles.add(infoGlueRole);
                }
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Roles: " + e.getMessage()));
        }
        logger.info((Object)"getRoles end....");
        if (roles != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, roles, null, false);
        }
        return roles;
    }

    /*
     * Unable to fully structure code
     */
    public List getUsers() throws Exception {
        block28: {
            JNDIBasicAuthorizationModule.logger.info((Object)"*******************");
            JNDIBasicAuthorizationModule.logger.info((Object)"* getUsers start  *");
            JNDIBasicAuthorizationModule.logger.info((Object)"*******************");
            userCacheTimeout = this.extraProperties.getProperty("userCacheTimeout", "1800");
            authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
            if (authorizerIndex == null) {
                authorizerIndex = "";
            }
            if ((users = (ArrayList<InfoGluePrincipal>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allUsers" + authorizerIndex, new Integer(userCacheTimeout))) != null) {
                return users;
            }
            users = new ArrayList<InfoGluePrincipal>();
            roleBase = this.extraProperties.getProperty("roleBase");
            groupBase = this.extraProperties.getProperty("groupBase");
            userBase = this.extraProperties.getProperty("userBase");
            userListSearch = this.extraProperties.getProperty("userListSearch");
            userAttributesFilter = this.extraProperties.getProperty("userAttributesFilter");
            userNameAttributeFilter = this.extraProperties.getProperty("userNameAttributeFilter", "name");
            userFirstNameAttributeFilter = this.extraProperties.getProperty("userFirstNameAttributeFilter", "givenName");
            userLastNameAttributeFilter = this.extraProperties.getProperty("userLastNameAttributeFilter", "sn");
            userMailAttributeFilter = this.extraProperties.getProperty("userMailAttributeFilter", "mail");
            memberOfAttributeFilter = this.extraProperties.getProperty("memberOfAttributeFilter", "memberOf");
            roleFilter = this.extraProperties.getProperty("roleFilter", "InfoGlue");
            roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
            userSearchScope = this.extraProperties.getProperty("userSearchScope");
            removeGroupBaseDN = this.extraProperties.getProperty("removeGroupBaseDN", "true");
            removeRoleBaseDN = this.extraProperties.getProperty("removeRoleBaseDN", "true");
            ctx = this.getContext();
            try {
                try {
                    baseDN = userBase;
                    searchFilter = "(CN=*)";
                    if (userListSearch != null && userListSearch.length() > 0) {
                        searchFilter = userListSearch;
                    }
                    attributesFilter = "name, givenName, sn, mail, memberOf";
                    if (userAttributesFilter != null && userAttributesFilter.length() > 0) {
                        attributesFilter = userAttributesFilter;
                    }
                    attrID = attributesFilter.split(",");
                    userMailAttributeFilterAttributeId = userMailAttributeFilter.split(",");
                    JNDIBasicAuthorizationModule.logger.info((Object)("attributesFilter:" + attributesFilter));
                    JNDIBasicAuthorizationModule.logger.info((Object)("userMailAttributeFilterAttributeId:" + userMailAttributeFilterAttributeId));
                    JNDIBasicAuthorizationModule.logger.info((Object)("baseDN:" + baseDN));
                    JNDIBasicAuthorizationModule.logger.info((Object)("searchFilter:" + searchFilter));
                    ctls = new SearchControls();
                    userSearchScopeInt = 2;
                    if (userSearchScope != null && userSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                        userSearchScopeInt = 1;
                    } else if (userSearchScope != null && userSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                        userSearchScopeInt = 0;
                    }
                    ctls.setSearchScope(userSearchScopeInt);
                    ctls.setReturningAttributes(attrID);
                    answer = ctx.search(baseDN, searchFilter, ctls);
                    if (answer.hasMore()) ** GOTO lbl130
                    throw new Exception("The was no users found in the JNDI Data Source.");
lbl-1000:
                    // 1 sources

                    {
                        try {
                            sr = answer.next();
                            JNDIBasicAuthorizationModule.logger.info((Object)("Person:" + sr.toString() + "\n"));
                            attributes = sr.getAttributes();
                            JNDIBasicAuthorizationModule.logger.info((Object)("attributes:" + attributes.toString()));
                            userNameAttribute = attributes.get(userNameAttributeFilter);
                            userFirstNameAttribute = attributes.get(userFirstNameAttributeFilter);
                            userLastNameAttribute = attributes.get(userLastNameAttributeFilter);
                            userMailAttribute = null;
                            i = 0;
                            while (i < userMailAttributeFilterAttributeId.length) {
                                userMailAttribute = attributes.get(userMailAttributeFilterAttributeId[i]);
                                if (userMailAttribute != null) break;
                                ++i;
                            }
                            memberOfAttribute = attributes.get(memberOfAttributeFilter);
                            memberOfGroupsAttribute = attributes.get(memberOfAttributeFilter);
                            if (userFirstNameAttribute == null || userLastNameAttribute == null || userMailAttribute == null) {
                                throw new SystemException("The user " + userNameAttribute + " did not have firstName, lastName or email attribute which InfoGlue requires");
                            }
                            JNDIBasicAuthorizationModule.logger.info((Object)("userNameAttribute:" + userNameAttribute.toString()));
                            JNDIBasicAuthorizationModule.logger.info((Object)("userFirstNameAttribute:" + userFirstNameAttribute.toString()));
                            JNDIBasicAuthorizationModule.logger.info((Object)("userLastNameAttribute:" + userLastNameAttribute.toString()));
                            JNDIBasicAuthorizationModule.logger.info((Object)("userMailAttribute:" + userMailAttribute.toString()));
                            roles = new ArrayList<InfoGlueRole>();
                            groups = new ArrayList<InfoGlueGroup>();
                            if (memberOfAttribute != null) {
                                JNDIBasicAuthorizationModule.logger.info((Object)("memberOfAttribute:" + memberOfAttribute.toString()));
                                allEnum = memberOfAttribute.getAll();
                                while (allEnum.hasMore()) {
                                    roleName = (String)allEnum.next();
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + roleName));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("roleBase:" + roleBase));
                                    if (roleBase != null && roleName.indexOf(roleBase) > -1 && removeRoleBaseDN.equals("true")) {
                                        roleName = roleName.substring(0, roleName.indexOf(roleBase));
                                        roleName = roleName.substring(0, roleName.lastIndexOf(","));
                                    }
                                    JNDIBasicAuthorizationModule.logger.info((Object)("roleName:" + roleName));
                                    if (!roleFilter.equalsIgnoreCase("*") && roleName.indexOf(roleFilter) <= -1) continue;
                                    JNDIBasicAuthorizationModule.logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + roleName));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("indexOf:" + roleName.indexOf(roleNameAttribute)));
                                    if (roleNameAttribute != null && roleName.indexOf(roleNameAttribute) > -1) {
                                        roleName = roleName.substring(roleName.indexOf(roleNameAttribute) + roleNameAttribute.length() + 1);
                                    }
                                    infoGlueRole = new InfoGlueRole(roleName, "Not available from JNDI-source", this);
                                    roles.add(infoGlueRole);
                                }
                            } else {
                                JNDIBasicAuthorizationModule.logger.info((Object)("No memberOfAttribute named :" + memberOfAttributeFilter + " was found."));
                            }
                            if (memberOfGroupsAttribute != null) {
                                allGroupsEnum = memberOfGroupsAttribute.getAll();
                                while (allGroupsEnum.hasMore()) {
                                    groupName = (String)allGroupsEnum.next();
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + groupName));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupBase:" + groupBase));
                                    if (groupBase != null && groupName.indexOf(groupBase) > -1 && removeGroupBaseDN.equals("true")) {
                                        groupName = groupName.substring(0, groupName.indexOf(groupBase));
                                        groupName = groupName.substring(0, groupName.lastIndexOf(","));
                                    }
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + groupName));
                                    if (!roleFilter.equalsIgnoreCase("*") && groupName.indexOf(roleFilter) <= -1) continue;
                                    JNDIBasicAuthorizationModule.logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("groupName:" + groupName));
                                    JNDIBasicAuthorizationModule.logger.info((Object)("indexOf:" + groupName.indexOf(roleNameAttribute)));
                                    if (roleNameAttribute != null && groupName.indexOf(roleNameAttribute) > -1) {
                                        groupName = groupName.substring(groupName.indexOf(roleNameAttribute) + roleNameAttribute.length() + 1);
                                    }
                                    infoGlueGroup = new InfoGlueGroup(groupName, "Not available from JNDI-source", this);
                                    groups.add(infoGlueGroup);
                                }
                            } else {
                                JNDIBasicAuthorizationModule.logger.info((Object)("No memberOfGroupsAttribute named :" + memberOfAttributeFilter + " was found."));
                            }
                            infoGluePrincipal = new InfoGluePrincipal(userNameAttribute.get().toString(), userFirstNameAttribute.get().toString(), userLastNameAttribute.get().toString(), userMailAttribute.get().toString(), roles, groups, false, this);
                            users.add(infoGluePrincipal);
                            continue;
                        }
                        catch (Exception e) {
                            JNDIBasicAuthorizationModule.logger.warn((Object)("An error occurred when we tried to read user: " + e.getMessage()), (Throwable)e);
                        }
lbl130:
                        // 3 sources

                        ** while (answer.hasMore())
                    }
lbl131:
                    // 1 sources

                }
                catch (Exception e) {
                    JNDIBasicAuthorizationModule.logger.warn((Object)("Could not find Groups: " + e.getMessage()), (Throwable)e);
                    ctx.close();
                    break block28;
                }
            }
            catch (Throwable var42_45) {
                ctx.close();
                throw var42_45;
            }
            ctx.close();
        }
        JNDIBasicAuthorizationModule.logger.info((Object)"getUsers end...");
        if (users != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, users, null, false);
        }
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws SystemException, Bug {
        ArrayList users = new ArrayList();
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        List users = null;
        DirContext ctx = this.getContext();
        try {
            users = this.getRoleUsers(roleName, ctx);
        }
        finally {
            ctx.close();
        }
        return users;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getRoleUsers(String roleName, DirContext ctx) throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        String roleBase = this.extraProperties.getProperty("roleBase").toLowerCase().trim();
        String rolesFilter = this.extraProperties.getProperty("rolesFilter");
        String rolesAttributeFilter = this.extraProperties.getProperty("rolesAttributesFilter");
        String roleNameAttribute = this.extraProperties.getProperty("roleNameAttribute");
        String usersAttributeFilter = this.extraProperties.getProperty("usersAttributesFilter");
        String userNameAttribute = this.extraProperties.getProperty("userNameAttributeFilter");
        String userBase = this.extraProperties.getProperty("userBase").toLowerCase().trim();
        String removeUserBaseDN = this.extraProperties.getProperty("removeUserBaseDN", "true");
        try {
            logger.info((Object)("Getting users with role:" + roleName));
            String baseDN = roleBase;
            String searchFilter = "(cn=" + roleName + ")";
            if (roleName.indexOf("cn=") > -1) {
                searchFilter = "(" + roleName + ")";
            }
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("baseDN:" + baseDN));
            String rolesAttribute = "distinguishedName";
            if (rolesAttributeFilter != null && rolesAttributeFilter.length() > 0) {
                rolesAttribute = rolesAttributeFilter;
            }
            String[] attrID = rolesAttribute.split(",");
            logger.info((Object)"Before search...");
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            logger.info((Object)"After search...");
            if (!answer.hasMore()) {
                throw new Exception("The was no roles found in the JNDI Data Source.");
            }
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Role:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("roleNameAttribute:" + roleNameAttribute));
                Attribute attribute = attributes.get(roleNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String roleNameCandidate = (String)allEnum.next();
                    logger.info((Object)("roleNameCandidate:" + roleNameCandidate + "=" + roleName));
                    if (!roleNameCandidate.equalsIgnoreCase(roleName)) continue;
                    logger.info((Object)("usersAttributeFilter:" + usersAttributeFilter));
                    Attribute usersAttribute = attributes.get(usersAttributeFilter);
                    logger.info((Object)("usersAttribute:" + usersAttribute));
                    NamingEnumeration<?> allUsersEnum = usersAttribute.getAll();
                    while (allUsersEnum.hasMore()) {
                        String userName = (String)allUsersEnum.next();
                        logger.info((Object)("userName:" + userName));
                        logger.info((Object)("userBase:" + userBase));
                        if (roleBase != null && userName.indexOf(userBase) > -1 && removeUserBaseDN.equals("true")) {
                            userName = userName.substring(0, userName.indexOf(userBase));
                            userName = userName.substring(0, userName.lastIndexOf(","));
                        }
                        logger.info((Object)("userNameAttribute:" + userNameAttribute));
                        logger.info((Object)("userName:" + userName));
                        logger.info((Object)("indexOf:" + userName.indexOf(userNameAttribute)));
                        if (roleNameAttribute != null && userName.indexOf(userNameAttribute) > -1) {
                            userName = userName.substring(userName.indexOf(userNameAttribute) + userNameAttribute.length() + 1);
                        }
                        if (userName.indexOf("cn=") > -1) {
                            userName = userName.substring(userName.indexOf("cn=") + 3);
                        }
                        InfoGluePrincipal infoGluePrincipal = this.getAuthorizedInfoGluePrincipal(userName, ctx);
                        users.add(infoGluePrincipal);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)("Could not find users for role: " + e.getMessage()));
        }
        logger.info((Object)"--------------------END---------------------");
        return users;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties properties) {
        this.extraProperties = properties;
    }

    public void setTransactionObject(Object transactionObject) {
    }

    public Object getTransactionObject() {
        return null;
    }

    public List getGroups() throws Exception {
        List groups = null;
        DirContext ctx = this.getContext();
        try {
            groups = this.getGroups(ctx);
        }
        finally {
            ctx.close();
        }
        return groups;
    }

    public List getGroups(DirContext ctx) throws Exception {
        String key;
        ArrayList<InfoGlueGroup> groups;
        logger.info((Object)"getGroups start....");
        String groupCacheTimeout = this.extraProperties.getProperty("groupCacheTimeout", "1800");
        String authorizerIndex = this.extraProperties.getProperty("authorizerIndex");
        if (authorizerIndex == null) {
            authorizerIndex = "";
        }
        if ((groups = (ArrayList<InfoGlueGroup>)CacheController.getCachedObjectFromAdvancedCache("JNDIAuthorizationCache", key = "allGroups" + authorizerIndex, new Integer(groupCacheTimeout))) != null) {
            return groups;
        }
        groups = new ArrayList<InfoGlueGroup>();
        String groupBase = this.extraProperties.getProperty("groupBase");
        String groupsFilter = this.extraProperties.getProperty("groupsFilter");
        String groupsAttributeFilter = this.extraProperties.getProperty("groupsAttributesFilter");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute");
        String groupSearchScope = this.extraProperties.getProperty("groupSearchScope");
        try {
            String baseDN = groupBase;
            String searchFilter = "(cn=InfoGlue*)";
            if (groupsFilter != null && groupsFilter.length() > 0) {
                searchFilter = groupsFilter;
            }
            logger.info((Object)("searchFilter:" + searchFilter));
            logger.info((Object)("groupSearchScope:" + groupSearchScope));
            String groupsAttribute = "distinguishedName";
            if (groupsAttributeFilter != null && groupsAttributeFilter.length() > 0) {
                groupsAttribute = groupsAttributeFilter;
            }
            String[] attrID = groupsAttribute.split(",");
            logger.info((Object)("attrID:" + attrID));
            SearchControls ctls = new SearchControls();
            int groupSearchScopeInt = 2;
            if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("ONELEVEL_SCOPE")) {
                groupSearchScopeInt = 1;
            } else if (groupSearchScope != null && groupSearchScope.equalsIgnoreCase("OBJECT_SCOPE")) {
                groupSearchScopeInt = 0;
            }
            ctls.setSearchScope(groupSearchScopeInt);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The was no groups found in the JNDI Data Source.");
            }
            logger.info((Object)"-----------------------\n");
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Group:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("groupNameAttribute:" + groupNameAttribute));
                Attribute attribute = attributes.get(groupNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String groupName = (String)allEnum.next();
                    logger.info((Object)("groupName:" + groupName));
                    InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupName, "Not available from JNDI-source", this);
                    groups.add(infoGlueGroup);
                }
            }
            logger.info((Object)"-----------------------\n");
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Groups: " + e.getMessage()));
        }
        logger.info((Object)"getRoles end....");
        if (groups != null) {
            CacheController.cacheObjectInAdvancedCache("JNDIAuthorizationCache", key, groups, null, false);
        }
        return groups;
    }

    public List getGroupUsers(String groupName) throws Exception {
        List users = null;
        DirContext ctx = this.getContext();
        try {
            users = this.getGroupUsers(groupName, ctx);
        }
        finally {
            ctx.close();
        }
        return users;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getGroupUsers(String groupName, DirContext ctx) throws Exception {
        logger.info((Object)"--------getGroupUsers(String groupName) start---------------");
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        String groupBase = this.extraProperties.getProperty("groupBase");
        String groupsFilter = this.extraProperties.getProperty("groupsFilter");
        String groupsAttributeFilter = this.extraProperties.getProperty("groupsAttributesFilter");
        String groupNameAttribute = this.extraProperties.getProperty("groupNameAttribute");
        String usersAttributeFilter = this.extraProperties.getProperty("usersAttributesFilter");
        String userNameAttribute = this.extraProperties.getProperty("userNameAttributeFilter");
        String userBase = this.extraProperties.getProperty("userBase");
        String removeUserBaseDN = this.extraProperties.getProperty("removeUserBaseDN", "true");
        try {
            String baseDN = groupBase;
            String searchFilter = "(cn=InfoGlue*)";
            if (groupsFilter != null && groupsFilter.length() > 0) {
                searchFilter = groupsFilter;
            }
            String groupsAttribute = "distinguishedName";
            if (groupsAttributeFilter != null && groupsAttributeFilter.length() > 0) {
                groupsAttribute = groupsAttributeFilter;
            }
            String[] attrID = groupsAttribute.split(",");
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            ctls.setReturningAttributes(attrID);
            NamingEnumeration<SearchResult> answer = ctx.search(baseDN, searchFilter, ctls);
            if (!answer.hasMore()) {
                throw new Exception("The was no groups found in the JNDI Data Source.");
            }
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                logger.info((Object)("Group:" + sr.toString() + "\n"));
                Attributes attributes = sr.getAttributes();
                logger.info((Object)("attributes:" + attributes.toString()));
                logger.info((Object)("groupNameAttribute:" + groupNameAttribute));
                Attribute attribute = attributes.get(groupNameAttribute);
                logger.info((Object)("attribute:" + attribute.toString()));
                NamingEnumeration<?> allEnum = attribute.getAll();
                while (allEnum.hasMore()) {
                    String foundGroupName = (String)allEnum.next();
                    logger.info((Object)("foundGroupName:" + foundGroupName));
                    logger.info((Object)(String.valueOf(foundGroupName) + "=" + groupName));
                    if (!foundGroupName.equals(groupName)) continue;
                    Attribute usersAttribute = attributes.get(usersAttributeFilter);
                    logger.info((Object)("usersAttribute:" + usersAttribute.toString()));
                    ArrayList groups = new ArrayList();
                    NamingEnumeration<?> allUsersEnum = usersAttribute.getAll();
                    while (allUsersEnum.hasMore()) {
                        String userName = (String)allUsersEnum.next();
                        logger.info((Object)("userName:" + userName));
                        logger.info((Object)("userBase:" + userBase));
                        if (groupBase != null && userName.indexOf(userBase) > -1 && removeUserBaseDN.equals("true")) {
                            userName = userName.substring(0, userName.indexOf(userBase));
                            userName = userName.substring(0, userName.lastIndexOf(","));
                        }
                        logger.info((Object)("userNameAttribute:" + userNameAttribute));
                        logger.info((Object)("groupName:" + userName));
                        logger.info((Object)("indexOf:" + userName.indexOf(userNameAttribute)));
                        if (groupNameAttribute != null && userName.indexOf(userNameAttribute) > -1) {
                            userName = userName.substring(userName.indexOf(userNameAttribute) + userNameAttribute.length() + 1);
                        }
                        InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(userName, "", "", "", new ArrayList(), new ArrayList(), false, this);
                        users.add(infoGluePrincipal);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.info((Object)("Could not find Groups: " + e.getMessage()));
        }
        logger.info((Object)"--------------------END---------------------");
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of users yet...");
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of user password yet....");
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support updates of user password yet...");
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of users yet...");
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of roles yet...");
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support creation of groups yet...");
    }

    public void updateInfoGlueGroup(GroupVO roleVO, String[] userNames) throws Exception {
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        throw new SystemException("The JNDI BASIC Authorization module does not support deletion of groups yet...");
    }
}

