/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.util.CmsPropertyHandler;

public class JNDIBasicAuthenticationModule
extends AuthenticationModule {
    private static final Logger logger = Logger.getLogger((String)JNDIBasicAuthenticationModule.class.getName());
    private String loginUrl = null;
    private String logoutUrl = null;
    private String invalidLoginUrl = null;
    private String successLoginUrl = null;
    private String authenticatorClass = null;
    private String authorizerClass = null;
    private String serverName = null;
    private String casServiceUrl = null;
    private String casRenew = null;
    private String casValidateUrl = null;
    private String casProxyValidateUrl = null;
    private String casLogoutUrl = null;
    private String casAuthorizedProxy = null;
    private Properties extraProperties = null;

    public String authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain fc) throws Exception {
        String authenticatedUserName = null;
        HttpSession session = request.getSession();
        String userName = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        String disableRedirect = (String)request.getAttribute("disableRedirect");
        if (userName == null || userName.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            String requestQueryString = request.getQueryString();
            requestQueryString = requestQueryString != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") : String.valueOf(this.loginUrl) + "?referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8");
            logger.info((Object)("redirectUrl:" + redirectUrl));
            if (disableRedirect == null || !disableRedirect.equals("true")) {
                response.sendRedirect(redirectUrl);
            }
            return null;
        }
        boolean isAuthenticated = this.authenticate(userName, password, new HashMap());
        logger.info((Object)("authenticated:" + isAuthenticated));
        authenticatedUserName = userName;
        if (!isAuthenticated) {
            String requestQueryString;
            String referringUrl = request.getRequestURI();
            if (request.getParameter("referringUrl") != null) {
                referringUrl = request.getParameter("referringUrl");
            }
            requestQueryString = (requestQueryString = request.getQueryString()) != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = referringUrl.indexOf("?") > 0 ? String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "&errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") : String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "?errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8");
            logger.info((Object)("redirectUrl:" + redirectUrl));
            if (disableRedirect == null || !disableRedirect.equals("true")) {
                response.sendRedirect(redirectUrl);
            }
            return null;
        }
        return authenticatedUserName;
    }

    public String authenticateUser(Map request) throws Exception {
        String authenticatedUserName = null;
        String userName = (String)request.get("j_username");
        String password = (String)request.get("j_password");
        logger.info((Object)("authenticateUser:userName:" + userName));
        if (userName == null || userName.equals("")) {
            return null;
        }
        boolean isAuthenticated = this.authenticate(userName, password, new HashMap());
        logger.info((Object)("authenticated:" + isAuthenticated));
        if (!isAuthenticated) {
            return null;
        }
        authenticatedUserName = userName;
        return authenticatedUserName;
    }

    public String getLoginDialogUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (CmsPropertyHandler.getApplicationName().equals("deliver")) {
            logger.info((Object)"It was a deliver request... let's keep it simple...");
            String returnAddress = null;
            String referer = request.getHeader("Referer");
            if (referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
                referer = "/";
            }
            logger.info((Object)("successLoginUrl:" + this.successLoginUrl));
            returnAddress = this.successLoginUrl != null ? this.successLoginUrl : String.valueOf(request.getRequestURL().toString()) + "?" + request.getQueryString() + "&referer=" + URLEncoder.encode(referer, "UTF-8") + "&date=" + System.currentTimeMillis();
            logger.info((Object)("returnAddress:" + returnAddress));
            return String.valueOf(request.getContextPath()) + "/ExtranetLogin!loginForm.action?returnAddress=" + URLEncoder.encode(returnAddress, "UTF-8");
        }
        String url = null;
        String userName = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (userName == null || userName.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            String requestQueryString = request.getQueryString();
            requestQueryString = requestQueryString != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(this.loginUrl) + "&referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") : String.valueOf(this.loginUrl) + "?referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8");
            logger.info((Object)("redirectUrl:" + redirectUrl));
            return redirectUrl;
        }
        boolean isAuthenticated = this.authenticate(userName, password, new HashMap());
        logger.info((Object)("authenticated:" + isAuthenticated));
        String authenticatedUserName = userName;
        if (!isAuthenticated) {
            String requestQueryString;
            String referringUrl = request.getRequestURI();
            if (request.getParameter("referringUrl") != null) {
                referringUrl = request.getParameter("referringUrl");
            }
            requestQueryString = (requestQueryString = request.getQueryString()) != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = referringUrl.indexOf("?") > 0 ? String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "&errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") : String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "?errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") + "&returnAddress=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8");
            logger.info((Object)("redirectUrl:" + redirectUrl));
            return redirectUrl;
        }
        return url;
    }

    private boolean authenticate(String userName, String password, Map parameters) throws Exception {
        boolean isAdministrator;
        boolean isAuthenticated = false;
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        boolean matchesRootPassword = CmsPropertyHandler.getMatchesAdministratorPassword(password);
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName) && matchesRootPassword;
        if (isAdministrator || this.bindUserUsingJNDI(userName, password)) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }

    public Principal loginUser(HttpServletRequest request, HttpServletResponse response, Map status) throws Exception {
        return null;
    }

    public boolean logoutUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return false;
    }

    private boolean bindUserUsingJNDI(String userName, String password) {
        String allowAnonymousBind;
        if (!(password != null && !password.equals("") || (allowAnonymousBind = this.extraProperties.getProperty("allowAnonymousBind")) != null && allowAnonymousBind.equalsIgnoreCase("true"))) {
            logger.warn((Object)"Anonymous bind attemped by not giving any password. Not allowed - now using password '--No password given but anonymous binds not allowed--'");
            password = "--No password given but anonymous binds not allowed--";
        }
        boolean result = false;
        InitialDirContext ctx = null;
        String connectionURL = this.extraProperties.getProperty("connectionURL");
        String ldapUserName = this.extraProperties.getProperty("userNamePattern");
        String anonymousUserName = CmsPropertyHandler.getAnonymousUser();
        if (userName.equals(anonymousUserName)) {
            ldapUserName = this.extraProperties.getProperty("anonymousUserNamePattern");
        }
        ldapUserName = ldapUserName.replaceFirst("infoglue.user", userName);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", connectionURL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", ldapUserName);
        env.put("java.naming.security.credentials", password);
        try {
            ctx = new InitialDirContext(env);
            logger.info((Object)("User: " + ldapUserName + " successfully bound."));
            ctx.close();
            result = true;
        }
        catch (Exception e) {
            logger.info((Object)("Could not bind user: " + ldapUserName + ", " + e.getMessage()));
        }
        return result;
    }

    public String getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    public void setAuthenticatorClass(String authenticatorClass) {
        this.authenticatorClass = authenticatorClass;
    }

    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public void setAuthorizerClass(String authorizerClass) {
        this.authorizerClass = authorizerClass;
    }

    public String getInvalidLoginUrl() {
        return this.invalidLoginUrl;
    }

    public void setInvalidLoginUrl(String invalidLoginUrl) {
        this.invalidLoginUrl = invalidLoginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getSuccessLoginUrl() {
        return this.successLoginUrl;
    }

    public void setSuccessLoginUrl(String successLoginUrl) {
        this.successLoginUrl = successLoginUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public String getCasRenew() {
        return this.casRenew;
    }

    public void setCasRenew(String casRenew) {
        this.casRenew = casRenew;
    }

    public String getCasServiceUrl() {
        return this.casServiceUrl;
    }

    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public String getCasProxyValidateUrl() {
        return this.casProxyValidateUrl;
    }

    public void setCasProxyValidateUrl(String casProxyValidateUrl) {
        this.casProxyValidateUrl = casProxyValidateUrl;
    }

    public String getCasAuthorizedProxy() {
        return this.casAuthorizedProxy;
    }

    public void setCasAuthorizedProxy(String casAuthorizedProxy) {
        this.casAuthorizedProxy = casAuthorizedProxy;
    }

    public Object getTransactionObject() {
        return null;
    }

    public void setTransactionObject(Object transactionObject) {
    }

    public String getCasLogoutUrl() {
        return this.casLogoutUrl;
    }

    public void setCasLogoutUrl(String casLogoutUrl) {
        this.casLogoutUrl = casLogoutUrl;
    }

    public boolean enforceJ2EEContainerPrincipal() {
        return false;
    }

    public String getSSOUserName(HttpServletRequest request) throws Exception {
        return null;
    }
}

