/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infoglue.cms.security.AuthorizationModule;

public class InfoGluePrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 7252014421006767620L;
    private final String name;
    private final String displayName;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final List roles;
    private final List groups;
    private Map metaInformation;
    private final boolean isAdministrator;
    private final AuthorizationModule autorizationModule;

    public InfoGluePrincipal(String name, String firstName, String lastName, String email, List roles, List groups, boolean isAdministrator, AuthorizationModule autorizationModule) {
        this(name, name, firstName, lastName, email, roles, groups, isAdministrator, autorizationModule);
    }

    public InfoGluePrincipal(String name, String displayName, String firstName, String lastName, String email, List roles, List groups, boolean isAdministrator, AuthorizationModule autorizationModule) {
        this.name = name;
        this.displayName = displayName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.roles = roles;
        this.groups = groups;
        this.metaInformation = new HashMap();
        this.isAdministrator = isAdministrator;
        this.autorizationModule = autorizationModule;
    }

    public InfoGluePrincipal(String name, String firstName, String lastName, String email, List roles, List groups, Map metaInformation, boolean isAdministrator, AuthorizationModule autorizationModule) {
        this(name, name, firstName, lastName, email, roles, groups, metaInformation, isAdministrator, autorizationModule);
    }

    public InfoGluePrincipal(String name, String displayName, String firstName, String lastName, String email, List roles, List groups, Map metaInformation, boolean isAdministrator, AuthorizationModule autorizationModule) {
        this.name = name;
        this.displayName = displayName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.roles = roles;
        this.groups = groups;
        this.metaInformation = metaInformation;
        this.isAdministrator = isAdministrator;
        this.autorizationModule = autorizationModule;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public List getRoles() {
        return Collections.unmodifiableList(this.roles);
    }

    public List getGroups() {
        return Collections.unmodifiableList(this.groups);
    }

    public Map getMetaInformation() {
        return this.metaInformation;
    }

    public boolean getIsAdministrator() {
        return this.isAdministrator;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InfoGluePrincipal)) {
            return false;
        }
        InfoGluePrincipal another = (InfoGluePrincipal)obj;
        return this.name.equals(another.getName());
    }

    public int hasCode() {
        return this.name.hashCode();
    }

    public AuthorizationModule getAutorizationModule() {
        return this.autorizationModule;
    }
}

