/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Group;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.Role;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;

public class InfoGlueJDBCAuthorizationModule
extends BaseController
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)InfoGlueJDBCAuthorizationModule.class.getName());
    private Properties extraProperties = null;
    private transient Database transactionObject = null;
    protected String connectionName = null;
    protected String connectionPassword = null;
    protected String connectionURL = null;
    protected Driver driver = null;
    protected String driverName = null;

    public boolean getSupportUpdate() {
        return false;
    }

    public boolean getSupportDelete() {
        return false;
    }

    public boolean getSupportCreate() {
        return false;
    }

    protected Connection getConnection() throws SQLException {
        if (this.connectionURL == null) {
            this.connectionURL = this.extraProperties.getProperty("jdbc.connectionURL");
        }
        if (this.connectionName == null) {
            this.connectionName = this.extraProperties.getProperty("jdbc.connectionName");
        }
        if (this.connectionPassword == null) {
            this.connectionPassword = this.extraProperties.getProperty("jdbc.connectionPassword");
        }
        if (this.driverName == null) {
            this.driverName = this.extraProperties.getProperty("jdbc.driverName");
        }
        Connection conn = null;
        if (this.driver == null) {
            try {
                Class<?> clazz = Class.forName(this.driverName);
                this.driver = (Driver)clazz.newInstance();
            }
            catch (Throwable e) {
                throw new SQLException(e.getMessage());
            }
        }
        Properties props = new Properties();
        if (this.connectionName != null) {
            props.put("user", this.connectionName);
        }
        if (this.connectionPassword != null) {
            props.put("password", this.connectionPassword);
        }
        conn = this.driver.connect(this.connectionURL, props);
        conn.setAutoCommit(false);
        return conn;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        boolean isAdministrator;
        logger.info((Object)("getAuthorizedInfoGluePrincipal with userName:" + userName));
        if (userName == null || userName.equals("")) {
            logger.warn((Object)("userName was null or empty - fix your templates:" + userName));
            return null;
        }
        InfoGluePrincipal infogluePrincipal = null;
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName != null && userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            ArrayList roles = new ArrayList();
            ArrayList groups = new ArrayList();
            ResultSet rs = null;
            Connection conn = null;
            Statement ps = null;
            try {
                try {
                    String sql;
                    String roleDescriptionColumn;
                    String roleNameColumn;
                    String userEmailColumn;
                    String userLastNameColumn;
                    String userFirstNameColumn = this.extraProperties.getProperty("jdbc.userFirstNameColumn");
                    if (userFirstNameColumn == null || userFirstNameColumn.equals("")) {
                        userFirstNameColumn = "USER_FIRSTNAME";
                    }
                    if ((userLastNameColumn = this.extraProperties.getProperty("jdbc.userLastNameColumn")) == null || userLastNameColumn.equals("")) {
                        userLastNameColumn = "USER_LASTNAME";
                    }
                    if ((userEmailColumn = this.extraProperties.getProperty("jdbc.userEmailColumn")) == null || userEmailColumn.equals("")) {
                        userEmailColumn = "USER_EMAIL";
                    }
                    if ((roleNameColumn = this.extraProperties.getProperty("jdbc.roleNameColumn")) == null || roleNameColumn.equals("")) {
                        roleNameColumn = "ROLE_NAME";
                    }
                    if ((roleDescriptionColumn = this.extraProperties.getProperty("jdbc.roleDescriptionColumn")) == null || roleDescriptionColumn.equals("")) {
                        roleDescriptionColumn = "ROLE_DESCRIPTION";
                    }
                    if ((sql = this.extraProperties.getProperty("jdbc.userRolesSQL")) == null || sql.equals("")) {
                        sql = "SELECT * from USER, ROLE_USER, ROLE where ROLE_USER.USER = USER.ID AND ROLE_USER.ROLE = ROLE.ID AND USER.USER_NAME = ?";
                    }
                    conn = this.getConnection();
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, userName);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        logger.info((Object)("infoGluePrincipal:" + infogluePrincipal));
                        if (infogluePrincipal != null) {
                            String roleName = rs.getString(roleNameColumn);
                            String description = rs.getString(roleDescriptionColumn);
                            InfoGlueRole infoGlueRole = new InfoGlueRole(roleName, description, this);
                            infogluePrincipal.getRoles().add(infoGlueRole);
                            logger.info((Object)("Added role:" + infoGlueRole.getName()));
                            continue;
                        }
                        String userFirstName = rs.getString(userFirstNameColumn);
                        String userLastName = rs.getString(userLastNameColumn);
                        String userEmail = rs.getString(userEmailColumn);
                        if (userFirstName == null) {
                            userFirstName = userName;
                        }
                        if (userLastName == null) {
                            userLastName = userName;
                        }
                        if (userEmail == null) {
                            userEmail = userName;
                        }
                        String roleName = rs.getString(roleNameColumn);
                        String description = rs.getString(roleDescriptionColumn);
                        InfoGlueRole infoGlueRole = new InfoGlueRole(roleName, description, this);
                        infogluePrincipal = new InfoGluePrincipal(userName, userFirstName, userLastName, userEmail, new ArrayList(), groups, false, this);
                        infogluePrincipal.getRoles().add(infoGlueRole);
                        logger.info((Object)("User read:" + infogluePrincipal.getName()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.info((Object)("An error occurred trying to get jdbc user for " + userName + ":" + e));
                    throw new SystemException(e.getMessage());
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            logger.info((Object)("returning from getAuthorizedInfoGluePrincipal with userName:" + userName));
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole infoglueRole = null;
        ResultSet rs = null;
        Connection conn = null;
        Statement ps = null;
        try {
            try {
                String sql;
                String roleDescriptionColumn = this.extraProperties.getProperty("jdbc.roleDescriptionColumn");
                if (roleDescriptionColumn == null || roleDescriptionColumn.equals("")) {
                    roleDescriptionColumn = "ROLE_DESCRIPTION";
                }
                if ((sql = this.extraProperties.getProperty("jdbc.roleSQL")) == null || sql.equals("")) {
                    sql = "SELECT * from ROLE where ROLE.ROLE_NAME = ?";
                }
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                ps.setString(1, roleName);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String description = rs.getString(roleDescriptionColumn);
                    infoglueRole = new InfoGlueRole(roleName, description, this);
                }
                logger.info((Object)("Role created:" + infoglueRole.getName()));
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred trying to get jdbc user for " + roleName + ":" + e));
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return infoglueRole;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup infoglueGroup = null;
        return infoglueGroup;
    }

    public List authorizeUser(String userName) throws Exception {
        boolean isAdministrator;
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            return roles;
        }
        if (this.transactionObject == null) {
            List roleVOList = RoleController.getController().getRoleVOList(userName);
            for (RoleVO roleVO : roleVOList) {
                InfoGlueRole infoGlueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
                roles.add(infoGlueRole);
            }
            List groupVOList = GroupController.getController().getGroupVOList(userName);
            for (GroupVO groupVO : groupVOList) {
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        } else {
            Collection roleList = RoleController.getController().getRoleList(userName, this.transactionObject);
            for (Role role : roleList) {
                InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                roles.add(infoGlueRole);
            }
            Collection groupList = GroupController.getController().getGroupList(userName, this.transactionObject);
            for (Group group : groupList) {
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        }
        return groups;
    }

    public List getRoles() throws Exception {
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        ResultSet rs = null;
        Connection conn = null;
        Statement ps = null;
        try {
            try {
                String sql;
                String roleDescriptionColumn;
                String roleNameColumn = this.extraProperties.getProperty("jdbc.roleNameColumn");
                if (roleNameColumn == null || roleNameColumn.equals("")) {
                    roleNameColumn = "ROLE_NAME";
                }
                if ((roleDescriptionColumn = this.extraProperties.getProperty("jdbc.roleDescriptionColumn")) == null || roleDescriptionColumn.equals("")) {
                    roleDescriptionColumn = "ROLE_DESCRIPTION";
                }
                if ((sql = this.extraProperties.getProperty("jdbc.rolesSQL")) == null || sql.equals("")) {
                    sql = "SELECT * from ROLE ORDER BY ROLE_NAME";
                }
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                rs = ps.executeQuery();
                while (rs.next()) {
                    String roleName = rs.getString(roleNameColumn);
                    String description = rs.getString(roleDescriptionColumn);
                    InfoGlueRole infoGlueRole = new InfoGlueRole(roleName, description, this);
                    roles.add(infoGlueRole);
                    logger.info((Object)("Role created:" + infoGlueRole.getName()));
                }
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred trying to get all roles:" + e));
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return roles;
    }

    public List getGroups() throws Exception {
        ArrayList groups = new ArrayList();
        return groups;
    }

    public List getUsers() throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        ResultSet rs = null;
        Connection conn = null;
        Statement ps = null;
        try {
            try {
                String sql;
                String roleDescriptionColumn;
                String roleNameColumn;
                String userEmailColumn;
                String userLastNameColumn;
                String userFirstNameColumn;
                String userNameColumn = this.extraProperties.getProperty("jdbc.userNameColumn");
                if (userNameColumn == null || userNameColumn.equals("")) {
                    userNameColumn = "USER_NAME";
                }
                if ((userFirstNameColumn = this.extraProperties.getProperty("jdbc.userFirstNameColumn")) == null || userFirstNameColumn.equals("")) {
                    userFirstNameColumn = "USER_FIRSTNAME";
                }
                if ((userLastNameColumn = this.extraProperties.getProperty("jdbc.userLastNameColumn")) == null || userLastNameColumn.equals("")) {
                    userLastNameColumn = "USER_LASTNAME";
                }
                if ((userEmailColumn = this.extraProperties.getProperty("jdbc.userEmailColumn")) == null || userEmailColumn.equals("")) {
                    userEmailColumn = "USER_EMAIL";
                }
                if ((roleNameColumn = this.extraProperties.getProperty("jdbc.roleNameColumn")) == null || roleNameColumn.equals("")) {
                    roleNameColumn = "ROLE_NAME";
                }
                if ((roleDescriptionColumn = this.extraProperties.getProperty("jdbc.roleDescriptionColumn")) == null || roleDescriptionColumn.equals("")) {
                    roleDescriptionColumn = "ROLE_DESCRIPTION";
                }
                if ((sql = this.extraProperties.getProperty("jdbc.usersRolesSQL")) == null || sql.equals("")) {
                    sql = "SELECT * from USER, ROLE_USER, ROLE where ROLE_USER.USER = USER.ID AND ROLE_USER.ROLE = ROLE.ID ORDER BY USER.USER_NAME";
                }
                conn = this.getConnection();
                ps = conn.prepareStatement(sql);
                String oldUserName = "";
                ArrayList roles = new ArrayList();
                ArrayList groups = new ArrayList();
                String userFirstName = null;
                String userLastName = null;
                String userEmail = null;
                InfoGluePrincipal infoGluePrincipal = null;
                rs = ps.executeQuery();
                while (rs.next()) {
                    InfoGlueRole infoGlueRole;
                    String description;
                    String roleName;
                    String userName = rs.getString(userNameColumn);
                    logger.info((Object)("userName:" + userName));
                    logger.info((Object)("oldUserName:" + oldUserName));
                    if (userName.equals(oldUserName)) {
                        roleName = rs.getString(roleNameColumn);
                        description = rs.getString(roleDescriptionColumn);
                        infoGlueRole = new InfoGlueRole(roleName, description, this);
                        infoGluePrincipal.getRoles().add(infoGlueRole);
                    } else {
                        userFirstName = rs.getString(userFirstNameColumn);
                        userLastName = rs.getString(userLastNameColumn);
                        userEmail = rs.getString(userEmailColumn);
                        if (userFirstName == null) {
                            userFirstName = userName;
                        }
                        if (userLastName == null) {
                            userLastName = userName;
                        }
                        if (userEmail == null) {
                            userEmail = userName;
                        }
                        roleName = rs.getString(roleNameColumn);
                        description = rs.getString(roleDescriptionColumn);
                        infoGlueRole = new InfoGlueRole(roleName, description, this);
                        infoGluePrincipal = new InfoGluePrincipal(userName, userFirstName, userLastName, userEmail, new ArrayList(), groups, false, this);
                        infoGluePrincipal.getRoles().add(infoGlueRole);
                        users.add(infoGluePrincipal);
                        logger.info((Object)("User read:" + infoGluePrincipal.getName()));
                    }
                    oldUserName = userName;
                }
            }
            catch (Exception e) {
                logger.info((Object)("An error occurred trying to get all roles:" + e));
                throw new SystemException(e.getMessage());
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException sQLException) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws Exception {
        return this.getUsers();
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        logger.info((Object)("roleName:" + roleName));
        ArrayList users = new ArrayList();
        return users;
    }

    public List getGroupUsers(String groupName) throws Exception {
        logger.info((Object)("groupName:" + groupName));
        ArrayList users = new ArrayList();
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support updating of users yet...");
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support updates of users yet...");
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support updates of users yet...");
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support updates of user password yet...");
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of users yet...");
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support creation of users yet...");
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support updates of users yet...");
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of roles yet...");
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of roles yet...");
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of roles yet...");
    }

    public void updateInfoGlueGroup(GroupVO roleVO, String[] userNames) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of roles yet...");
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        throw new SystemException("The JDBC BASIC Authorization module does not support deletion of roles yet...");
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public Object getTransactionObject() {
        return this.transactionObject;
    }

    public void setTransactionObject(Object transactionObject) {
        this.transactionObject = (Database)transactionObject;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

