/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.net.URLEncoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.SystemUserController;
import org.infoglue.cms.controllers.kernel.impl.simple.UserControllerProxy;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.util.CmsPropertyHandler;

public class InfoGlueJ2EEAuthenticationModule
extends AuthenticationModule {
    private static final Logger logger = Logger.getLogger((String)InfoGlueJ2EEAuthenticationModule.class.getName());
    private String loginUrl = null;
    private String logoutUrl = null;
    private String invalidLoginUrl = null;
    private String successLoginUrl = null;
    private String authenticatorClass = null;
    private String authorizerClass = null;
    private String serverName = null;
    private String casServiceUrl = null;
    private String casRenew = null;
    private String casValidateUrl = null;
    private String casProxyValidateUrl = null;
    private String casLogoutUrl = null;
    private String casAuthorizedProxy = null;
    private Properties extraProperties = null;
    private transient Database transactionObject = null;

    public String authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain fc) throws Exception {
        String authenticatedUserName = null;
        if (request.getUserPrincipal() != null) {
            logger.info((Object)("The container had the user logged in:" + request.getUserPrincipal()));
            return request.getUserPrincipal().getName();
        }
        logger.info((Object)("No container user logged in:" + request.getUserPrincipal()));
        HttpSession session = request.getSession();
        String userName = request.getParameter("j_username");
        String password = request.getParameter("j_password");
        if (userName == null || userName.equals("")) {
            if (this.loginUrl == null) {
                throw new ServletException("When InfoGlueFilter protects pages that do not receive a 'userName' parameter, it needs a org.infoglue.cms.security.loginUrl filter parameter");
            }
            String requestURI = request.getRequestURI();
            String requestQueryString = request.getQueryString();
            requestQueryString = requestQueryString != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = requestURI.indexOf("?") > 0 ? String.valueOf(request.getContextPath()) + (this.loginUrl.indexOf("/") == 0 ? "" : "/") + this.loginUrl + "&referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8") : String.valueOf(request.getContextPath()) + (this.loginUrl.indexOf("/") == 0 ? "" : "/") + this.loginUrl + "?referringUrl=" + URLEncoder.encode(String.valueOf(requestURI) + requestQueryString, "UTF-8");
            logger.info((Object)("Directing user to [" + request.getContextPath() + (this.loginUrl.indexOf("/") == 0 ? "" : "/") + this.loginUrl + "]"));
            logger.info((Object)("redirectUrl:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            return null;
        }
        boolean isAuthenticated = this.authenticate(userName, password, new HashMap());
        logger.info((Object)("authenticated:" + isAuthenticated));
        authenticatedUserName = userName;
        if (!isAuthenticated) {
            String requestQueryString;
            String referringUrl = request.getRequestURI();
            if (request.getParameter("referringUrl") != null) {
                referringUrl = request.getParameter("referringUrl");
            }
            requestQueryString = (requestQueryString = request.getQueryString()) != null ? "?" + requestQueryString : "";
            logger.info((Object)("requestQueryString:" + requestQueryString));
            String redirectUrl = "";
            redirectUrl = referringUrl.indexOf("?") > 0 ? String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "&errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8") : String.valueOf(this.invalidLoginUrl) + "?userName=" + URLEncoder.encode(userName, "UTF-8") + "?errorMessage=" + URLEncoder.encode("Invalid login - please try again..", "UTF-8") + "&referringUrl=" + URLEncoder.encode(String.valueOf(referringUrl) + requestQueryString, "UTF-8");
            logger.info((Object)("redirectUrl:" + redirectUrl));
            response.sendRedirect(redirectUrl);
            return null;
        }
        return authenticatedUserName;
    }

    public String authenticateUser(Map request) throws Exception {
        String authenticatedUserName = null;
        String userName = (String)request.get("j_username");
        String password = (String)request.get("j_password");
        logger.info((Object)("authenticateUser:userName:" + userName));
        if (userName == null || userName.equals("")) {
            return null;
        }
        boolean isAuthenticated = this.authenticate(userName, password, new HashMap());
        logger.info((Object)("authenticated:" + isAuthenticated));
        if (!isAuthenticated) {
            return null;
        }
        authenticatedUserName = userName;
        return authenticatedUserName;
    }

    public String getLoginDialogUrl(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String returnAddress = null;
        String referer = request.getHeader("Referer");
        if (referer == null || referer.indexOf("ViewStructureToolToolBar.action") != -1) {
            referer = "/";
        }
        logger.info((Object)("successLoginUrl:" + this.successLoginUrl));
        returnAddress = this.successLoginUrl != null ? this.successLoginUrl : String.valueOf(request.getRequestURL().toString()) + "?" + request.getQueryString() + "&referer=" + URLEncoder.encode(referer, "UTF-8") + "&date=" + System.currentTimeMillis();
        logger.info((Object)("returnAddress:" + returnAddress));
        logger.info((Object)("Directing user to [" + request.getContextPath() + (this.loginUrl.indexOf("/") == 0 ? "" : "/") + this.loginUrl + "]"));
        return String.valueOf(request.getContextPath()) + (this.loginUrl.indexOf("/") == 0 ? "" : "/") + this.loginUrl + "?returnAddress=" + URLEncoder.encode(returnAddress, "UTF-8");
    }

    private boolean authenticate(String userName, String password, Map parameters) throws Exception {
        boolean isAdministrator;
        boolean isAuthenticated = false;
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        boolean matchesRootPassword = CmsPropertyHandler.getMatchesAdministratorPassword(password);
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName) && matchesRootPassword;
        if (this.transactionObject != null) {
            if (isAdministrator || SystemUserController.getController().getSystemUserVO(this.transactionObject, userName, password) != null) {
                isAuthenticated = true;
            }
        } else if (isAdministrator || SystemUserController.getController().getSystemUserVO(userName, password) != null) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }

    public Principal loginUser(HttpServletRequest request, HttpServletResponse response, Map status) throws Exception {
        String authenticatedUserName;
        InfoGluePrincipal principal = null;
        if (request.getUserPrincipal() != null && (authenticatedUserName = request.getUserPrincipal().getName()) != null && (principal = UserControllerProxy.getController().getUser(authenticatedUserName)) == null) {
            throw new SystemException("The J2EE-authenticated user " + authenticatedUserName + " was not located in the authorization system's user database.");
        }
        return principal;
    }

    public boolean logoutUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return false;
    }

    public String getAuthenticatorClass() {
        return this.authenticatorClass;
    }

    public void setAuthenticatorClass(String authenticatorClass) {
        this.authenticatorClass = authenticatorClass;
    }

    public String getAuthorizerClass() {
        return this.authorizerClass;
    }

    public void setAuthorizerClass(String authorizerClass) {
        this.authorizerClass = authorizerClass;
    }

    public String getInvalidLoginUrl() {
        return this.invalidLoginUrl;
    }

    public void setInvalidLoginUrl(String invalidLoginUrl) {
        this.invalidLoginUrl = invalidLoginUrl;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public String getSuccessLoginUrl() {
        return this.successLoginUrl;
    }

    public void setSuccessLoginUrl(String successLoginUrl) {
        this.successLoginUrl = successLoginUrl;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public String getCasRenew() {
        return this.casRenew;
    }

    public void setCasRenew(String casRenew) {
        this.casRenew = casRenew;
    }

    public String getCasServiceUrl() {
        return this.casServiceUrl;
    }

    public void setCasServiceUrl(String casServiceUrl) {
        this.casServiceUrl = casServiceUrl;
    }

    public String getCasValidateUrl() {
        return this.casValidateUrl;
    }

    public void setCasValidateUrl(String casValidateUrl) {
        this.casValidateUrl = casValidateUrl;
    }

    public String getCasProxyValidateUrl() {
        return this.casProxyValidateUrl;
    }

    public void setCasProxyValidateUrl(String casProxyValidateUrl) {
        this.casProxyValidateUrl = casProxyValidateUrl;
    }

    public String getCasAuthorizedProxy() {
        return this.casAuthorizedProxy;
    }

    public void setCasAuthorizedProxy(String casAuthorizedProxy) {
        this.casAuthorizedProxy = casAuthorizedProxy;
    }

    public Object getTransactionObject() {
        return this.transactionObject;
    }

    public void setTransactionObject(Object transactionObject) {
        this.transactionObject = (Database)transactionObject;
    }

    public String getCasLogoutUrl() {
        return this.casLogoutUrl;
    }

    public void setCasLogoutUrl(String casLogoutUrl) {
        this.casLogoutUrl = casLogoutUrl;
    }

    public boolean enforceJ2EEContainerPrincipal() {
        return true;
    }

    public String getSSOUserName(HttpServletRequest request) throws Exception {
        return null;
    }
}

