/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.exolab.castor.jdo.Database;
import org.infoglue.cms.controllers.kernel.impl.simple.BaseController;
import org.infoglue.cms.controllers.kernel.impl.simple.CastorDatabaseService;
import org.infoglue.cms.controllers.kernel.impl.simple.GroupController;
import org.infoglue.cms.controllers.kernel.impl.simple.RoleController;
import org.infoglue.cms.controllers.kernel.impl.simple.SystemUserController;
import org.infoglue.cms.entities.kernel.BaseEntityVO;
import org.infoglue.cms.entities.management.Group;
import org.infoglue.cms.entities.management.GroupVO;
import org.infoglue.cms.entities.management.Role;
import org.infoglue.cms.entities.management.RoleVO;
import org.infoglue.cms.entities.management.SystemUser;
import org.infoglue.cms.entities.management.SystemUserVO;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueGroup;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;

public class InfoGlueBasicAuthorizationModule
extends BaseController
implements AuthorizationModule,
Serializable {
    private static final Logger logger = Logger.getLogger((String)InfoGlueBasicAuthorizationModule.class.getName());
    private Properties extraProperties = null;
    private transient Database transactionObject = null;

    public boolean getSupportUpdate() {
        return true;
    }

    public boolean getSupportDelete() {
        return true;
    }

    public boolean getSupportCreate() {
        return true;
    }

    public InfoGluePrincipal getAuthorizedInfoGluePrincipal(String userName) throws Exception {
        boolean isAdministrator;
        if (userName == null || userName.equals("")) {
            try {
                throw new Exception("userName was null or empty - fix your templates:" + userName);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
                return null;
            }
        }
        InfoGluePrincipal infogluePrincipal = null;
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        String administratorEmail = CmsPropertyHandler.getAdministratorEmail();
        boolean bl = isAdministrator = userName != null && userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            infogluePrincipal = new InfoGluePrincipal(userName, "System", "Administrator", administratorEmail, new ArrayList(), new ArrayList(), isAdministrator, this);
        } else {
            ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
            ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
            if (this.transactionObject == null) {
                Database db = CastorDatabaseService.getDatabase();
                try {
                    InfoGlueBasicAuthorizationModule.beginTransaction(db);
                    SystemUser systemUser = SystemUserController.getController().getReadOnlySystemUserWithName(userName, db);
                    if (systemUser != null) {
                        for (Role role : systemUser.getRoles()) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Adding role:" + role.getRoleName()));
                            }
                            InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                            roles.add(infoGlueRole);
                        }
                        for (Group group : systemUser.getGroups()) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Adding group:" + group.getGroupName()));
                            }
                            InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                            groups.add(infoGlueGroup);
                        }
                        infogluePrincipal = new InfoGluePrincipal(userName, systemUser.getFirstName(), systemUser.getLastName(), systemUser.getEmail(), roles, groups, isAdministrator, this);
                    } else {
                        logger.warn((Object)("Could not find user with userName '" + userName + "' - fix your template logic."));
                        infogluePrincipal = null;
                    }
                    InfoGlueBasicAuthorizationModule.commitTransaction(db);
                }
                catch (Exception e) {
                    logger.info((Object)("An error occurred trying to get SystemUser for " + userName + ":" + e));
                    InfoGlueBasicAuthorizationModule.rollbackTransaction(db);
                    throw new SystemException(e.getMessage());
                }
            } else {
                SystemUser systemUser = SystemUserController.getController().getReadOnlySystemUserWithName(userName, this.transactionObject);
                if (systemUser != null) {
                    for (Role role : systemUser.getRoles()) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Adding role:" + role.getRoleName()));
                        }
                        InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                        roles.add(infoGlueRole);
                    }
                    for (Group group : systemUser.getGroups()) {
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)("Adding group:" + group.getGroupName()));
                        }
                        InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                        groups.add(infoGlueGroup);
                    }
                    infogluePrincipal = new InfoGluePrincipal(userName, systemUser.getFirstName(), systemUser.getLastName(), systemUser.getEmail(), roles, groups, isAdministrator, this);
                } else {
                    logger.warn((Object)("Could not find user with userName '" + userName + "' - fix your template logic."));
                    infogluePrincipal = null;
                }
            }
        }
        return infogluePrincipal;
    }

    public InfoGlueRole getAuthorizedInfoGlueRole(String roleName) throws Exception {
        InfoGlueRole infoglueRole = null;
        RoleVO roleVO = null;
        roleVO = this.transactionObject == null ? RoleController.getController().getRoleVOWithId(roleName) : RoleController.getController().getRoleWithName(roleName, this.transactionObject).getValueObject();
        infoglueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
        return infoglueRole;
    }

    public InfoGlueGroup getAuthorizedInfoGlueGroup(String groupName) throws Exception {
        InfoGlueGroup infoglueGroup = null;
        GroupVO groupVO = null;
        groupVO = this.transactionObject == null ? GroupController.getController().getGroupVOWithId(groupName) : GroupController.getController().getGroupWithName(groupName, this.transactionObject).getValueObject();
        infoglueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
        return infoglueGroup;
    }

    public List authorizeUser(String userName) throws Exception {
        boolean isAdministrator;
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
        String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
        boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName);
        if (isAdministrator) {
            return roles;
        }
        if (this.transactionObject == null) {
            List roleVOList = RoleController.getController().getRoleVOList(userName);
            for (RoleVO roleVO : roleVOList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding role:" + roleVO.getRoleName()));
                }
                InfoGlueRole infoGlueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
                roles.add(infoGlueRole);
            }
            List groupVOList = GroupController.getController().getGroupVOList(userName);
            for (GroupVO groupVO : groupVOList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding group:" + groupVO.getGroupName()));
                }
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        } else {
            Collection roleList = RoleController.getController().getRoleList(userName, this.transactionObject);
            for (Role role : roleList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding role:" + role.getRoleName()));
                }
                InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                roles.add(infoGlueRole);
            }
            Collection groupList = GroupController.getController().getGroupList(userName, this.transactionObject);
            for (Group group : groupList) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Adding group:" + group.getGroupName()));
                }
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        }
        return groups;
    }

    public List getRoles() throws Exception {
        ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
        if (this.transactionObject == null) {
            List roleVOList = RoleController.getController().getRoleVOList();
            for (RoleVO roleVO : roleVOList) {
                InfoGlueRole infoGlueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
                roles.add(infoGlueRole);
            }
        } else {
            List roleVOList = RoleController.getController().getRoleVOList(this.transactionObject);
            for (RoleVO roleVO : roleVOList) {
                InfoGlueRole infoGlueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
                roles.add(infoGlueRole);
            }
        }
        return roles;
    }

    public List getGroups() throws Exception {
        ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
        if (this.transactionObject == null) {
            List groupVOList = GroupController.getController().getGroupVOList();
            for (GroupVO groupVO : groupVOList) {
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        } else {
            List groupVOList = GroupController.getController().getGroupVOList(this.transactionObject);
            for (GroupVO groupVO : groupVOList) {
                InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
                groups.add(infoGlueGroup);
            }
        }
        return groups;
    }

    public List getUsers() throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        if (this.transactionObject == null) {
            Database db = CastorDatabaseService.getDatabase();
            try {
                InfoGlueBasicAuthorizationModule.beginTransaction(db);
                List systemUsers = SystemUserController.getController().getSystemUserList(db);
                for (SystemUser systemUser : systemUsers) {
                    ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
                    Collection roleList = systemUser.getRoles();
                    for (Role role : roleList) {
                        InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                        roles.add(infoGlueRole);
                    }
                    ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
                    Collection groupList = systemUser.getGroups();
                    for (Group group : groupList) {
                        InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                        groups.add(infoGlueGroup);
                    }
                    InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUser.getUserName(), systemUser.getFirstName(), systemUser.getLastName(), systemUser.getEmail(), roles, groups, false, this);
                    users.add(infoGluePrincipal);
                }
                InfoGlueBasicAuthorizationModule.commitTransaction(db);
            }
            catch (Exception e) {
                logger.error((Object)("An error occurred so we should not complete the transaction:" + e));
                InfoGlueBasicAuthorizationModule.rollbackTransaction(db);
                throw new SystemException("An error occurred so we should not complete the transaction:" + e, e);
            }
        } else {
            List systemUsers = SystemUserController.getController().getSystemUserList(this.transactionObject);
            for (SystemUser systemUser : systemUsers) {
                ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
                Collection roleList = systemUser.getRoles();
                for (Role role : roleList) {
                    InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                    roles.add(infoGlueRole);
                }
                ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
                Collection groupList = systemUser.getGroups();
                for (Group group : groupList) {
                    InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                    groups.add(infoGlueGroup);
                }
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUser.getUserName(), systemUser.getFirstName(), systemUser.getLastName(), systemUser.getEmail(), roles, groups, false, this);
                users.add(infoGluePrincipal);
            }
        }
        return users;
    }

    public List getFilteredUsers(String firstName, String lastName, String userName, String email, String[] roleIds) throws Exception {
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        if (this.transactionObject == null) {
            List systemUserVOList = SystemUserController.getController().getFilteredSystemUserVOList(firstName, lastName, userName, email, roleIds);
            for (SystemUserVO systemUserVO : systemUserVOList) {
                ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
                List roleVOList = RoleController.getController().getRoleVOList(systemUserVO.getUserName());
                for (RoleVO roleVO : roleVOList) {
                    InfoGlueRole infoGlueRole = new InfoGlueRole(roleVO.getRoleName(), roleVO.getDescription(), this);
                    roles.add(infoGlueRole);
                }
                ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
                List groupVOList = GroupController.getController().getGroupVOList(systemUserVO.getUserName());
                for (GroupVO groupVO : groupVOList) {
                    InfoGlueGroup infoGlueGroup = new InfoGlueGroup(groupVO.getGroupName(), groupVO.getDescription(), this);
                    groups.add(infoGlueGroup);
                }
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUserVO.getUserName(), systemUserVO.getFirstName(), systemUserVO.getLastName(), systemUserVO.getEmail(), roles, groups, false, this);
                users.add(infoGluePrincipal);
            }
        } else {
            List systemUserList = SystemUserController.getController().getFilteredSystemUserList(firstName, lastName, userName, email, roleIds, this.transactionObject);
            for (SystemUser systemUser : systemUserList) {
                ArrayList<InfoGlueRole> roles = new ArrayList<InfoGlueRole>();
                Collection roleList = RoleController.getController().getRoleList(systemUser.getUserName(), this.transactionObject);
                for (Role role : roleList) {
                    InfoGlueRole infoGlueRole = new InfoGlueRole(role.getRoleName(), role.getDescription(), this);
                    roles.add(infoGlueRole);
                }
                ArrayList<InfoGlueGroup> groups = new ArrayList<InfoGlueGroup>();
                Collection groupList = GroupController.getController().getGroupList(systemUser.getUserName(), this.transactionObject);
                for (Group group : groupList) {
                    InfoGlueGroup infoGlueGroup = new InfoGlueGroup(group.getGroupName(), group.getDescription(), this);
                    groups.add(infoGlueGroup);
                }
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUser.getUserName(), systemUser.getFirstName(), systemUser.getLastName(), systemUser.getEmail(), roles, groups, false, this);
                users.add(infoGluePrincipal);
            }
        }
        return users;
    }

    public List getUsers(String roleName) throws Exception {
        return this.getRoleUsers(roleName);
    }

    public List getRoleUsers(String roleName) throws Exception {
        logger.info((Object)("roleName:" + roleName));
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        if (this.transactionObject == null) {
            List systemUserVOList = RoleController.getController().getRoleSystemUserVOList(roleName);
            for (SystemUserVO systemUserVO : systemUserVOList) {
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUserVO.getUserName(), systemUserVO.getFirstName(), systemUserVO.getLastName(), systemUserVO.getEmail(), new ArrayList(), new ArrayList(), false, this);
                users.add(infoGluePrincipal);
            }
        } else {
            List systemUserVOList = RoleController.getController().getRoleSystemUserVOList(roleName, this.transactionObject);
            for (SystemUserVO systemUserVO : systemUserVOList) {
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUserVO.getUserName(), systemUserVO.getFirstName(), systemUserVO.getLastName(), systemUserVO.getEmail(), new ArrayList(), new ArrayList(), false, this);
                users.add(infoGluePrincipal);
            }
        }
        return users;
    }

    public List getGroupUsers(String groupName) throws Exception {
        logger.info((Object)("groupName:" + groupName));
        ArrayList<InfoGluePrincipal> users = new ArrayList<InfoGluePrincipal>();
        if (this.transactionObject == null) {
            List systemUserVOList = GroupController.getController().getGroupSystemUserVOList(groupName);
            for (SystemUserVO systemUserVO : systemUserVOList) {
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUserVO.getUserName(), systemUserVO.getFirstName(), systemUserVO.getLastName(), systemUserVO.getEmail(), new ArrayList(), new ArrayList(), false, this);
                users.add(infoGluePrincipal);
            }
        } else {
            List systemUserVOList = GroupController.getController().getGroupSystemUserVOList(groupName, this.transactionObject);
            for (SystemUserVO systemUserVO : systemUserVOList) {
                InfoGluePrincipal infoGluePrincipal = new InfoGluePrincipal(systemUserVO.getUserName(), systemUserVO.getFirstName(), systemUserVO.getLastName(), systemUserVO.getEmail(), new ArrayList(), new ArrayList(), false, this);
                users.add(infoGluePrincipal);
            }
        }
        return users;
    }

    public void createInfoGluePrincipal(SystemUserVO systemUserVO) throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().create(systemUserVO);
        } else {
            SystemUserController.getController().create(systemUserVO, this.transactionObject);
        }
    }

    public void updateInfoGluePrincipal(SystemUserVO systemUserVO, String[] roleNames, String[] groupNames) throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().update(systemUserVO, roleNames, groupNames);
        } else {
            SystemUserController.getController().update(systemUserVO, roleNames, groupNames, this.transactionObject);
        }
    }

    public void updateInfoGluePrincipalPassword(String userName) throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().updatePassword(userName);
        } else {
            SystemUserController.getController().updatePassword(userName, this.transactionObject);
        }
    }

    public void updateInfoGlueAnonymousPrincipalPassword() throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().updateAnonymousPassword(CmsPropertyHandler.getAnonymousUser());
        } else {
            SystemUserController.getController().updateAnonymousPassword(CmsPropertyHandler.getAnonymousUser(), this.transactionObject);
        }
    }

    public void updateInfoGluePrincipalPassword(String userName, String oldPassword, String newPassword) throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().updatePassword(userName, oldPassword, newPassword);
        } else {
            SystemUserController.getController().updatePassword(userName, oldPassword, newPassword, this.transactionObject);
        }
    }

    public void deleteInfoGluePrincipal(String userName) throws Exception {
        if (this.transactionObject == null) {
            SystemUserController.getController().delete(userName);
        } else {
            SystemUserController.getController().delete(userName, this.transactionObject);
        }
    }

    public void createInfoGlueRole(RoleVO roleVO) throws Exception {
        if (this.transactionObject == null) {
            RoleController.getController().create(roleVO);
        } else {
            RoleController.getController().create(roleVO, this.transactionObject);
        }
    }

    public void updateInfoGlueRole(RoleVO roleVO, String[] userNames) throws Exception {
        if (this.transactionObject == null) {
            RoleController.getController().update(roleVO, userNames);
        } else {
            RoleController.getController().update(roleVO, userNames, this.transactionObject);
        }
    }

    public void deleteInfoGlueRole(String roleName) throws Exception {
        if (this.transactionObject == null) {
            RoleController.getController().delete(roleName);
        } else {
            RoleController.getController().delete(roleName, this.transactionObject);
        }
    }

    public void createInfoGlueGroup(GroupVO groupVO) throws Exception {
        if (this.transactionObject == null) {
            GroupController.getController().create(groupVO);
        } else {
            GroupController.getController().create(groupVO, this.transactionObject);
        }
    }

    public void updateInfoGlueGroup(GroupVO groupVO, String[] userNames) throws Exception {
        if (this.transactionObject == null) {
            GroupController.getController().update(groupVO, userNames);
        } else {
            GroupController.getController().update(groupVO, userNames, this.transactionObject);
        }
    }

    public void deleteInfoGlueGroup(String groupName) throws Exception {
        if (this.transactionObject == null) {
            GroupController.getController().delete(groupName);
        } else {
            GroupController.getController().delete(groupName, this.transactionObject);
        }
    }

    public Properties getExtraProperties() {
        return this.extraProperties;
    }

    public void setExtraProperties(Properties extraProperties) {
        this.extraProperties = extraProperties;
    }

    public Object getTransactionObject() {
        return this.transactionObject;
    }

    public void setTransactionObject(Object transactionObject) {
        this.transactionObject = (Database)transactionObject;
    }

    public BaseEntityVO getNewVO() {
        return null;
    }
}

