/*
 * Decompiled with CFR 0.152.
 */
package org.infoglue.cms.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.infoglue.cms.controllers.kernel.impl.simple.TransactionHistoryController;
import org.infoglue.cms.exception.SystemException;
import org.infoglue.cms.security.AuthenticationModule;
import org.infoglue.cms.security.AuthorizationModule;
import org.infoglue.cms.security.InfoGlueBasicAuthorizationModule;
import org.infoglue.cms.security.InfoGluePrincipal;
import org.infoglue.cms.security.InfoGlueRole;
import org.infoglue.cms.util.CmsPropertyHandler;
import org.infoglue.cms.util.NotificationMessage;
import org.infoglue.deliver.applications.filters.URIMatcher;
import org.infoglue.deliver.util.CacheController;
import org.infoglue.deliver.util.HttpHelper;

public class InfoGlueAuthenticationFilter
implements Filter {
    private static final Logger logger = Logger.getLogger((String)InfoGlueAuthenticationFilter.class.getName());
    public static final String INFOGLUE_FILTER_USER = "org.infoglue.cms.security.user";
    public static String loginUrl = null;
    public static String logoutUrl = null;
    public static String invalidLoginUrl = null;
    public static String successLoginBaseUrl = null;
    public static String authenticatorClass = null;
    public static String authorizerClass = null;
    public static String serverName = null;
    public static String authConstraint = null;
    public static String extraParametersFile = null;
    public static Properties extraProperties = null;
    public static String casValidateUrl = null;
    public static String casProxyValidateUrl = null;
    public static String casServiceUrl = null;
    public static String casLogoutUrl = null;
    public static String casRenew = null;
    private static String FILTER_URIS_PARAMETER = "FilterURIs";
    private FilterConfig filterConfig = null;
    private URIMatcher uriMatcher = null;
    private HttpHelper httpHelper = new HttpHelper();

    public void init(FilterConfig config) throws ServletException {
        loginUrl = config.getInitParameter("org.infoglue.cms.security.loginUrl");
        logoutUrl = config.getInitParameter("org.infoglue.cms.security.logoutUrl");
        invalidLoginUrl = config.getInitParameter("org.infoglue.cms.security.invalidLoginUrl");
        successLoginBaseUrl = config.getInitParameter("org.infoglue.cms.security.successLoginBaseUrl");
        authenticatorClass = config.getInitParameter("org.infoglue.cms.security.authenticatorClass");
        authorizerClass = config.getInitParameter("org.infoglue.cms.security.authorizerClass");
        serverName = config.getInitParameter("org.infoglue.cms.security.serverName");
        authConstraint = config.getInitParameter("org.infoglue.cms.security.authConstraint");
        extraParametersFile = config.getInitParameter("org.infoglue.cms.security.extraParametersFile");
        casValidateUrl = config.getInitParameter("org.infoglue.cms.security.casValidateUrl");
        casProxyValidateUrl = config.getInitParameter("org.infoglue.cms.security.casProxyValidateUrl");
        casServiceUrl = config.getInitParameter("org.infoglue.cms.security.casServiceUrl");
        casLogoutUrl = config.getInitParameter("org.infoglue.cms.security.casLogoutUrl");
        if (extraParametersFile != null) {
            try {
                extraProperties = new Properties();
                extraProperties.load(CmsPropertyHandler.class.getResourceAsStream("/" + extraParametersFile));
            }
            catch (Exception e) {
                logger.error((Object)("Error loading properties from file /" + extraParametersFile + ". Reason:" + e.getMessage()));
                e.printStackTrace();
            }
        }
        try {
            InfoGlueAuthenticationFilter.initializeCMSProperties();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.filterConfig = config;
        String filterURIs = this.filterConfig.getInitParameter(FILTER_URIS_PARAMETER);
        this.uriMatcher = URIMatcher.compilePatterns(this.splitString(filterURIs, ","), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws ServletException, IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        try {
            String logUserName;
            if (CmsPropertyHandler.getServletContext() == null) {
                CmsPropertyHandler.setServletContext(httpServletRequest.getContextPath());
            }
            String URI2 = httpServletRequest.getRequestURI();
            String URL2 = httpServletRequest.getRequestURL().toString();
            if (logger.isInfoEnabled()) {
                logger.info((Object)("URI: + " + URI2));
                logger.info((Object)("URL: + " + URL2));
            }
            String requestURI = URLDecoder.decode(this.getContextRelativeURI(httpServletRequest), "UTF-8");
            if (URI2.indexOf(loginUrl) > -1 || URL2.indexOf(loginUrl) > -1 || URI2.indexOf(invalidLoginUrl) > -1 || URL2.indexOf(invalidLoginUrl) > -1 || URI2.indexOf(logoutUrl) > -1 || URI2.indexOf("Login!logout.action") > -1 || URL2.indexOf(logoutUrl) > -1 || URI2.indexOf("UpdateCache") > -1 || URI2.indexOf("protectedRedirect.jsp") > -1 || this.uriMatcher.matches(requestURI)) {
                fc.doFilter(request, response);
                return;
            }
            if (!(request instanceof HttpServletRequest)) throw new ServletException("InfoGlue Filter protects only HTTP resources");
            if (!(response instanceof HttpServletResponse)) {
                throw new ServletException("InfoGlue Filter protects only HTTP resources");
            }
            HttpSession session = ((HttpServletRequest)request).getSession();
            String sessionTimeout = CmsPropertyHandler.getSessionTimeout();
            if (sessionTimeout == null) {
                sessionTimeout = "1800";
            }
            session.setMaxInactiveInterval(new Integer(sessionTimeout).intValue());
            if (session != null && session.getAttribute(INFOGLUE_FILTER_USER) != null) {
                fc.doFilter(request, response);
                return;
            }
            boolean isAdministrator = false;
            String userName = request.getParameter("j_username");
            String password = request.getParameter("j_password");
            if (userName != null && password != null) {
                String administratorUserName = CmsPropertyHandler.getAdministratorUserName();
                boolean matchesRootPassword = CmsPropertyHandler.getMatchesAdministratorPassword(password);
                boolean bl = isAdministrator = userName.equalsIgnoreCase(administratorUserName) && matchesRootPassword;
            }
            if (!isAdministrator) {
                logger.info((Object)("Principal:" + httpServletRequest.getUserPrincipal()));
                if (httpServletRequest.getUserPrincipal() != null && !(httpServletRequest.getUserPrincipal() instanceof InfoGluePrincipal)) {
                    userName = httpServletRequest.getUserPrincipal().getName();
                    logger.info((Object)"Now trusting the container logged in identity...");
                }
            }
            String authenticatedUserName = userName;
            if (!isAdministrator) {
                String encodedUserNameCookie = this.httpHelper.getCookie(httpServletRequest, "iguserid");
                if (encodedUserNameCookie != null && !encodedUserNameCookie.equals("")) {
                    String servletContextUserName = (String)this.filterConfig.getServletContext().getAttribute(encodedUserNameCookie);
                    logger.info((Object)("servletContextUserName:" + servletContextUserName));
                    if (servletContextUserName != null && !servletContextUserName.equals("")) {
                        authenticatedUserName = servletContextUserName;
                    }
                } else {
                    authenticatedUserName = this.authenticateUser(httpServletRequest, httpServletResponse, fc);
                }
            }
            logger.info((Object)("authenticatedUserName:" + authenticatedUserName));
            if (authenticatedUserName == null) {
                if (userName == null) return;
                NotificationMessage notificationMessage = new NotificationMessage("Login failed:", "Authentication", userName, 201, userName, "name");
                TransactionHistoryController.getController().create(notificationMessage);
                return;
            }
            logger.info((Object)("Getting the principal from user name:" + authenticatedUserName));
            InfoGluePrincipal user = this.getAuthenticatedUser(authenticatedUserName);
            if (user == null || !user.getIsAdministrator() && !this.hasAuthorizedRole(user)) {
                httpServletResponse.sendRedirect("unauthorizedLogin.jsp");
                NotificationMessage notificationMessage = new NotificationMessage("Authorization failed:", "Authorization", authenticatedUserName, 202, authenticatedUserName, "name");
                TransactionHistoryController.getController().create(notificationMessage);
                return;
            }
            CacheController.clearCacheForGroup("personalAuthorizationCache", user.getName());
            if (session != null) {
                session.setAttribute(INFOGLUE_FILTER_USER, (Object)user);
                this.setUserProperties(session, user);
            }
            if ((logUserName = userName) == null || logUserName.equals("") && user != null) {
                logUserName = user.getName();
            }
            if (logUserName == null || logUserName.equals("")) {
                logUserName = authenticatedUserName;
            }
            if (logUserName == null || logUserName.equals("")) {
                logUserName = "Unknown";
            }
            NotificationMessage notificationMessage = new NotificationMessage("Login success:", "Authentication", logUserName, 200, authenticatedUserName, "name");
            TransactionHistoryController.getController().create(notificationMessage);
            if (successLoginBaseUrl != null && !URL2.startsWith(successLoginBaseUrl)) {
                this.checkSuccessRedirect(request, response, URL2);
                return;
            }
            fc.doFilter(request, response);
            return;
        }
        catch (Exception e) {
            logger.error((Object)("Error authenticating user:" + e.getMessage()), (Throwable)e);
            httpServletRequest.setAttribute("error", (Object)new Exception("Error in authentication filter - look at the server error log (usually catalina.out) for reason but the most common one is problem connecting to the database or a faulty connection user or limited access for that account."));
            httpServletResponse.sendError(500);
            return;
        }
    }

    private void setUserProperties(HttpSession session, InfoGluePrincipal user) {
        String preferredLanguageCode = CmsPropertyHandler.getPreferredLanguageCode(user.getName());
        if (preferredLanguageCode != null && preferredLanguageCode.length() > 0) {
            session.setAttribute("locale", (Object)new Locale(preferredLanguageCode));
        } else {
            session.setAttribute("locale", (Object)Locale.ENGLISH);
        }
        String preferredToolId = CmsPropertyHandler.getPreferredToolId(user.getName());
        if (preferredToolId != null && preferredToolId.length() > 0) {
            session.setAttribute("toolId", (Object)new Integer(preferredToolId));
        } else {
            session.setAttribute("toolId", (Object)new Integer(0));
        }
    }

    public void destroy() {
    }

    private void checkSuccessRedirect(ServletRequest request, ServletResponse response, String URL2) throws ServletException, IOException, UnsupportedEncodingException {
        String requestURI = ((HttpServletRequest)request).getRequestURI();
        String requestQueryString = ((HttpServletRequest)request).getQueryString();
        requestQueryString = requestQueryString != null ? "?" + requestQueryString : "";
        String redirectUrl = "";
        redirectUrl = requestURI.indexOf("?") > -1 ? String.valueOf(successLoginBaseUrl) + requestURI + URLEncoder.encode(requestQueryString, "UTF-8") : String.valueOf(successLoginBaseUrl) + requestURI + URLEncoder.encode(requestQueryString, "UTF-8");
        logger.info((Object)("redirectUrl:" + redirectUrl));
        ((HttpServletResponse)response).sendRedirect(redirectUrl);
    }

    private boolean hasAuthorizedRole(InfoGluePrincipal user) {
        boolean isAuthorized = false;
        logger.info((Object)("authConstraint:" + authConstraint));
        if (authConstraint == null || authConstraint.equalsIgnoreCase("")) {
            return true;
        }
        String[] authConstraints = authConstraint.split(";");
        block0: for (InfoGlueRole role : user.getRoles()) {
            logger.info((Object)("role:" + role));
            int i = 0;
            while (i < authConstraints.length) {
                if (role.getName().equalsIgnoreCase(authConstraints[i])) {
                    isAuthorized = true;
                    break block0;
                }
                ++i;
            }
        }
        return isAuthorized;
    }

    private String authenticateUser(HttpServletRequest request, HttpServletResponse response, FilterChain fc) throws ServletException, Exception {
        String authenticatedUserName = null;
        String currentUrl = null;
        if (casServiceUrl != null && casServiceUrl.equals("$currentUrl")) {
            currentUrl = request.getRequestURL() + (request.getQueryString() == null ? "" : "?" + request.getQueryString());
        }
        AuthenticationModule authenticationModule = AuthenticationModule.getAuthenticationModule(null, currentUrl);
        authenticatedUserName = authenticationModule.authenticateUser(request, response, fc);
        return authenticatedUserName;
    }

    private InfoGluePrincipal getAuthenticatedUser(String userName) throws ServletException, Exception {
        AuthorizationModule authorizationModule = null;
        try {
            authorizationModule = (AuthorizationModule)Class.forName(authorizerClass).newInstance();
        }
        catch (Exception e) {
            logger.error((Object)("The authorizationModule-class was wrong:" + e.getMessage() + ": defaulting to infoglue:s own"), (Throwable)e);
            authorizationModule = (AuthorizationModule)Class.forName(InfoGlueBasicAuthorizationModule.class.getName()).newInstance();
        }
        authorizationModule.setExtraProperties(extraProperties);
        logger.info((Object)("authorizerClass:" + authorizerClass + ":" + authorizationModule.getClass().getName()));
        InfoGluePrincipal infoGluePrincipal = authorizationModule.getAuthorizedInfoGluePrincipal(userName);
        logger.info((Object)("infoGluePrincipal:" + infoGluePrincipal));
        if (infoGluePrincipal != null) {
            logger.info((Object)("roles:" + infoGluePrincipal.getRoles()));
            logger.info((Object)("groups:" + infoGluePrincipal.getGroups()));
        }
        return infoGluePrincipal;
    }

    public static void initializeProperties() throws SystemException {
        try {
            authenticatorClass = CmsPropertyHandler.getServerNodeProperty("deliver", "authenticatorClass", true, null);
            authorizerClass = CmsPropertyHandler.getServerNodeProperty("deliver", "authorizerClass", true, null);
            invalidLoginUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "invalidLoginUrl", true, null);
            successLoginBaseUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "successLoginBaseUrl", true, null);
            loginUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "loginUrl", true, null);
            logoutUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "logoutUrl", true, null);
            serverName = CmsPropertyHandler.getServerNodeProperty("deliver", "serverName", true, null);
            casRenew = CmsPropertyHandler.getServerNodeProperty("deliver", "casRenew", true, null);
            casServiceUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "casServiceUrl", true, null);
            casValidateUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "casValidateUrl", true, null);
            casProxyValidateUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "casProxyValidateUrl", true, null);
            casLogoutUrl = CmsPropertyHandler.getServerNodeProperty("deliver", "casLogoutUrl", true, null);
            String extraPropertiesString = CmsPropertyHandler.getServerNodeDataProperty("deliver", "extraSecurityParameters", true, null);
            if (extraPropertiesString != null) {
                logger.info((Object)("Loading extra properties from propertyset. extraPropertiesString:" + extraPropertiesString));
                try {
                    extraProperties = new Properties();
                    extraProperties.load(new ByteArrayInputStream(extraPropertiesString.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                    e.printStackTrace();
                }
            } else {
                String extraPropertiesFile = CmsPropertyHandler.getProperty("extraParametersFile");
                logger.info((Object)("Trying to load extra properties from file. extraPropertiesFile:" + extraPropertiesFile));
                if (extraPropertiesFile != null) {
                    try {
                        extraProperties = new Properties();
                        extraProperties.load(CmsPropertyHandler.class.getResourceAsStream("/" + extraPropertiesFile));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error loading properties from file /" + extraPropertiesFile + ". Reason:" + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }
            logger.info((Object)("authenticatorClass:" + authenticatorClass));
            logger.info((Object)("authorizerClass:" + authorizerClass));
            logger.info((Object)("invalidLoginUrl:" + invalidLoginUrl));
            logger.info((Object)("successLoginBaseUrl:" + successLoginBaseUrl));
            logger.info((Object)("loginUrl:" + loginUrl));
            logger.info((Object)("logoutUrl:" + logoutUrl));
            logger.info((Object)("serverName:" + serverName));
            logger.info((Object)("casRenew:" + casRenew));
            logger.info((Object)("casServiceUrl:" + casServiceUrl));
            logger.info((Object)("casValidateUrl:" + casValidateUrl));
            logger.info((Object)("casProxyValidateUrl:" + casProxyValidateUrl));
            logger.info((Object)("casLogoutUrl:" + casLogoutUrl));
            if (logger.isDebugEnabled()) {
                if (extraProperties != null) {
                    extraProperties.list(System.out);
                } else {
                    logger.info((Object)("extraProperties:" + extraProperties));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException("Setting the security parameters failed: " + e.getMessage(), e);
        }
    }

    public static void initializeCMSProperties() throws SystemException {
        try {
            String authenticatorClass = CmsPropertyHandler.getServerNodeProperty("authenticatorClass", true, "org.infoglue.cms.security.InfoGlueBasicAuthenticationModule");
            String authorizerClass = CmsPropertyHandler.getServerNodeProperty("authorizerClass", true, "org.infoglue.cms.security.InfoGlueBasicAuthorizationModule");
            String invalidLoginUrl = CmsPropertyHandler.getServerNodeProperty("invalidLoginUrl", true, "Login!invalidLogin.action");
            String successLoginBaseUrl = CmsPropertyHandler.getServerNodeProperty("successLoginBaseUrl", true, null);
            String loginUrl = CmsPropertyHandler.getServerNodeProperty("loginUrl", true, "Login.action");
            String logoutUrl = CmsPropertyHandler.getServerNodeProperty("logoutUrl", true, "Login!logout.action");
            String serverName = CmsPropertyHandler.getServerNodeProperty("serverName", true, null);
            String casRenew = CmsPropertyHandler.getServerNodeProperty("casRenew", true, null);
            String casServiceUrl = CmsPropertyHandler.getServerNodeProperty("casServiceUrl", true, null);
            String casValidateUrl = CmsPropertyHandler.getServerNodeProperty("casValidateUrl", true, null);
            String casProxyValidateUrl = CmsPropertyHandler.getServerNodeProperty("casProxyValidateUrl", true, null);
            String casLogoutUrl = CmsPropertyHandler.getServerNodeProperty("casLogoutUrl", true, null);
            String authConstraint = CmsPropertyHandler.getServerNodeProperty("authConstraint", true, "cmsUser");
            InfoGlueAuthenticationFilter.authenticatorClass = authenticatorClass;
            InfoGlueAuthenticationFilter.authorizerClass = authorizerClass;
            InfoGlueAuthenticationFilter.invalidLoginUrl = invalidLoginUrl;
            InfoGlueAuthenticationFilter.successLoginBaseUrl = successLoginBaseUrl;
            InfoGlueAuthenticationFilter.loginUrl = loginUrl;
            InfoGlueAuthenticationFilter.logoutUrl = logoutUrl;
            InfoGlueAuthenticationFilter.serverName = serverName;
            InfoGlueAuthenticationFilter.casRenew = casRenew;
            InfoGlueAuthenticationFilter.authConstraint = authConstraint;
            InfoGlueAuthenticationFilter.casServiceUrl = casServiceUrl;
            InfoGlueAuthenticationFilter.casValidateUrl = casValidateUrl;
            InfoGlueAuthenticationFilter.casProxyValidateUrl = casProxyValidateUrl;
            InfoGlueAuthenticationFilter.casLogoutUrl = casLogoutUrl;
            String extraPropertiesString = CmsPropertyHandler.getServerNodeDataProperty("deliver", "extraSecurityParameters", true, null);
            if (extraPropertiesString != null) {
                logger.info((Object)("Loading extra properties from propertyset. extraPropertiesString:" + extraPropertiesString));
                try {
                    extraProperties = new Properties();
                    extraProperties.load(new ByteArrayInputStream(extraPropertiesString.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    logger.error((Object)("Error loading properties from string. Reason:" + e.getMessage()));
                    e.printStackTrace();
                }
            } else {
                String extraPropertiesFile = CmsPropertyHandler.getProperty("extraParametersFile");
                logger.info((Object)("Trying to load extra properties from file. extraPropertiesFile:" + extraPropertiesFile));
                if (extraPropertiesFile != null) {
                    try {
                        extraProperties = new Properties();
                        extraProperties.load(CmsPropertyHandler.class.getResourceAsStream("/" + extraPropertiesFile));
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error loading properties from file /" + extraPropertiesFile + ". Reason:" + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            }
            logger.info((Object)("authenticatorClass:" + authenticatorClass));
            logger.info((Object)("authorizerClass:" + authorizerClass));
            logger.info((Object)("invalidLoginUrl:" + invalidLoginUrl));
            logger.info((Object)("successLoginBaseUrl:" + successLoginBaseUrl));
            logger.info((Object)("loginUrl:" + loginUrl));
            logger.info((Object)("logoutUrl:" + logoutUrl));
            logger.info((Object)("serverName:" + serverName));
            logger.info((Object)("authConstraint:" + authConstraint));
            logger.info((Object)("casRenew:" + casRenew));
            logger.info((Object)("casServiceUrl:" + casServiceUrl));
            logger.info((Object)("casValidateUrl:" + casValidateUrl));
            logger.info((Object)("casProxyValidateUrl:" + casProxyValidateUrl));
            logger.info((Object)("casLogoutUrl:" + casLogoutUrl));
            if (logger.isDebugEnabled()) {
                if (extraProperties != null) {
                    extraProperties.list(System.out);
                } else {
                    logger.info((Object)("extraProperties:" + extraProperties));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("An error occurred so we should not complete the transaction:" + e), (Throwable)e);
            throw new SystemException("Setting the security parameters failed: " + e.getMessage(), e);
        }
    }

    private String getContextRelativeURI(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath != null && requestURI.length() > 0) {
            requestURI = requestURI.substring(contextPath.length(), requestURI.length());
        }
        if (requestURI.length() == 0) {
            return "/";
        }
        return requestURI;
    }

    private String[] splitString(String str, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(str, delimiter);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.startsWith("_")) break;
            list.add(t.trim());
        }
        return list.toArray(new String[list.size()]);
    }
}

